<%@ page errorPage="error.jsp" %>
<%@page pageEncoding="UTF-8"%>
<%@page import="java.util.*,
        java.io.*,
        java.nio.*,
        java.nio.charset.*,
        java.net.*,
        java.sql.*,
        java.lang.*,
        java.text.*,
        java.util.zip.*,
        java.util.regex.*,
        java.security.*,
        java.security.spec.*,
        javax.crypto.*,
        javax.crypto.spec.*,
        java.util.Base64,
        blackboard.base.*,
        blackboard.db.*,
        blackboard.persist.user.*,
        blackboard.persist.user.impl.*,
        blackboard.persist.course.*,
        blackboard.persist.gradebook.*,
        blackboard.platform.plugin.*,
        blackboard.platform.plugin.impl.*,
        blackboard.data.content.*,
        blackboard.platform.db.*,
        blackboard.platform.session.*,
        blackboard.platform.config.*,
        blackboard.platform.context.*,
        blackboard.data.course.*,
        blackboard.data.user.*,
        blackboard.data.gradebook.*,
        blackboard.data.gradebook.impl.*,
        blackboard.persist.gradebook.impl.*,
        blackboard.platform.filesystem.*,
        blackboard.platform.persistence.*,
        blackboard.platform.context.impl.*,
        blackboard.platform.vxi.data.*,
        blackboard.platform.vxi.persist.impl.*,
        blackboard.platform.vxi.service.*,
        blackboard.platform.*,
        blackboard.platform.log.*,
        blackboard.util.*,
        blackboard.xml.*,
        blackboard.persist.*,
        java.security.MessageDigest,
        java.util.Properties,
        com.nimbusds.jose.*,
        com.nimbusds.jose.crypto.*,
        com.nimbusds.jose.jwk.*,
        com.nimbusds.jose.jwk.source.*,
        com.nimbusds.jose.proc.*,
        com.nimbusds.jose.util.*,
        com.nimbusds.jwt.*,
        com.nimbusds.jwt.proc.*" %>

<%@ include file="util.jsp" %>

<%!
    // Google OIDC configuration constants
    // GOOGLE_ISSUER and GOOGLE_JWKS_URL are standard Google endpoints (hardcoded)
    public static final String GOOGLE_ISSUER = "https://accounts.google.com";
    public static final String GOOGLE_JWKS_URL = "https://www.googleapis.com/oauth2/v3/certs";
    public static final long JWKS_CACHE_DURATION = 3600000;
    
    // Whitelist of trusted service account emails from the GCP project
    // Add all service accounts that should be allowed to authenticate
    private static final String[] TRUSTED_SERVICE_ACCOUNTS = {
        "firebase-app-hosting-compute@eacvisualdata.iam.gserviceaccount.com"
    };
    
    // JWKS cache for Google public keys
    private static JWKSource<SecurityContext> jwkSource;
    private static long jwksLastUpdated = 0;
    
    // Initialize JWKS source for Google public keys
    private static synchronized JWKSource<SecurityContext> getJWKSource() throws Exception {
        long now = System.currentTimeMillis();
        
        if (jwkSource == null || (now - jwksLastUpdated) > JWKS_CACHE_DURATION) {
            System.err.println("Fetching JWKS from: " + GOOGLE_JWKS_URL);
            
            // Fetch Google's JWKS
            URL url = new URL(GOOGLE_JWKS_URL);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            
            int responseCode = conn.getResponseCode();
            System.err.println("JWKS HTTP response code: " + responseCode);
            
            if (responseCode != 200) {
                throw new Exception("Failed to fetch JWKS. HTTP response code: " + responseCode);
            }
            
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()))) {
                StringBuilder response = new StringBuilder();
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                
                System.err.println("JWKS response length: " + response.length());
                
                // Parse JWKS
                JWKSet jwkSet = JWKSet.parse(response.toString());
                System.err.println("JWKS parsed successfully. Number of keys: " + jwkSet.getKeys().size());
                
                jwkSource = new ImmutableJWKSet<>(jwkSet);
                jwksLastUpdated = now;
                
                System.err.println("JWKS cached successfully");
            }
        } else {
            System.err.println("Using cached JWKS");
        }
        
        return jwkSource;
    }
    

    
    // Validate Google ID token
    private static boolean validateGoogleIDToken(String idToken, javax.servlet.http.HttpServletRequest request) {
        try {
            System.err.println("Starting JWT validation...");
            
            // Parse the JWT
            SignedJWT signedJWT = SignedJWT.parse(idToken);
            System.err.println("JWT parsed successfully");
            
            // Get the JWT claims
            JWTClaimsSet claims = signedJWT.getJWTClaimsSet();
            
            // Get expected audience from the request (same way as checkLicense)
            String expectedAudience = getPath(request, "/api.jsp");
            System.err.println("Expected audience (endpoint): " + expectedAudience);
            
            // Validate issuer
            String issuer = claims.getIssuer();
            System.err.println("JWT issuer: " + issuer);
            if (!GOOGLE_ISSUER.equals(issuer)) {
                System.err.println("Invalid issuer: " + issuer + " (expected: " + GOOGLE_ISSUER + ")");
                return false;
            }
            
            // Validate audience
            String audience = claims.getAudience().get(0);
            System.err.println("JWT audience: " + audience);
            if (!expectedAudience.equals(audience)) {
                System.err.println("Invalid audience: " + audience + " (expected: " + expectedAudience + ")");
                return false;
            }
            
            // Validate expiration
            java.util.Date expiration = claims.getExpirationTime();
            System.err.println("JWT expiration: " + expiration);
            if (expiration == null || expiration.before(new java.util.Date())) {
                System.err.println("Token expired");
                return false;
            }
            
            // Validate service account email against whitelist
            String email = claims.getStringClaim("email");
            System.err.println("JWT email: " + email);
            if (email == null) {
                System.err.println("No email claim in token");
                return false;
            }
            
            boolean isWhitelisted = false;
            for (String trustedAccount : TRUSTED_SERVICE_ACCOUNTS) {
                if (trustedAccount.equals(email)) {
                    isWhitelisted = true;
                    break;
                }
            }
            
            if (!isWhitelisted) {
                System.err.println("Service account not whitelisted: " + email);
                System.err.println("Whitelisted accounts: " + java.util.Arrays.toString(TRUSTED_SERVICE_ACCOUNTS));
                return false;
            }
            
            System.err.println("Service account is whitelisted: " + email);
            
            // Verify signature using Google's public keys
            System.err.println("Fetching JWKS from Google...");
            JWKSource<SecurityContext> jwkSource = getJWKSource();
            System.err.println("JWKS fetched successfully");
            
            JWSKeySelector<SecurityContext> keySelector = new JWSVerificationKeySelector<>(
                JWSAlgorithm.RS256, jwkSource);
            
            // Get the key ID from the header
            String keyId = signedJWT.getHeader().getKeyID();
            System.err.println("JWT key ID: " + keyId);
            if (keyId == null) {
                System.err.println("No key ID in token header");
                return false;
            }
            
            // Find the key in JWKS
            System.err.println("Looking for key with ID: " + keyId);
            List<JWK> keys = jwkSource.get(new JWKSelector(new JWKMatcher.Builder().keyID(keyId).build()), null);
            System.err.println("Found " + keys.size() + " matching keys");
            
            if (keys.isEmpty()) {
                System.err.println("No matching key found for key ID: " + keyId);
                return false;
            }
            
            JWK jwk = keys.get(0);
            if (!(jwk instanceof RSAKey)) {
                System.err.println("Key is not an RSA key");
                return false;
            }
            
            // Verify signature
            System.err.println("Verifying JWT signature...");
            RSAKey rsaKey = (RSAKey) jwk;
            JWSVerifier rsaVerifier = new RSASSAVerifier(rsaKey);
            
            boolean isValid = signedJWT.verify(rsaVerifier);
            System.err.println("JWT signature verification result: " + isValid);
            return isValid;
            
        } catch (Exception e) {
            System.err.println("Token validation failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
    
    // Note: SQL injection protection, JSON conversion, and ResultSet conversion functions
    // are now provided by util.jsp - no need to duplicate them here
%>

<%
    // Set response type to JSON
    response.setContentType("application/json; charset=UTF-8");
    response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
    response.setHeader("Pragma", "no-cache");
    response.setHeader("Expires", "0");
    
    // Initialize response variables
    Map<String, Object> responseData = new HashMap<>();
    String errorMessage = null;
    int statusCode = 200;
    
    try {
        // Check HTTP method
        if (!request.getMethod().equals("POST")) {
            statusCode = 405;
            errorMessage = "Method not allowed. Only POST requests are supported.";
            throw new RuntimeException(errorMessage);
        }
        
        // Check for Authorization header
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            statusCode = 401;
            errorMessage = "Unauthorized. Missing or invalid Authorization header.";
            throw new RuntimeException(errorMessage);
        }
        
        // Extract and validate ID token
        String idToken = authHeader.substring(7);
        if (!validateGoogleIDToken(idToken, request)) {
            statusCode = 401;
            errorMessage = "Unauthorized. Invalid or expired ID token.";
            throw new RuntimeException(errorMessage);
        }
        
        // Get SQL query from request
        String sqlQuery = request.getParameter("query");
        if (sqlQuery == null || sqlQuery.isEmpty()) {
            statusCode = 400;
            errorMessage = "SQL query parameter is required.";
            throw new RuntimeException(errorMessage);
        }
        
        // Decode base64 if needed
        String base64Param = request.getParameter("base64");
        if (base64Param != null && base64Param.equals("true")) {
            sqlQuery = new String(Base64.getDecoder().decode(sqlQuery));
        }
        
        // Initialize Blackboard context
        String pgId = "ea";
        String pgHandle = "eacvis";
        
        VirtualInstallationManager vim = null;
        ContextManager ctxMgr = null;
        request.setAttribute("com.newrelic.agent.IGNORE", true);
        
        ctxMgr = (ContextManager) BbServiceManager.lookupService(ContextManager.class);
        vim = (VirtualInstallationManager) BbServiceManager.lookupService(VirtualInstallationManager.class);
        VirtualHost bh = vim.getVirtualHost(request.getServerName());
        ctxMgr.setContext(bh);
        
        // Parse response type from request (supports new responsetype parameter and backwards-compatible dojson header)
        String responseType = parseResponseType(request);
        
        // Set content type based on response type
        if (responseType.contains("json")) {
            response.setContentType("application/json; charset=UTF-8");
        } else {
            response.setContentType("application/xml; charset=UTF-8");
        }
        
        // Use util.jsp's executeQuery function
        Map<String, Object> queryResult = executeQuery(sqlQuery, responseType);
        statusCode = (Integer) queryResult.get("statusCode");
        
        if (statusCode == 200) {
            // Get the response string directly
            String queryResponse = (String) queryResult.get("response");
            
            // For metadata formats, we may want to add additional info
            if ("json".equals(responseType) || "xml".equals(responseType)) {
                // Metadata format - response already includes success/error structure
                // Response is already in the correct format
            }
            
            // Store response for output
            responseData.put("rawResponse", queryResponse);
        } else {
            // Extract error message from response
            String queryResponse = (String) queryResult.get("response");
            if ("json".equals(responseType) || "rawjson".equals(responseType)) {
                try {
                    JSONParser parser = new JSONParser();
                    JSONObject jsonObj = (JSONObject) parser.parse(queryResponse);
                    if (jsonObj.containsKey("error")) {
                        JSONObject errorObj = (JSONObject) jsonObj.get("error");
                        errorMessage = (String) errorObj.get("message");
                    }
                } catch (Exception e) {
                    errorMessage = "Error executing SQL query";
                }
            } else {
                // XML error - extract from XML
                errorMessage = "Error executing SQL query";
            }
        }
        
        // Release Blackboard context
        if (ctxMgr != null) {
            ctxMgr.releaseContext();
        }
        
    } catch (Exception e) {
        // Handle errors
        if (errorMessage == null) {
            errorMessage = e.getMessage();
            if (errorMessage == null) {
                errorMessage = "An unexpected error occurred.";
            }
        }
        
        // Log error (in production, use proper logging framework)
        System.err.println("API Error: " + errorMessage);
        e.printStackTrace();
        
    } finally {
        // Send response
        if (statusCode != 200) {
            response.setStatus(statusCode);
        }
        
        // Output the response directly (already formatted by executeQuery)
        if (statusCode == 200 && responseData.containsKey("rawResponse")) {
            out.print(responseData.get("rawResponse"));
        } else if (statusCode != 200) {
            // Error response - use appropriate format
            String responseType = parseResponseType(request);
            if ("json".equals(responseType) || "rawjson".equals(responseType)) {
                out.print(createJSONErrorResponse("API_ERROR", errorMessage != null ? errorMessage : "An error occurred"));
            } else {
                // XML error format
                out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<results><error><errorcode>API_ERROR</errorcode><errormsg>" + 
                         (errorMessage != null ? escapeXmlString(errorMessage) : "An error occurred") + "</errormsg></error></results>");
            }
        }
    }
%>
