page = 'outcome';
var errData,
  key = window.name,
  n_ready = false,
  coli = {},
  coll = {},
  rowi = {},
  rowl = {},
  progs = {},
  srt,
  sot,
  WO = window.opener,
  $L = WO.$L,
  cats = WO.goalCats,
  domain_name = WO.domain_name,
  backup,
  domain_pk1 = WO.domain_pk1,
  fs = WO.fs,
  parentscope = WO.mainscope,
  settings = parentscope.settings,
  rsettings = rfdc()(WO.settings.rubrics),
  query = JSON.parse(
    isDebug()
      ? sessionStorage.getItem(key)
      : Base64Decode(sessionStorage.getItem(key)),
  ),
  bburl = query.bburl,
  dbtype = query.dbtype,
  isOracle = getIsOracle(),
  sessionHash = query.sessionHash,
  token = query.token,
  uid = query.uid,
  ultrastatus = query.ultrastatus,
  username = query.username,
  sys = query.sys,
  OA = SetDefault(query.OA, false),
  DR = [getSqlDate(query.date_from), getSqlDate(query.date_to)],
  appHome = SetDefault(rsettings.home, [1, 5]),
  threshold = SetDefault(rsettings.threshold, 0.6),
  data = {
    sr: [],
    details: [],
    pies: [],
    landscape: [],
    rows: [],
    sls: [],
    lsh: {},
    student: {},
  },
  pts = { max: 1, enabled: false, qThreshold: threshold },
  noProgs = false,
  MAX_QUERIES = 10,
  CHUNK_MIN = 50,
  CHUNK_DEF = OA ? 15 : 3;
const permissions = parentscope.permissions,
  modes = parentscope.modes,
  OME =
    (permissions.ig && modes.includes('instructor')) ||
    (permissions.eg && (modes.includes('enterprise') || OA)) ||
    (permissions.ag && modes.includes('administrator')),
  GGE = permissions.gg,
  PEA = permissions.em || permissions.am;

window.onerror = function (message, source, lineno, colno, error) {
  errData = {
    message: message,
    source: source,
    lineno: lineno,
    colno: colno,
    error: error,
    username: username,
    subject: 'EAC Error',
    bburl: bburl,
    mode: parentscope.mode,
    node: parentscope.GetProgram ? parentscope.GetProgram() : '',
    filter: parentscope.filter,
    datemin: Date2MDY(parentscope.minDate),
    datemax: Date2MDY(parentscope.maxDate),
    page: location.pathname,
    tab:
      mainscope.tab +
      ':' +
      JSON.stringify(mainscope.main.grids.map((g) => g.title)),
    report: JSON.stringify(n_title),
    comment: '',
    version: WO.version,
  };
  send(errData);
  mainscope.err.show = true;
  mainscope.loading = false;
};

// Classes
class RRMap {
  constructor(nrows) {
    Object.assign(this, { c: {}, g: 0, i: {}, n: nrows, u: {} });
    this.p = new Array(nrows).fill('--');
    this.r = _.range(nrows).map((x) => x.toString());
  }
  Add(rubric, row) {
    if (row.pos == 1 && this.c[row.rrpk1] == undefined) ++this.g;
    if (!this.u[row.pos]) this.u[row.pos] = [row.rrpk1];
    else if (!this.u[row.pos].includes(row.rrpk1))
      this.u[row.pos].push(row.rrpk1);
    this.c[row.rrpk1] = rubric.pk1;
    this.i[row.rrpk1] = row.pos - 1;
  }
}
class RAMap {
  constructor() {
    Object.assign(this, { i: {}, p: {}, r: {}, s: {}, t: {} });
  }
  Add(rubric, i) {
    this.i[rubric.rapk1] = i;
    this.p[rubric.rapk1] = OA ? rubric.eis_title : rubric.title;
    this.r[rubric.rapk1] = rubric.qdpk1;
    this.s[rubric.rapk1] = 0;
    this.t[rubric.rapk1] = rubric.term;
  }
}
class StudentRowsItem {
  constructor(row, k) {
    Object.assign(this, rrm.p, {
      course_id: row.course_id,
      pk1: row.user_pk1,
      total: row.rravg,
      skips: k - 1,
      date: row.rev_date.split(' ')[0],
    });
    this.respondent = SetDefault(
      data.student[row.user_pk1].ufullname,
      row.username,
    );
    this.batch_id = SetDefault(data.student[row.user_pk1].ubatch_id, '');
    this.student_id = SetDefault(data.student[row.user_pk1].uuid, '');
    this.reviewer = `${row.rev_lastname}, ${row.rev_firstname}`;
    this[rrm.i[row.rr_pk1]] = row.rravg;
    this.rows = [rrm.i[row.rr_pk1]];
    this.bars = data.row.map((x) => 0);
    this.bars[rowi[row.rr_pk1]] = $.precision(row.rravg, 1e-2);
    this.rapk1 = row.ra_pk1;
    ++ram.s[this.rapk1];
  }
  Add(row) {
    this[rrm.i[row.rr_pk1]] = row.rravg;
    this.rows.push(rrm.i[row.rr_pk1]);
    this.total += row.rravg;
    --this.skips;
    this.bars[rowi[row.rr_pk1]] = $.precision(row.rravg, 1e-2);
  }
  Avg(avg) {
    this.avg = avg;
    this.diff = this.total - avg;
  }
}

// Init
if (!GGE) appHome = appHome.filter((x) => ![9, 10, '10t'].includes(x));
if (!appHome.length) appHome = [1, 5];
data.course = SortObjAry(
  query.crs,
  OA ? 'eis_title' : 'CourseName',
  OA ? 'rdate' : 'title',
);
var rrm = new RRMap(data.course[0].rrows.length),
  ram = new RAMap(),
  n_title = OA
    ? [
        data.course[0].rname,
        data.course[0].rdate,
        data.course.length == 1 ? data.course[0].eis_title : '',
      ]
    : [
        data.course[0].Name,
        ' - ',
        data.course.length == 1 ? data.course[0].title : '',
      ];
$(document).ready(function () {
  document.documentElement.lang = $L._ID;
  document.title = n_title[0];
  $('#footer').html(window.opener.footer);
  LoadAsync().catch(window.onerror);
});

// Initial Queries
async function LoadAsync() {
  let nrows = data.course[0].rrows.length,
    ncols = data.course[0].ncols,
    nr = [],
    gr = [],
    dr = [],
    rapk1s = _.uniq(data.course.map((x) => x.rapk1)),
    TT = true,
    rachunk = arrayChunk(rapk1s, CHUNK_DEF).map((x) => {
      return { '@apk1s': x.join() };
    });
  pts.rThreshold = pts.qThreshold * nrows;
  data.course.forEach((x, i) => {
    x.rrows.forEach((y, j) => {
      rrm.Add(x, y);
      data.rows.push({
        rname: x.Name,
        rpk1: x.qdpk1,
        rr_pk1: y.rrpk1,
        rrow: y.rname,
        no: y.pos,
        cpk1: x.pk1,
      });
    });
    ram.Add(x, i);
    x.course = OA ? '' : `${x.CourseName} (${x.CourseID})`;
    if (x.rtype != 'T') TT = false;
    if (OA) x.enrollment = 0;
  });
  if (TT) mainscope.Warn('This is a No Points rubric.', true);
  data.rows.forEach((x, i) => {
    if (sys[x.rrow]) x.rrow = sys[x.rrow];
    rowi[x.rr_pk1] = x.no - 1;
    rowl[x.rr_pk1] = x.rrow;
  });
  data.row = data.rows.slice(0, nrows);
  let colq = [
    'C4EFAF94-30C0-4BE2-A339-AA8FAAFD7006',
    { '@rpk1': _.uniq(data.course.map((x) => x.qdpk1)).join() },
    'cols',
    (e) => {
      e.forEach((x, i) => {
        if (sys[x.rcol]) x.rcol = sys[x.rcol];
        x.perc = parseFloat(x.perc);
        coli[x.rc_pk1] = parseInt(x.colpos);
        coll[x.rc_pk1] = x.rcol;
      });
      data.col = e.slice(0, ncols);
      let asc = data.col[0].perc < _.last(data.col).perc;
      data.col.forEach(
        (x) =>
          (x.pts = $.precision(
            (asc ? coli[x.rc_pk1] : ncols - 1 - coli[x.rc_pk1]) / (ncols - 1),
            1e-2,
          )),
      );
    },
  ];
  let allRRpk1s = { '@rrpk1': _.uniq(data.rows.map((x) => x.rr_pk1)).join() };
  let aliq = ['9734A7B0-B03A-4EE9-9875-DC1AE1298878', allRRpk1s, 'align'];
  let desc = ['383AA2E0-27CF-453A-85BC-8A8341834AB8', allRRpk1s, 'descs'];
  if (OA) {
    await Promise.all([
      SQLPart(data, 0, 0, [colq, aliq, desc]),
      SQLChunk(
        data,
        'score',
        1,
        0,
        'A8F2CFBE-5D11-41E6-8FFB-46665578DA21',
        DR,
        rachunk,
        (e) => {
          e.forEach((x) => {
            x.rravg = parseFloat(x.rravg);
            x.rev_date = x.rev_date.split(' ')[0];
            x.date = new Date(x.rev_date);
            x.feedback = Untag(x.feedback);
          });
        },
      ),
      SQLChunk(
        data,
        'demo2',
        2,
        0,
        'A008B826-1802-489C-B3B5-21734D7B040A',
        DR,
        rachunk,
      ),
    ]);
  } else {
    await Promise.all([
      SQLPart(data, 0, 0, [colq, aliq, desc]),
      SQLChunk(
        data,
        'score',
        1,
        0,
        '4F303FF7-9003-44CD-BFAD-364C19CD15E3',
        DR,
        rachunk,
        (e) => {
          e.forEach((x) => {
            x.rravg = parseFloat(x.rravg);
            x.rev_date = x.rev_date.split(' ')[0];
            x.date = new Date(x.rev_date);
            x.feedback = Untag(x.feedback);
            x.rowfeedback = Untag(x.rowfeedback);
          });
        },
      ),
      SQLChunk(
        data,
        'normal',
        2,
        0,
        '24032614-1F94-4298-B64C-DDFC6D8D88AC',
        DR,
        rachunk,
        (e) => {
          e.forEach((x) => {
            x.ultra_overall_feedback = Untag(x.ultra_overall_feedback);
          });
        },
      ),
      SQLChunk(
        data,
        'group',
        3,
        0,
        '61B380D6-C0BA-46C2-9AAD-F4203200ED15',
        DR,
        rachunk,
      ),
      SQLChunk(
        data,
        'deleg',
        4,
        0,
        'E3DF5567-EDF9-4A4C-B47C-6BCB8EC3382D',
        DR,
        rachunk,
      ),
      SQLChunk(
        data,
        'degroup',
        5,
        0,
        '69AB96BD-3EE8-4F30-9D97-6A0F8ABD89A6',
        DR,
        rachunk,
      ),
    ]);
  } // Part 2
  data.descs.forEach(
    (x) => (x.rpk1 = data.rows.find((y) => x.rr_pk1 == y.rr_pk1)?.rpk1),
  );
  let rpk1 =
    data.descs.findLast((x) => x.cell_descriptor?.length)?.rpk1 ||
    data.row[0].rpk1;
  Object.assign(data, {
    descCols: data.cols.filter((x) => x.rpk1 == rpk1),
    desc: [],
  });
  for (let row of data.rows) {
    if (row.rpk1 != rpk1 || data.desc.find((x) => x.rr_pk1 == row.rr_pk1))
      continue;
    data.desc.push(
      data.descs
        .filter((x) => x.rr_pk1 == row.rr_pk1)
        .reduce(
          (a, x) => {
            a[x.rc_pk1] = x.cell_descriptor || `[${$L.program_editor.none}]`;
            return a;
          },
          { no: row.no, rrow: row.rrow, rr_pk1: row.rr_pk1 },
        ),
    );
  }
  if (data.score.length == 0) {
    mainscope.title = n_title;
    mainscope.Warn($L.msg.rubric_not_scored, true);
    mainscope.loading = false;
    return;
  }
  if (!OA)
    data.demo2 = data.normal
      .filter(
        (x, i, a) =>
          i == 0 ||
          x.reval_pk1 != a[i - 1].reval_pk1 ||
          x.user_pk1 != a[i - 1].user_pk1,
      )
      .concat(data.group, data.deleg, data.degroup);
  for (let i = 1; i < data.demo2.length; ++i)
    if (
      data.demo2[i].ra_pk1 == data.demo2[i - 1].ra_pk1 &&
      data.demo2[i].reval_pk1 == data.demo2[i - 1].reval_pk1 &&
      data.demo2[i].user_pk1 == data.demo2[i - 1].user_pk1
    )
      data.demo2[i]._delete = true;
  data.demo2 = data.demo2.filter((x) => !x._delete);
  data.score = JoinDict(data.score, data.demo2, 'reval_pk1', false, (a, b) => {
    return a.user_pk1 == b.user_pk1
      ? a.rr_pk1 - b.rr_pk1
      : a.user_pk1 - b.user_pk1;
  });
  data.stupk1s = [
    ...new Set(data[OA ? 'score' : 'demo2'].map((x) => x.user_pk1)),
  ].filter((x) => x);
  let size = Math.max(Math.ceil(data.stupk1s.length / MAX_QUERIES), CHUNK_MIN),
    chunks = arrayChunk(data.stupk1s, size).map((x) => {
      return { $0$: x.join() };
    });
  // Initialize demo1 and demo3 as empty arrays in case chunks is empty
  if (!data.demo1) data.demo1 = [];
  if (!data.demo3) data.demo3 = [];
  if (chunks.length > 0) {
    await Promise.all([
      SQLChunk(
        data,
        'demo1',
        6,
        0,
        '85275f25-ae0f-49a1-a16d-d93972f64430',
        {},
        chunks,
      ),
      SQLChunk(
        data,
        'demo3',
        6,
        0,
        '302c0903-390e-472b-b25f-494148618b7c',
        {},
        chunks,
      ),
    ]);
  }
  parseProgress.reset(true);
  backup = rfdc()(data);
  ProcessData();
}

// Calculate stats
function ProcessData() {
  let dates = data.score.map((x) => x.date),
    repk1 = false,
    reusr = false;
  n_title[1] = `${$.minimum(dates).toISOString().split('T')[0]} - ${$.maximum(dates).toISOString().split('T')[0]}`;
  // Student Demographic
  data.demo1.forEach((x) => {
    x.ubirthdate = x.ubirthdate ? x.ubirthdate.split(' ')[0] : '';
    Object.assign(x, {
      ufullname: `${x.ulastname}, ${x.ufirstname}`,
      progs: [],
      program: '',
      program_pk1: '',
    });
    data.student[x.user_pk1] = rfdc()(x);
  });
  data.demo3.forEach((x) => {
    if (!progs[x.program_pk1]) progs[x.program_pk1] = x.program;
    let student = data.student[x.user_pk1],
      sep = student.progs.length ? '; ' : '';
    student.program_pk1 += sep + x.program_pk1;
    student.program += sep + x.program;
    student.progs.push(x.program_pk1);
  });
  // Student Rows
  let avg = 0,
    k = data.row.length,
    dmean,
    dtot,
    bara,
    bari,
    counts;
  for (let score of data.score) {
    if (!score.user_pk1) {
      if (score.username) score.user_pk1 = score.username;
      else {
        score.user_pk1 = '--';
        score.username = '--';
      }
      if (!data.student[score.user_pk1])
        data.student[score.user_pk1] = {
          ubirthdate: '',
          ulastname: score.username,
          ufirstname: score.username,
          ufullname: score.username,
          progs: [],
          program: '',
          program_pk1: '',
          uemail: '--',
          ubatch_id: '--',
          uuid: '--',
          gender: '',
          department: '',
        };
    }
    if (score.reval_pk1 === repk1 && score.user_pk1 === reusr) {
      _.last(data.sr).Add(score);
      AddLandscapeScore(score, true);
    } else {
      data.sr.push(new StudentRowsItem(score, k));
      AddLandscapeScore(score, false);
      repk1 = score.reval_pk1;
      reusr = score.user_pk1;
    }
    avg += score.rravg;
  }
  avg /= data.sr.length;
  let rVar = 0,
    totals = SortObjAry(data.sr, '-total').map((x) => x.total),
    deno = 0;
  srt = {
    keys: ['row'],
    headers: [$L.r_blueprint.cols[1]],
    model: data.row.map((x, i) => {
      return { row: TruncRow(i + 1, x.rrow), desc: x.rrow };
    }),
    ntypes: [undefined],
    postrows: [
      'total',
      'avg',
      'diff',
      'date',
      'reviewer',
      'batch_id',
      'student_id',
    ],
  };
  srt.postrows.push('course_id');
  srt.model.push(
    {},
    { row: 'Total' },
    { row: 'Peer Avg' },
    { row: 'Diff' },
    { row: 'Date' },
    { row: 'Reviewer', border: 'bottom' },
    { row: 'Usr_batch_uid', hide: true },
    { row: 'Student_id', hide: true },
    { row: 'Course_id', hide: true },
  );
  data.sr.forEach((x, i) => {
    x.Avg(avg);
    srt.keys.push(i.toString());
    srt.headers.push(x.respondent);
    srt.ntypes.push('float');
    if (x.rows.length <= data.row.length)
      x.rows.forEach((y, j) => {
        srt.model[j][i] = x[y];
      });
    srt.postrows.forEach((y, j) => {
      srt.model[rrm.n + j + 1][i] = x[y];
    });
  });
  // Row Analysis
  data.ra = data.row.map((x) => {
    return { rr_pk1: x.rr_pk1, row: x.rrow, no: x.no, bars: [] };
  });
  data.ra.forEach((x) => {
    x.scores = data.sr.map((y) => y[x.no - 1]);
    x.diffs = totals.map((y, j) => y - x.scores[j]);
    x.scores = x.scores.filter((y) => y != '--');
    x.diffs = x.diffs.filter((y) => !isNaN(y));
    x.total = $S.sum(x.scores);
    x.avg = $S.mean(x.scores, x.total);
    x.var = $S.var(x.scores, x.avg);
    x.std = $S.stdev(x.scores, x.var);
    rVar += x.var;
    dmean = $S.mean(x.diffs);
    x.dvar = $S.var(x.diffs, dmean);
    x.ptbis = $S.corr(x.scores, x.diffs, x.avg, x.std, dmean, x.dvar);
  });
  data.ra.forEach((x) => (x.cd = $S.kr20(k - 1, rVar - x.var, x.dvar)));
  // Summary Statistics
  data.statMap = $S.summary(totals, k, data.sr, data.score, rVar);
  data.course.forEach((x) => {
    x.responses = ram.s[x.rapk1];
    x.pass = 0;
    x.percent = (100 * x.responses) / x.enrollment;
  });
  // Details
  data.bg = GetColors(data.col.length, 0.75);
  data.bc = GetColors(data.col.length);
  data.bars = {
    datasets: data.col.map((x, i) => {
      return {
        backgroundColor: data.bg[i],
        borderColor: data.bc[i],
        borderWidth: 1,
        data: [],
        stack: 'avg',
        label: x.rcol,
      };
    }),
    labels: [],
  };
  data.row.forEach((row, i) => {
    data.col.forEach((col, j) => {
      if (j == 0)
        data.details.push(
          Object.assign(
            { count: 0, counts: [], total: 0, avg: data.ra[i].avg },
            row,
            col,
          ),
        );
      else data.details.push(Object.assign({ count: 0 }, col));
    });
  });
  data.score.forEach((x) => {
    data.details[rowi[x.rr_pk1] * data.col.length + coli[x.rc_pk1]].count++;
    data.details[rowi[x.rr_pk1] * data.col.length].total++;
  });
  data.details.forEach((x) => {
    if (x.total != undefined) dtot = x.total;
    x.percent = (100 * x.count) / dtot;
    x.dec = x.count / dtot;
    x.level = `${x.count} (${x.percent.toFixed(1)}%) ${x.rcol}`;
    if (x.no) {
      data.pies[x.no] = {
        id: 'pie' + x.no,
        pid: x.no,
        init: mainscope.RA.pies,
        hidebox: true,
        filename: 'Details' + x.rrow,
        data: [x.percent],
      };
      data.bars.labels.push(x.rrow);
      bara = x.avg;
      bari = 0;
      data.bars.datasets[bari].data.push(bara * (x.percent / 100));
      deno = x.no - 1;
      data.ra[deno].bars.push(bara * x.percent);
      counts = x.counts;
    } else {
      _.last(data.pies).data.push(x.percent);
      data.bars.datasets[++bari].data.push(bara * (x.percent / 100));
      data.ra[deno].bars.push(bara * x.percent);
    }
    counts.push(x.count);
  }); // Reviewers
  data.reviewers = [];
  data.reviewersBars = {
    datasets: [],
    labels: [],
  };
  data.reviewerCount = 0;
  
  // Helper function to get consistent reviewer ID from landscape entry
  function getReviewerId(landscape) {
    // Always prefer rev_uid if it exists and is not empty
    if (landscape.rev_uid && landscape.rev_uid.trim() !== '') {
      return landscape.rev_uid.trim();
    }
    // Fallback to formatted name if no UID
    if (landscape.rev_lastname && landscape.rev_firstname) {
      return `${landscape.rev_lastname.trim()}, ${landscape.rev_firstname.trim()}`;
    }
    // Last resort
    return landscape.rev_uid || 'Unknown';
  }
  
  // Helper function to get reviewer display name
  function getReviewerName(landscape) {
    if (landscape.rev_lastname && landscape.rev_firstname) {
      return `${landscape.rev_lastname}, ${landscape.rev_firstname}`;
    }
    return landscape.rev_uid || 'Unknown';
  }
  
  // Group landscape data by reviewer
  // Structure: { reviewerId: { name: string, scores: [[], [], ...] } }
  // where scores[rowIndex] contains all scores for that reviewer for that rubric row
  let reviewersData = {};
  let nrows = data.row.length;
  
  // Loop through landscape data once
  data.landscape.forEach((landscape) => {
    let reviewerId = getReviewerId(landscape);
    let reviewerName = getReviewerName(landscape);
    
    // Initialize reviewer if not exists
    if (!reviewersData[reviewerId]) {
      reviewersData[reviewerId] = {
        name: reviewerName,
        scores: new Array(nrows).fill(null).map(() => [])
      };
    }
    
    // Push scores for each rubric row to the appropriate array
    data.row.forEach((row, rowIndex) => {
      let scoreKey = rowIndex + '_points';
      if (landscape[scoreKey] !== undefined && landscape[scoreKey] !== null) {
        let score = parseFloat(landscape[scoreKey]);
        if (!isNaN(score)) {
          reviewersData[reviewerId].scores[rowIndex].push(score);
        }
      }
    });
  });
  
  // Get sorted list of all reviewers
  let reviewers = SortObjAry(Object.keys(reviewersData).map(rid => {
    return { id: rid, name: reviewersData[rid].name };
  }), 'name');
  
  // Store reviewer count for conditional display
  data.reviewerCount = reviewers.length;
  
  // Calculate averages, std dev, and counts - create grid model
  data.row.forEach((row, rowIndex) => {
    reviewers.forEach((rev) => {
      let reviewerScores = reviewersData[rev.id].scores[rowIndex];
      let avg = '--';
      let std = '--';
      let count = reviewerScores.length;
      
      if (reviewerScores.length > 0) {
        let total = $S.sum(reviewerScores);
        avg = $S.mean(reviewerScores, total);
        if (reviewerScores.length > 1) {
          std = $S.stdev(reviewerScores, undefined, avg);
        } else {
          std = 0;
        }
        avg = $.precision(avg, 1e-2);
        std = $.precision(std, 1e-2);
      }
      
      data.reviewers.push({
        no: row.no,
        rrow: row.rrow,
        rr_pk1: row.rr_pk1,
        reviewer: rev.name,
        avg: avg,
        std: std,
        count: count,
      });
    });
  });
  
  // Create chart data - grouped horizontal bar chart
  data.reviewersBars.labels = data.row.map((x, i) => TruncRow(i + 1, x.rrow));
  let colors = GetColors(reviewers.length, 0.75);
  let borderColors = GetColors(reviewers.length, 1);
  reviewers.forEach((rev, revIdx) => {
    let dataset = {
      label: rev.name,
      data: [],
      backgroundColor: colors[revIdx % colors.length],
      borderColor: borderColors[revIdx % borderColors.length],
      borderWidth: 1,
    };
    
    data.row.forEach((row, rowIndex) => {
      let reviewerScores = reviewersData[rev.id].scores[rowIndex];
      if (reviewerScores.length > 0) {
        let total = $S.sum(reviewerScores);
        let avg = $S.mean(reviewerScores, total);
        dataset.data.push($.precision(avg, 1e-2));
      } else {
        dataset.data.push(0);
      }
    });
    
    data.reviewersBars.datasets.push(dataset);
  });
  
  // Student Landscape
  let lsm = {},
    slsRow = {},
    sls1 = [
      'ulastname',
      'ufirstname',
      'uemail',
      'gender',
      'ubirthdate',
      'department',
      'program',
      'program_pk1',
      'uuid',
      'ubatch_id',
    ],
    lsk,
    sls2 = [
      'project',
      'sub_date',
      'course_id',
      'course_name',
      'term_name',
      'rname',
      'rpk1',
      'rev_date',
      'rev_firstname',
      'rev_lastname',
      'rev_uid',
    ],
    sls3 = [],
    sls3h = [],
    sls4 = [
      'overall_score',
      'rubric_max',
      'percent',
      'feedback',
      'ultra_overall_feedback',
    ],
    post = [$L.choice, $L.points, $L.rowfeedback],
    olg = OA ? $L.o_landscape_group : $L.r_landscape_group;
  data.landscape.forEach((x) => {
    let u = data.demo2.find(
      (y) => x.reval_pk1 == y.reval_pk1 && x.user_pk1 == y.user_pk1,
    );
    if (u) Object.assign(x, u);
    x.percent = (100 * x.overall_score) / x.rubric_max;
    x.overall_score = x.overall_score;
    if (!x.term_name) x.term_name = ram.t[x.ra_pk1] ? ram.t[x.ra_pk1] : '--';
    if (x.rev_date) x.rev_date = x.rev_date.split(' ')[0];
    if (x.sub_date) x.sub_date = x.sub_date.split(' ')[0];
    if (x.ubirthdate) x.ubirthdate = x.ubirthdate.split(' ')[0];
    Object.assign(x, data.student[x.user_pk1]);
    if (!lsm[x.user_pk1]) lsm[x.user_pk1] = [x];
    else lsm[x.user_pk1].push(x);
    if (x.overall_score >= pts.rThreshold) {
      ++data.statMap.nPass;
      ++data.course[ram.i[x.ra_pk1]].pass;
    }
  });
  UpdatePassPerc((100 * data.statMap.nPass) / data.statMap.scored);
  data.row.forEach((x, i) => {
    sls3.push(i + '_choice', i + '_points', i + '_feedback');
    sls3h.push(...TruncRow(i + 1, x.rrow, post));
  });
  sls1.forEach((x, i) => {
    data.lsh[x] = olg.col1[i];
  });
  SortObjAry(_.values(data.student), 'ufullname')
    .map((x) => x.user_pk1)
    .forEach((x) => {
      slsRow = {};
      if (!_.isArray(lsm[x])) return;
      SortObjAry(lsm[x], 'ra_pk1', 'reval_pk1').forEach((y, j) => {
        if (j == 0)
          sls1.forEach((z) => {
            slsRow[z] = y[z];
          });
        lsk = $L.col.project + '_' + (j + 1) + '_';
        sls2.forEach((z, k) => {
          slsRow[lsk + z] = y[z];
          data.lsh[lsk + z] = lsk + olg.col2[k];
        });
        sls3.forEach((z, k) => {
          slsRow[lsk + z] = y[z];
          data.lsh[lsk + z] = lsk + sls3h[k];
        });
        sls4.forEach((z, k) => {
          slsRow[lsk + z] = y[z];
          data.lsh[lsk + z] = lsk + olg.col4[k];
        });
      });
      data.sls.push(slsRow);
    }); // Goals
  if (GGE || OME) {
    SyncGoals();
    ProcessGoals();
  }
  n_ready = true;
  notify('');
}
function SyncGoals() {
  data.goal = {};
  // Blueprint
  data.blueprint = data.ra.map((x) => {
    return {
      score: x.total,
      scored: x.scores.length,
      row: x.row,
      no: x.no,
      qpk1: x.rr_pk1,
      cpk1: '1',
      outs: [],
      aligns: [],
      alignmap: {},
    };
  });
  data.align.forEach((x) => {
    let br = data.blueprint[rowi[x.rr_pk1]];
    br.aligns.push(x);
    if (br.alignmap[x.clp_sog_pk1]) ++br.alignmap[x.clp_sog_pk1].count;
    else br.alignmap[x.clp_sog_pk1] = Object.assign(x, { count: 1 });
    if (!data.goal[x.clp_sog_pk1])
      data.goal[x.clp_sog_pk1] = {
        name: x.batch_uid,
        clppk1: x.clp_sog_pk1,
        desc: cats.find((y) => y.clppk1 == x.clp_sog_pk1).desc,
      };
  });
  data.blueprint.forEach((x) => {
    x.outs = _.values(x.alignmap);
    SortObjAry(x.outs, 'batch_uid');
    let batch = x.outs.map((y) => y.batch_uid + (y.count < rrm.g ? '*' : ''));
    x.outcome = batch.join('\n');
    x.xOutcome = batch.join('; ');
  });
}
function ProcessGoals() {
  // Goal Summary
  data.gs = [];
  let goalPairs = SortObjAry(_.pairs(data.goal), (x) => x[1].name),
    outs;
  goalPairs.forEach((x, i) => {
    data.goal[x[0]].index = i;
    let gsrow = {
      clp: x[0],
      name: x[1].name,
      avg: 0,
      total: 0,
      nstu: 0,
      nrows: 0,
      threshold: threshold,
      nmet: 0,
      pmet: 0,
      clppk1: x[1].clppk1,
      desc: x[1].desc,
    };
    data.col.forEach((y) => {
      gsrow[y.colpos + '_n'] = 0;
    });
    data.gs.push(gsrow);
  });
  data.details.forEach((x) => {
    if (x.no != undefined) {
      outs = data.blueprint[x.no - 1].outs.map((y) => y.clp_sog_pk1);
      outs.forEach((y) => {
        let gsrow = data.gs[data.goal[y].index];
        gsrow.avg =
          (gsrow.avg * gsrow.total + x.avg * x.total) / (gsrow.total + x.total);
        if (isNaN(gsrow.avg)) gsrow.avg = '--';
        gsrow.total += x.total;
        ++gsrow.nrows;
        gsrow[x.colpos + '_n'] += x.count;
      });
    } else {
      outs.forEach((y) => {
        let gsrow = data.gs[data.goal[y].index];
        gsrow[x.colpos + '_n'] += x.count;
      });
    }
  });
  data.gsbars = {
    datasets: data.col.map((x, i) => {
      return {
        backgroundColor: data.bg[i],
        borderColor: data.bc[i],
        borderWidth: 1,
        data: [],
        stack: 'avg',
        label: x.rcol,
      };
    }),
    labels: [],
  };
  data.gs.forEach((x) => {
    x.bars = [];
    data.gsbars.labels.push(`${x.name} (${x.total})`);
    x.prows = $.precision((100 * x.nrows) / data.row.length, 1e-1) + '%';
    data.col.forEach((y, i) => {
      x[y.colpos + '_p'] = x.total
        ? ((100 * x[y.colpos + '_n']) / x.total).toFixed(1)
        : '--';
      x.bars.push(((100 * x.avg * x[y.colpos + '_n']) / x.total).toFixed(1));
      x[y.colpos] = `${x[y.colpos + '_n']} (${x[y.colpos + '_p']}%)`;
      data.gsbars.datasets[i].data.push((x.avg * x[y.colpos + '_n']) / x.total);
    });
  });
  // Student Goals
  let stuIds = Array.from(new Set(data.sr.map((x) => x.pk1))),
    goalIds = SortObjAry(_.values(data.goal), 'name').map((x) => x.clppk1),
    iStudent = _.object(stuIds, _.range(stuIds.length)),
    sgProps = {};
  for (let goalId in data.goal) {
    sgProps[goalId] = '--';
    sgProps[goalId + '_s'] = 0;
    sgProps[goalId + '_t'] = 0;
  }
  data.sg = stuIds.map((x) =>
    Object.assign({}, sgProps, {
      respondent: data.student[x].ufullname,
      bars: [],
      sid: data.student[x].uuid,
      uid: data.student[x].ubatch_id,
    }),
  );
  data.score.forEach((x) => {
    let sgRow = data.sg[iStudent[x.user_pk1]];
    data.blueprint[rowi[x.rr_pk1]].outs.forEach((y) => {
      sgRow[y.clp_sog_pk1 + '_s'] += x.rravg;
      sgRow[y.clp_sog_pk1 + '_t']++;
    });
  });
  sot = {
    keys: ['goal'],
    headers: [$L.goal._],
    model: goalIds
      .map((x, i) => {
        return { goal: data.goal[x].name, desc: data.goal[x].desc };
      })
      .concat([
        { hide: true },
        { goal: 'Usr_batch_uid', hide: true },
        { goal: 'Student_id', hide: true },
      ]),
    ntypes: [undefined],
  };
  data.sg.forEach((x, i) => {
    goalIds.forEach((y, j) => {
      if (x[y + '_t'] > 0) x[y] = x[y + '_s'] / x[y + '_t'];
      x.bars.push(x[y]);
      sot.model[j][i] = x[y];
      if (x[y] >= pts.qThreshold) ++data.gs[data.goal[y].index].nmet;
    });
    sot.keys.push(i.toString());
    sot.headers.push(x.respondent);
    sot.ntypes.push('float');
    sot.model[goalIds.length + 1][i] = x.uid;
    sot.model[goalIds.length + 2][i] = x.sid;
  });
  data.gs.forEach((x, i) => {
    x.nstu = _.values(sot.model[i]).filter((y) => _.isNumber(y)).length;
    x.pmet = x.total ? $.precision(x.nmet / x.nstu, 1e-2) : '--';
  });
  data.gsbars.datasets.push({
    label: $L.r_goals_summary.cols[4],
    borderWidth: 1,
    backgroundColor: 'rgba(0, 105, 170, 0.25)',
    borderColor: 'rgba(0, 105, 170, 1)',
    data: data.gs.map((x) => x.pmet),
  });
  data.gsbars.datasets.push({
    label: '--',
    borderWidth: 1,
    backgroundColor: 'rgba(0, 105, 170, 0.5)',
    borderColor: 'rgba(0, 105, 170, 1)',
    data: data.gs.map((x) => 0),
    hidden: true,
  });
}

// Goals Manager
function outBtnR(goals, rows, add, del) {
  mainscope.loading = true;
  let adds = [],
    dels = [],
    ali;
  rows.forEach((row) => {
    goals.forEach((goal) => {
      ali = row.data.aligns
        .filter((x) => x.clp_sog_pk1 == goal.data.clppk1)
        .map((y) => y.rr_pk1);
      if (ali.length > 0) dels.push({ goal: goal.data, row: row.data });
      if (ali.length < rrm.g) {
        rrm.u[row.data.no]
          .filter((x) => !ali.includes(x))
          .forEach((y) => {
            adds.push({ goal: goal.data, row: row.data, qpk1: y });
          });
      }
    });
  });
  if (dels.length > 0 && del) DelAlignmentAsync(dels);
  if (adds.length > 0 && add) AddAlignmentAsync(adds);
  // Update local data
  SyncGoals();
  mainscope.outcomesManager.AddModel(data.blueprint);
  mainscope.loading = false;
}
async function AddAlignmentAsync(adds) {
  let cacs = adds.filter((x) => x.row.outs.length == 0),
    pk = ['', '', ''],
    ret = '',
    qadd = adds.slice();
  if (dbtype == 'oracle')
    pk = [
      'pk1,',
      'clp_alignable_content_SEQ.nextval,',
      'clp_content_alignment_SEQ.nextval,',
    ];
  else if (dbtype == 'pgsql')
    pk = [
      'pk1,',
      "nextval('clp_alignable_content_seq'),",
      "nextval('clp_content_alignment_seq'),",
    ];
  // Change local data
  adds.forEach((x) => {
    data.align.push({
      batch_uid: x.goal.unique_id,
      clp_sog_pk1: x.goal.clppk1,
      rr_pk1: x.qpk1,
    });
  });
  // Insert missing CACs
  if (cacs.length) {
    /*if (dbtype=='oracle')*/ await SQLChunk(
      data,
      false,
      i,
      0,
      'E3BC7869-6E09-41E5-9715-C0262A8F7BD8',
      [pk[0], ret],
      cacs.map((x) => {
        return { $2$: `(${pk[1]} ${x.qpk1},${rrm.c[x.qpk1]})` };
      }),
    );
    //else await SQLPart(data,i,0,[['E3BC7869-6E09-41E5-9715-C0262A8F7BD8', [pk[0], ret, cacs.map(x=>`(${pk[1]} ${x.qpk1},${rrm.c[x.qpk1]})`).join()]]]);
  }
  // Find CAC pk1s
  while (qadd.length) {
    await new Promise((res) => setTimeout(res, 500));
    await SQLPart(data, 1, 0, [
      [
        '3BBFEBA3-D17E-4272-8A2B-C74D56BF534E',
        [
          qadd
            .map(
              (x) =>
                `(cac.rubric_row_pk1=${x.qpk1} and cac.crsmain_pk1=${rrm.c[x.qpk1]})`,
            )
            .join(' or '),
        ],
        'cac',
        (e) => {
          qadd = JoinDict(qadd, e, 'qpk1');
        },
      ],
    ]);
    if (data.cac) {
      let qpk1s = data.cac.map((x) => x.qpk1);
      console.log(qpk1s, qadd);
      qadd = qadd.filter((x) => !qpk1s.includes(x.row.qpk1));
    }
  }
  // Insert CCAs
  /*if (dbtype=='oracle')*/ await SQLChunk(
    data,
    false,
    i,
    0,
    '70E38CCD-9C43-4EB7-A37A-135FB2D9DE48',
    { $0$: pk[0] },
    adds.map((x) => {
      return {
        $1$: `(${pk[2]} ${x.goal.clppk1},'${Untag(x.goal.unique_id).replaceAll("'", "''")}',${x.cacpk1})`,
      };
    }),
  );
  //else await SQLPart(data,i,0,[['70E38CCD-9C43-4EB7-A37A-135FB2D9DE48',[pk[0],adds.map(x=>`(${pk[2]} ${x.goal.clppk1},'${TAG(x.goal.unique_id).replaceAll("'","''")}',${x.cacpk1})`).join()]]]);
}
async function DelAlignmentAsync(dels) {
  // Change local data
  dels.forEach((x) => {
    data.align.forEach((y) => {
      if (y.clp_sog_pk1 == x.goal.clppk1 && rrm.u[x.row.no].includes(y.rr_pk1))
        y.delete = true;
    });
  });
  let alldels = data.align.filter((y) => y.delete);
  data.align = data.align.filter((y) => !y.delete);
  // Find CCAs
  await SQLPart(data, 1, 1, [
    [
      'EFFEEC17-72E0-4398-A8C7-79D1AE833019',
      [
        alldels
          .map(
            (x) =>
              `(cac.rubric_row_pk1=${x.rr_pk1} and cca.clp_sog_pk1=${x.clp_sog_pk1} and cac.crsmain_pk1=${rrm.c[x.rr_pk1]})`,
          )
          .join(' or '),
      ],
      'cca',
    ],
  ]);
  // Delete CCAs
  await SQLPart(data, 1, 2, [
    [
      '6421CBE5-D34B-4BCC-9B8B-BAE2043C3C9B',
      [data.cca.map((x) => x.pk1).join()],
    ],
  ]);
}

// Helper Functions
function AddLandscapeScore(score, merge) {
  let ls = _.last(data.landscape),
    val = { project: ram.p[score.ra_pk1], rname: n_title[0] };
  val[rrm.i[score.rr_pk1] + '_feedback'] = score.rowfeedback;
  val[rrm.i[score.rr_pk1] + '_choice'] = coll[score.rc_pk1];
  val[rrm.i[score.rr_pk1] + '_points'] = score.rravg;
  if (merge) {
    Object.assign(ls, val);
    ls.overall_score += score.rravg;
  } else
    data.landscape.push(
      Object.assign(
        ObjWithout(score, ['rowfeedback', 'rr_pk1', 'rc_pk1', 'rravg']),
        val,
        {
          overall_score: score.rravg,
          rubric_max: data.row.length * pts.max,
          rpk1: ram.r[score.ra_pk1],
        },
      ),
    );
}
function CHeaderGraph(node, event, index, args, cell) {
  if (!mainscope[args.graph].chart) return;
  let checked = $(`.${args.tag}.ag-checked`),
    parent = cell ? node.firstChild.firstChild.firstChild : node.parentNode;
  $('.' + args.tag).removeClass('ag-checked');
  if (
    checked[0] == parent &&
    mainscope[args.graph].chart.data.datasets.length > data.col.length
  )
    mainscope[args.graph].chart.data.datasets.pop();
  else {
    $(parent).toggleClass('ag-checked');
    mainscope[args.graph].chart.data.datasets[data.col.length] = {
      data: data[args.grid][index][args.bar],
      label: data[args.grid][index][args.label],
      borderColor: '#0069aa',
      backgroundColor: 'rgba(0, 105, 170, 0.5)',
      borderWidth: 1,
    };
  }
  mainscope[args.graph].chart.update();
}
function CHeaderGoalGraph(node, event, index, args, cell) {
  if (!mainscope[args.graph].chart) return;
  let checked = $(`.${args.tag}.ag-checked`),
    parent = cell ? node.firstChild.firstChild.firstChild : node.parentNode;
  $('.' + args.tag).removeClass('ag-checked');
  if (checked[0] == parent)
    mainscope[args.graph].chart.data.datasets[data.col.length + 1].hidden =
      true;
  else {
    $(parent).toggleClass('ag-checked');
    mainscope[args.graph].chart.data.datasets[data.col.length + 1] = {
      data: data[args.grid][index][args.bar],
      label: data[args.grid][index][args.label],
      borderColor: '#0069aa',
      backgroundColor: 'rgba(0, 105, 170, 0.5)',
      borderWidth: 1,
      hidden: false,
    };
  }
  mainscope[args.graph].chart.data.datasets[data.col.length].hidden =
    !mainscope[args.graph].chart.data.datasets[data.col.length + 1].hidden;
  mainscope[args.graph].chart.update();
}
function UpdatePassPerc(passPerc) {
  let model = $S.grid(passPerc),
    redo = mainscope.summaryStats;
  data.course.forEach((x) => {
    x.pmet = (100 * x.pass) / x.responses;
  });
  if (redo) mainscope.summaryStats.AddModel(model, $S.col1, $S.pdf);
}

// Angular App Definition
var app = angular
  .module('App', [
    'ngMaterial',
    'ngMessages',
    'ngRoute',
    'ngSanitize',
    'ngAnimate',
  ])
  .controller('Ctrl', [
    '$scope',
    '$window',
    '$interval',
    '$timeout',
    '$mdDialog',
    '$compile',
    function ($scope, $window, $interval, $timeout, $mdDialog, $compile) {
      mainscope = $scope;
      Object.assign($scope, {
        loading: true,
        tab: 'main',
        main: { grids: [] },
        nOutcomes: [],
        $L: $L,
        popnav: true,
        autonav: true,
        saved: true,
        saveFade: null,
        OA: OA,
        title: n_title,
        GGE: GGE,
        PEA: false,
        CITitle: OA
          ? $L.o_projects_included.title
          : $L.r_courses_included.title,
        rsettings: rsettings,
        first: true,
        reviewerCount: 0,
        warning: {
          show: false,
          msg: $L.msg.error,
          ok: false,
          dismiss: false,
          close: false,
        },
      });
      $scope.err = {
        show: false,
        comment: true,
        text: '',
        send: function () {
          errData.comment = $scope.err.text;
          console.log(errData);
          send(errData);
          $scope.err.show = false;
          $scope.err.text = '';
        },
      };
      $scope.Warn = function (msg, dissmissable) {
        $scope.warning.msg = msg;
        $scope.warning.dismiss = dissmissable;
        $scope.warning.show = true;
      };
      $scope.SetGSL = function (gsl = false) {
        $scope.rsettings.gsl = gsl;
        $scope.EX.grids[GGE ? 8 : 6] = gsl
          ? $scope.landscapeStudent
          : $scope.landscape;
      };
      $scope.TransposeSG = function (transpose = false) {
        if (!GGE) return;
        $scope.rsettings.sgt = transpose;
        $scope.EX.grids[7] = transpose
          ? $scope.studentGoalsT
          : $scope.studentGoals;
        $scope.GA.unload();
      };
      $scope.TransposeSR = function (transpose = false) {
        $scope.rsettings.srt = transpose;
        $scope.EX.grids[4] = transpose
          ? $scope.studentRowsT
          : $scope.studentRows;
        $scope.RA.unload();
      };
      $scope.Save = function () {
        rsettings.home = $scope.main.grids.map((g) => g.id);
        parentscope.settings.rubrics = rfdc()(rsettings);
        storedObject.set(uid, parentscope.settings);
        clearTimeout($scope.saveFade);
        $scope.saved = false;
        $scope.saveFade = $timeout(function () {
          $scope.saved = true;
        }, 1000);
      };
      $scope.loadTab = function (name) {
        if (!n_ready) return;
        if ($scope.tab == 'OM' && name == 'main') $scope.OM.update();
        else if ($scope.tab == 'LOA' && name == 'main') $scope.LOA.update();
        else if ($scope.tab == 'PROG' && name == 'main') $scope.PROG.update();
        if ($scope[$scope.tab].unload != undefined) $scope[$scope.tab].unload();
        $scope.tab = name;
        if ($scope[name].load != undefined) $scope[name].load();
      };
      $scope.SideNav = function (state) {
        $scope.popnav = state;
        $scope.autonav = false;
      };
      // executes when eac is ready
      $scope.OnReady = function () {
        if (!n_ready) {
          $timeout($scope.OnReady, 10);
          return;
        }
        // Header
        let rInfo = [
            { rubric: n_title[0], proj: n_title[2], date: n_title[1] },
          ],
          rKeys = ['rubric', 'date'];
        if (pts.enabled)
          rInfo.push(
            { rubric: '', date: '' },
            { rubric: $L.level_editor.download_warning, date: '' },
            _.object(rKeys, $L.level_editor.cols),
            ...pts.col.map((x) => {
              return { rubric: x.rcol, date: x.pts };
            }),
          );
        if ($scope.PROG.enabled)
          rInfo.push(
            { rubric: '', date: '' },
            { rubric: $L.program_editor.warn, date: '' },
            ...$scope.PROG.sel.map((x) => {
              return { rubric: x, date: '' };
            }),
          );
        $scope.reportInfo = new GridBox({
          mode: 'info',
          title: $L.o_info.title,
          keys: rKeys,
          headers: $L.r_info.cols.slice(0, -1),
          model: rInfo,
        });
        // Data
        $scope.studentRows = new GridBox({
          mode: 'studentRows',
          id: 4,
          title: $L.o_student_rows.title,
          keys: [
            'respondent',
            'date',
            'reviewer',
            'total',
            'avg',
            'diff',
          ].concat(rrm.r),
          headers: $L.o_student_rows.cols.concat(
            data.row.map((x, i) => TruncRow(i + 1, x.rrow)),
          ),
          model: data.sr,
          sheet: [
            'respondent',
            'date',
            'reviewer',
            'total',
            'avg',
            'diff',
          ].concat(rrm.r, ['batch_id', 'student_id', 'course_id']),
          sheetNames: $L.o_student_rows.cols.concat(
            data.row.map((x, i) => TruncRow(i + 1, x.rrow)),
            ['Usr_batch_uid', 'Student_id', 'Course_id'],
          ),
          props: {
            rowSelection: 'single',
            suppressRowClickSelection: true,
            onSelectionChanged: $scope.RA.select,
          },
          colProps: [[0], { checkboxSelection: true, pinned: 'left' }],
          auto: true,
          unload: mainscope.RA.unload,
        });
        $scope.studentRowsT = new GridBox({
          mode: 'studentRowsT',
          id: '4t',
          title: $L.r_student_rows.title,
          keys: srt.keys,
          headers: srt.headers,
          //sheet:['00', ...srt.keys.slice(1)],
          //sheetNames:srt.headers,
          model: srt.model,
          auto: true,
          props: {
            rowClassRules: { 'row-invisible': 'data.hide' },
            getRowHeight: (params) => (params.data.hide ? 0 : 46),
            components: {
              agColumnHeader: CHeader,
              customTooltip: CustomTooltip,
            },
          },
          colProps: [
            [0],
            { pinned: 'left', tooltipField: 'desc' },
            _.range(1, data.sr.length + 1),
            {
              headerComponent: CHeader,
              headerComponentParams: {
                func: 'CHeaderGraph',
                args: {
                  tag: 'srt-header',
                  graph: 'rowGraph',
                  grid: 'sr',
                  bar: 'bars',
                  label: 'respondent',
                },
              },
              headerClass: 'header-check',
            },
          ],
          ntypes: srt.ntypes,
          getEnabled: $scope.studentRows,
          unload: mainscope.RA.unload,
        });
        let cikeys = OA
            ? ['eis_title', 'responses', 'pass', 'pmet']
            : [
                'title',
                'course',
                'Instructors',
                'enrollment',
                'responses',
                'percent',
                'pass',
                'pmet',
              ],
          ciheaders = OA
            ? $L.o_projects_included.cols
            : $L.r_courses_included.cols,
          cixkeys = OA ? cikeys : cikeys.concat(['CourseID']),
          ciauto = OA ? cikeys.slice(1) : cikeys.slice(3),
          cixheaders = OA
            ? $L.o_projects_included.cols
            : $L.r_courses_included.sheet,
          cimodel = [
            data.course.reduce(
              (a, x) => {
                a.enrollment += x.enrollment;
                a.responses += x.responses;
                a.percent = $.precision(
                  (100 * a.responses) / a.enrollment,
                  1e-2,
                );
                return a;
              },
              {
                title: 'Overall',
                eis_title: 'Overall',
                enrollment: 0,
                responses: 0,
                pmet: data.statMap.pPass,
                pass: data.statMap.nPass,
              },
            ),
          ];
        $scope.coursesIncluded = new GridBox({
          mode: 'coursesIncluded',
          id: 1,
          title: $scope.CITitle,
          keys: cikeys,
          headers: ciheaders,
          model: data.course,
          sheet: cixkeys,
          sheetNames: cixheaders,
          auto: ciauto,
          autoIfScroll: true,
          props: { domLayout: 'autoHeight', pinnedBottomRowData: cimodel },
        });
        $scope.rubric = new GridBox({
          mode: 'rubric',
          id: 11,
          title: $L.g_crit.rubric,
          keys: ['no', 'rrow'].concat(data.descCols.map((x) => x.rc_pk1)),
          headers: $L.o_row_analysis.cols
            .slice(0, 2)
            .concat(data.descCols.map((x) => x.rcol)),
          model: data.desc,
          auto: ['no'],
          autoIfScroll: true,
          colProps: [
            [1].concat(data.descCols.map((x, i) => i + 2)),
            { wrapText: true, autoHeight: true, minWidth: 120 },
          ],
        });
        $scope.summaryStats = new GridBox({
          mode: 'summaryStats',
          id: 5,
          title: $L.o_summary_stats.title,
          keys: ['d0', 'v0', 's', 'd1', 'v1'],
          headers: $L.o_summary_stats.cols,
          model: $S.col2,
          auto: false,
          autoIfScroll: true,
          props: { domLayout: 'autoHeight' },
          colProps: [
            [2],
            { width: 52 },
            [3, 4],
            { cellClassRules: { highlightbg: 'rowIndex == 5' } },
            [0, 1, 2, 3, 4],
            { sortable: false },
          ],
          filter: false,
          sheet: ['d', 'v'],
          sheetNames: $L.o_summary_stats.sheet,
          sheetData: $S.col1,
          pdfdata: $S.pdf,
        });
        $scope.rowAnalysis = new GridBox({
          mode: 'rowAnalysis',
          id: 6,
          title: $L.o_row_analysis.title,
          keys: ['no', 'row', 'avg', 'std', 'ptbis', 'cd'],
          headers: $L.o_row_analysis.cols,
          model: data.ra,
          auto: ['no', 'avg', 'std', 'ptbis', 'cd'],
          colProps: [[1], { minWidth: 120 }],
          //autoIfNeeded:true,
          pdfwidths: [1],
          pdfbars: 'avg',
        });
        $scope.details = new GridBox({
          mode: 'details',
          id: 7,
          title: $L.o_details.title,
          keys: ['no', 'rrow', 'avg', 'level', 'distribution'],
          headers: $L.o_details.cols,
          model: data.details,
          auto: ['no', 'avg' /*, 'distribution'*/],
          //autoIfNeeded:true,
          props: {
            suppressRowTransform: true,
            rowClassRules: {
              'detail-border': 'data.no != null',
              'detail-noborder': 'data.no == null',
            },
          },
          colProps: [
            [0, 1, 2, 3],
            {
              cellClassRules: { 'detail-pad': 'data.no != null' },
              sortable: false,
            },
            [0, 1, 2, 4],
            { rowSpan: (x) => (x.data.no ? data.col.length : 1) },
            [4],
            {
              sortable: false,
              cellRenderer: 'pieChartCellRenderer',
              valueGetter: function (params) {
                if (params.data.no)
                  return `<eac-chart obj="pies" index="${params.data.no}" style="max-height:100%; max-width:100%;"></eac-chart>`;
              },
            },
            [1, 3, 4],
            { minWidth: 120 },
            [3],
            {
              cellRenderer: (x) => x.value,
              valueGetter: (params) => {
                return `<span style="color:${DefaultColors[params.data.colpos]}; font-size:125%;">&nbsp;&nbsp;&#x25fc;&nbsp;&nbsp;</span><span>${_.escape(params.data.level)}</span>`;
              },
              cellStyle: { display: 'flex', 'align-items': 'center' },
            },
          ],
          filter: false,
          sheet: ['no', 'rrow', 'avg', 'level', 'count', 'dec'],
          sheetNames: $L.r_details.sheet,
          pdfkeys: [0, 1, 2, 3],
          pdfwidths: [1],
          pdfbars: 'percent',
        });
        $scope.pies = data.pies;

        // Reviewers (only show if more than 1 reviewer)
        $scope.reviewerCount = data.reviewerCount;
        if (data.reviewerCount > 1) {
          $scope.reviewers = new GridBox({
            mode: 'reviewers',
            id: 12,
            title: OA ? $L.o_reviewers.title : $L.r_reviewers.title,
            keys: ['no', 'rrow', 'reviewer', 'avg', 'std', 'count'],
            headers: OA ? $L.o_reviewers.cols : $L.r_reviewers.cols,
            model: data.reviewers,
            auto: ['no', 'avg', 'std', 'count'],
            colProps: [
              [0, 1],
              { minWidth: 120 },
              [2, 3, 4, 5],
              { sortable: true },
            ],
            sheet: ['no', 'rrow', 'reviewer', 'avg', 'std', 'count'],
            sheetNames: OA ? $L.o_reviewers.sheet : $L.r_reviewers.sheet,
          });
          
          $scope.reviewersGraph = {
            id: 'reviewersGraph',
            pid: 'reviewersGraphParent',
            init: $scope.REVIEWERS.graph,
            title: OA ? $L.o_reviewers.title : $L.r_reviewers.title,
            filename: OA ? $L.o_reviewers.title : $L.r_reviewers.title,
          };
        }

				// landscape
        let lkeys = [
            'project',
            'sub_date',
            'ufirstname',
            'ulastname',
            'uemail',
            'gender',
            'ubirthdate',
            'department',
            'program',
            'program_pk1',
            'uuid',
            'ubatch_id',
            'course_id',
            'course_name',
            'term_name',
            'rname',
            'rpk1',
            'rev_date',
            'rev_firstname',
            'rev_lastname',
            'rev_uid',
          ],
          lkeys3 = [
            'overall_score',
            'rubric_max',
            'percent',
            'feedback',
            'ultra_overall_feedback',
          ],
          lkeys2 = [],
          rheaders = [],
          suffix = [$L.choice, $L.points, $L.rowfeedback];
        data.row.forEach((x, i) => {
          lkeys2.push(i + '_choice', i + '_points', i + '_feedback');
          rheaders.push(...TruncRow(i + 1, x.rrow, suffix));
        });

        if (OA) {
					let lheaders = $L.o_landscape.cols;
					lkeys.push('rev_batchuid');
          const landscapeKeys = lkeys.concat(lkeys2).concat(lkeys3);
          $scope.landscape = new GridBox({
            mode: 'studentLandscape',
            id: 8,
            title: $L.o_landscape.title,
            keys: landscapeKeys,
            headers: lheaders.concat(rheaders).concat($L.o_landscape.postcols),
            model: data.landscape,
            colProps: [[0, 1, 2, 3], { pinned: 'left' }, [landscapeKeys.length - 1], { tooltipField: 'ultra_overall_feedback' }],
            auto: true,
          });
          $scope.landscapeStudent = new GridBox({
            mode: 'landscapeStudent',
            id: '8t',
            title: $L.o_landscape_group.title,
            keys: _.keys(data.lsh),
            headers: _.values(data.lsh),
            model: data.sls,
            colProps: [[0, 1],{ pinned: 'left' }, [_.keys(data.lsh).length - 1], { tooltipField: 'ultra_overall_feedback' }],
            auto: true,
            getEnabled: $scope.landscape,
          });
        } else {
					let lheaders = $L.r_landscape.cols;
          const landscapeKeys = lkeys.concat(lkeys2).concat(lkeys3);
          $scope.landscape = new GridBox({
            mode: 'studentLandscape',
            id: 8,
            title: $L.r_landscape.title,
            keys: landscapeKeys,
            headers: lheaders.concat(rheaders).concat($L.r_landscape.postcols),
            model: data.landscape,
            colProps: [[0, 1, 2, 3], { pinned: 'left' }, [landscapeKeys.length - 1], { tooltipField: 'ultra_overall_feedback' }],
            auto: true,
          });
          $scope.landscapeStudent = new GridBox({
            mode: 'landscapeStudent',
            id: '8t',
            title: $L.r_landscape_group.title,
            keys: _.keys(data.lsh),
            headers: _.values(data.lsh),
            model: data.sls,
            colProps: [[0, 1],{ pinned: 'left' }, [_.keys(data.lsh).length - 1], { tooltipField: 'ultra_overall_feedback' }],
            auto: true,
            getEnabled: $scope.landscape,
          });
        }

        $scope.rowGraph = {
          id: 'rowGraph',
          pid: 'rowGraphParent',
          init: $scope.RA.graph,
          title: $L.o_row_averages.title,
          filename: $L.o_row_averages.title,
        };
        if (!$scope.backup) {
          Object.assign($scope, {
            noProgs: noProgs,
            backup: { score: data.score, student: data.student },
          });
          $scope.progModel = SortObjAry(
            _.pairs(progs).map((x) => {
              return { id: x[0], name: x[1] };
            }),
            'name',
          );
          if (noProgs)
            $scope.progModel.unshift({ id: -1, name: $L.program_editor.none });
          $scope.PROG.prev = $scope.progModel.map((x) => x.id);
          if ($scope.progModel.length > 1) $scope.PEA = PEA;
        }
        $scope.progEditor = new GridBox({
          mode: 'progEditor',
          title: $L.program_editor.title,
          keys: ['name'],
          headers: $L.program_editor.cols,
          model: $scope.progModel,
          props: {
            rowSelection: 'multiple',
            onSelectionChanged: $scope.PROG.select,
            suppressRowClickSelection: true,
            onGridReady: $scope.PROG.ready,
          },
          colProps: [
            [0],
            { checkboxSelection: true, headerCheckboxSelection: true },
          ],
        });
        if (GGE || OME) $scope.GoalsReady();
        // Exports
        $scope.EX.grids = [
          'reportInfo',
          'coursesIncluded',
          'summaryStats',
          'rowAnalysis',
          'studentRows',
          'details',
          ...(GGE ? ['goalsSummary', 'studentGoals'] : []),
          ...(data.reviewerCount > 1 ? ['reviewers'] : []),
          'landscape',
          'rubric',
          ...(OME ? ['outcomesManager'] : []),
        ].map((x) => $scope[x]);
        $scope.EX['fileName'] = n_title.join('_').replace(' ', '-');
        if ($scope.first) {
          $scope.LOA.col = data.col;
          pts.col = rfdc()(data.col);
          if (rsettings.srt) $scope.TransposeSR(true);
          if (rsettings.sgt) $scope.TransposeSG(true);
          if (rsettings.gsl) $scope.SetGSL(true);
        }
        // Grids are now updated via API, no need to refresh DOM
        $scope.first = false;
        $scope.loading = false; // done loading
      };
      $scope.GoalsReady = function () {
        $scope.nOutcomes = new GoalSelector(cats);
        $scope.outcomesManager = new GridBox({
          mode: 'blueprint',
          title: $L.r_blueprint.title,
          keys: ['no', 'row', 'outcome'],
          headers: $L.r_blueprint.cols,
          model: data.blueprint,
          props: {
            rowSelection: 'multiple',
            suppressRowClickSelection: true,
            onSelectionChanged: $scope.OM.select,
            onGridReady: $scope.OM.ready,
          },
          auto: ['no', 'outcome'],
          colProps: [
            [0],
            { checkboxSelection: true, headerCheckboxSelection: true },
            [1],
            { autoHeight: true, cellStyle: { 'white-space': 'normal' } },
            [2],
            {
              autoHeight: true,
              cellStyle: { 'white-space': 'pre' },
              cellRenderer: (x) => x.value,
            },
          ],
          sheet: ['no', 'row', 'xOutcome'],
          sheetNames: $L.r_blueprint.cols,
        });
        //goals
        let gskeys = [
            'name',
            'total',
            'avg',
            'threshold',
            'pmet',
            'nrows',
            'prows',
          ].concat(
            data.col.map((x) => x.colpos),
            'desc',
          ),
          gsheaders = $L.o_goals_summary.cols.concat(
            data.col.map((x) => x.rcol),
            $L.o_goals_summary.postsheet,
          ),
          sgkv = SortObjAry(_.values(data.goal), 'name');
        $scope.goalsSummary = new GridBox({
          mode: 'goalsSummary',
          id: 9,
          title: $L.o_goals_summary.title,
          keys: gskeys,
          headers: gsheaders,
          model: data.gs,
          props: { tooltipShowDelay: 0 },
          colProps: [[0], { pinned: 'left', tooltipField: 'desc' }],
          auto: gskeys.slice(1),
          autoIfNeeded: true,
          ntypes: [
            'string',
            'int',
            'float',
            'float',
            'percent',
            'int',
            'percent',
          ].concat(data.col.map((x) => 'percent')),
        });
        $scope.studentGoals = new GridBox({
          mode: 'studentGoals',
          id: 10,
          title: $L.o_student_goals.title,
          keys: ['respondent'].concat(sgkv.map((x) => x.clppk1)),
          headers: $L.o_student_goals.cols.concat(sgkv.map((x) => x.name)),
          sheet: ['respondent'].concat(
            sgkv.map((x) => x.clppk1),
            ['uid', 'sid'],
          ),
          sheetNames: $L.o_student_goals.cols.concat(
            sgkv.map((x) => x.name),
            $L.o_student_goals.postsheet,
          ),
          model: data.sg,
          props: {
            rowSelection: 'single',
            suppressRowClickSelection: true,
            onSelectionChanged: $scope.GA.select,
            tooltipShowDelay: 0,
          },
          colProps: [[0], { checkboxSelection: true, pinned: 'left' }],
          auto: true,
          unload: mainscope.GA.unload,
        });
        $scope.studentGoalsT = new GridBox({
          mode: 'studentGoalsT',
          id: '10t',
          title: $L.o_student_goals.title,
          keys: sot.keys,
          headers: sot.headers,
          model: sot.model,
          props: {
            tooltipShowDelay: 0,
            rowClassRules: { 'row-invisible': 'data.hide' },
            getRowHeight: (params) => (params.data.hide ? 0 : 46),
            components: {
              agColumnHeader: CHeader,
              customTooltip: CustomTooltip,
            },
          },
          colProps: [
            [0],
            { pinned: 'left', tooltipField: 'desc' },
            _.range(1, sot.keys.length),
            {
              headerComponent: CHeader,
              headerComponentParams: {
                func: 'CHeaderGoalGraph',
                args: {
                  tag: 'sgt-header',
                  graph: 'goalGraph',
                  grid: 'sg',
                  bar: 'bars',
                  label: 'respondent',
                },
              },
              headerClass: 'header-check',
            },
          ],
          auto: true,
          ntypes: sot.ntypes,
          getEnabled: $scope.studentGoals,
          unload: mainscope.GA.unload,
        });
        $scope.studentGoals.grid.columnDefs.forEach((x, i) => {
          if (i == 0) return;
          x.headerTooltip = sgkv[i - 1].desc;
        });
        $scope.goalGraph = {
          id: 'goalGraph',
          pid: 'goalGraphParent',
          init: $scope.GA.graph,
          title: $L.o_goal_averages.title,
          filename: $L.o_goal_averages.title,
        };
      };
      $scope.OnReady();

      $scope.Refresh = function (arg, val1, val2, scope = $scope) {
        $timeout((x) => {
          if ($scope.$apply) $scope.$apply((y) => {
            scope[arg] = val1;
          });
        }, 10);
        $timeout((x) => {
          if ($scope.$apply) $scope.$apply((y) => {
            scope[arg] = val2;
          });
        }, 20);
      };
      $scope.CompareGraph = function (graph, event) {
        if (!graph.chart) return;
        let nodes = event ? event.api.getSelectedNodes() : [];
        if (nodes.length > 0)
          graph.chart.data.datasets[data.col.length] = {
            data: nodes[0].data.bars,
            label: nodes[0].data.respondent,
            borderColor: '#0069aa',
            backgroundColor: 'rgba(0, 105, 170, 0.5)',
            borderWidth: 1,
          };
        else if (graph.chart.data.datasets.length > data.col.length) {
          graph.chart.data.datasets.pop();
          if (graph.id == 'goalGraph')
            graph.chart.data.datasets.push({
              label: $L.r_goals_summary.cols[4],
              borderWidth: 1,
              backgroundColor: 'rgba(0, 105, 170, 0.25)',
              borderColor: 'rgba(0, 105, 170, 1)',
              data: data.ra.map((x) => x.pmet),
            });
        }
        graph.chart.update();
        if (nodes.length > 0) event.api.ensureNodeVisible(nodes[0], 'middle');
      };
      $scope.CompareGoalGraph = function (graph, event) {
        if (!graph.chart) return;
        let nodes = event ? event.api.getSelectedNodes() : [];
        if (nodes.length > 0)
          graph.chart.data.datasets[data.col.length + 1] = {
            data: nodes[0].data.bars,
            label: nodes[0].data.respondent,
            borderColor: '#0069aa',
            backgroundColor: 'rgba(0, 105, 170, 0.5)',
            borderWidth: 1,
            hidden: false,
          };
        else graph.chart.data.datasets[data.col.length + 1].hidden = true;
        graph.chart.data.datasets[data.col.length] = {
          label: $L.r_goals_summary.cols[4],
          borderWidth: 1,
          backgroundColor: 'rgba(0, 105, 170, 0.25)',
          borderColor: 'rgba(0, 105, 170, 1)',
          data: data.gs.map((x) => x.pmet),
          hidden: nodes.length > 0,
        };
        graph.chart.update();
        if (nodes.length > 0) event.api.ensureNodeVisible(nodes[0], 'middle');
      };
      // Row Analysis Functions
      $scope.RA = {
        select: function (event) {
          $scope.CompareGraph($scope.rowGraph, event);
        },
        unload: function () {
          $scope.CompareGraph($scope.rowGraph);
        },
        graph: function (id, pid) {
          if (id == undefined || pid == undefined) return;
          $scope.rowGraph.config = {
            type: 'bar',
            data: data.bars,
            options: {
              elements: { rectangle: { borderWidth: 2 } },
              scales: {
                x: { position: 'top', min: 0, max: pts.max },
                y: {
                  scaleLabel: {
                    display: true,
                    labelString: $L.o_row_averages.axis_y,
                    fontSize: 16,
                  },
                  ticks: {
                    callback: (x, i) => TruncRow(i + 1, data.bars.labels[x]),
                  },
                },
              },
              indexAxis: 'y',
              responsive: true,
              maintainAspectRatio: false,
              interaction: { mode: 'index' },
              plugins: {
                title: {
                  display: true,
                  text: $L.o_row_averages.axis_x,
                },
                datalabels: {
                  formatter: (value, context) =>
                    context.dataset.stack
                      ? value > 0
                        ? $.precision(
                            (value * 100) / data.ra[context.dataIndex].avg,
                            1e-2,
                          ) + '%'
                        : ''
                      : value,
                  display: showDatalabel,
                },
                tooltip: {
                  enabled: false,
                  callbacks: {
                    title: (tooltipItems) => tooltipItems[0].label,
                    afterTitle: (tooltipItems) =>
                      $L.average +
                      ': ' +
                      $.precision(data.ra[tooltipItems[0].dataIndex].avg, 1e-2),
                    label: (tooltipItem) => {
                      let label = tooltipItem.dataset.label,
                        avg = data.ra[tooltipItem.dataIndex].avg;
                      if (label.length == 0) return;
                      if (tooltipItem.datasetIndex < data.col.length)
                        label +=
                          ': ' +
                          ((tooltipItem.raw * 100) / avg).toFixed(1) +
                          '%';
                      else label += ': ' + tooltipItem.raw;
                      return label;
                    },
                  },
                },
              },
            },
          };
          $scope.rowGraph.chart = new Chart(
            id,
            $.extend(true, {}, $scope.rowGraph.config),
          );
          // Row analysis always has 2 datasets (stacked columns + optional comparison)
          const rowGraphHeight = Math.max(350, 100 + data.row.length * 50);
          $('#' + pid).height(rowGraphHeight);
          // Set min-height on parent container so it grows to calculated height (up to 50vh)
          const parentContainer = $('#' + pid).parent();
          const maxHeightVh = window.innerHeight * 0.5; // 50vh in pixels
          const minHeight = Math.min(rowGraphHeight, maxHeightVh);
          parentContainer.css('min-height', minHeight + 'px');
          $scope.rowGraph.chart.resize();
        },
        pies: function (id, pid) {
          if (id == undefined || pid == undefined) return;
          $scope.pies[pid].chart = new Chart(id, {
            type: 'pie',
            data: {
              datasets: [
                {
                  data: $scope.pies[pid].data,
                  backgroundColor: GetColors(data.col.length),
                },
              ],
              labels: data.col.map((x) => x.rcol),
            },
            options: {
              responsive: true,
              maintainAspectRatio: false,
              interaction: { mode: 'index' },
              plugins: {
                legend: { display: false },
                datalabels: { display: false }, //{formatter: (value, context) => $.precision(value, 1e-1)}
                tooltip: {
                  intersect: false,
                  mode: 'index',
                  callbacks: {
                    label: (tooltipItem) => `${tooltipItem.label}`,
                    afterLabel: (tooltipItem) =>
                      `${$.precision(tooltipItem.raw, 1e-2)}%`,
                  },
                },
              },
            },
          });
        },
      };
      // Reviewers Functions
      $scope.REVIEWERS = {
        graph: function (id, pid) {
          if (id == undefined || pid == undefined) return;
          $scope.reviewersGraph.config = {
            type: 'bar',
            data: data.reviewersBars,
            options: {
              elements: { rectangle: { borderWidth: 2 } },
              scales: {
                x: { position: 'top', min: 0, max: pts.max },
                y: {
                  scaleLabel: {
                    display: true,
                    labelString: OA ? $L.o_reviewers.axis_y : $L.r_reviewers.axis_y,
                    fontSize: 16,
                  },
                  ticks: {
                    callback: (x) => data.reviewersBars.labels[x],
                  },
                },
              },
              indexAxis: 'y',
              responsive: true,
              maintainAspectRatio: false,
              interaction: { mode: 'index' },
              plugins: {
                title: {
                  display: true,
                  text: OA ? $L.o_reviewers.axis_x : $L.r_reviewers.axis_x,
                },
                datalabels: {
                  formatter: (value) => value > 0 ? $.precision(value, 1e-2) : '',
                  display: showDatalabel,
                },
                tooltip: {
                  enabled: false,
                  callbacks: {
                    title: (tooltipItems) => tooltipItems[0].label,
                    label: (tooltipItem) => {
                      let label = tooltipItem.dataset.label;
                      if (label.length == 0) return '';
                      return label + ': ' + $.precision(tooltipItem.raw, 1e-2);
                    },
                  },
                },
              },
            },
          };
          $scope.reviewersGraph.chart = new Chart(
            id,
            $.extend(true, {}, $scope.reviewersGraph.config),
          );
          // Number of datasets = number of reviewers
          const numDatasets = data.reviewersBars.datasets.length;
          const reviewersGraphHeight = Math.max(350, 100 + data.row.length * numDatasets * 40);
          $('#' + pid).height(reviewersGraphHeight);
          // Set min-height on parent container so it grows to calculated height (up to 50vh)
          const parentContainer = $('#' + pid).parent();
          const maxHeightVh = window.innerHeight * 0.5; // 50vh in pixels
          const minHeight = Math.min(reviewersGraphHeight, maxHeightVh);
          parentContainer.css('min-height', minHeight + 'px');
          $scope.reviewersGraph.chart.resize();
        },
      };
      // Goal Analysis Functions
      $scope.GA = {
        color: 'gray',
        change: function () {
          threshold = $scope.rsettings.threshold;
          pts.qThreshold = pts.max * threshold;
          pts.rThreshold = pts.qThreshold * data.course[0].rrows.length;
          if (GGE || OME) {
            data.gs.forEach((x) => {
              x.nmet = 0;
              x.threshold = threshold;
            });
            data.sg.forEach((x, i) => {
              _.keys(data.goal).forEach((y, j) => {
                if (x[y] >= pts.qThreshold) ++data.gs[data.goal[y].index].nmet;
              });
            });
            data.gs.forEach((x, i) => {
              x.nstu = _.values(sot.model[i]).filter((y) =>
                _.isNumber(y),
              ).length;
              x.pmet = x.total ? $.precision(x.nmet / x.nstu, 1e-2) : '--';
            });
            $scope.goalsSummary.AddModel(data.gs);
          }
          data.statMap.nPass = 0;
          data.course.forEach((x) => {
            x.pass = 0;
          });
          data.landscape.forEach((x) => {
            if (x.overall_score >= pts.rThreshold) {
              ++data.statMap.nPass;
              ++data.course[ram.i[x.ra_pk1]].pass;
            }
          });
          UpdatePassPerc((100 * data.statMap.nPass) / data.statMap.scored);
          let grid = $scope.coursesIncluded.grid;
          grid.pinnedBottomRowData = [
            data.course.reduce(
              (a, x) => {
                a.enrollment += x.enrollment;
                a.responses += x.responses;
                a.percent = (100 * a.responses) / a.enrollment;
                return a;
              },
              {
                title: 'Overall',
                eis_title: 'Overall',
                enrollment: 0,
                responses: 0,
                pmet: data.statMap.pPass,
                pass: data.statMap.nPass,
              },
            ),
          ];
          if (grid.api) {
            // In ag-grid v34, use setGridOption for pinned rows
            if (typeof grid.api.setGridOption === 'function') {
              grid.api.setGridOption('pinnedBottomRowData', grid.pinnedBottomRowData);
            } else if (typeof grid.api.setPinnedBottomRowData === 'function') {
              grid.api.setPinnedBottomRowData(grid.pinnedBottomRowData);
            }
          }
          $scope.coursesIncluded.AddModel(data.course);
          data.gsbars.datasets[data.col.length].data = data.gs.map(
            (x) => x.pmet,
          );
          if ($scope.goalGraph.chart) {
            $scope.goalGraph.chart.data.datasets[data.col.length].data =
              data.gsbars.datasets[data.col.length].data;
            $scope.goalGraph.chart.update();
          }
        },
        select: function (event) {
          $scope.CompareGoalGraph($scope.goalGraph, event);
        },
        unload: function () {
          $scope.CompareGoalGraph($scope.goalGraph);
        },
        graph: function (id, pid) {
          if (id == undefined || pid == undefined) return;
          $scope.goalGraph.config = {
            type: 'bar',
            data: data.gsbars,
            options: {
              elements: { rectangle: { borderWidth: 2 } },
              scales: {
                x: { position: 'top', min: 0, max: pts.max },
                y: {
                  scaleLabel: {
                    display: true,
                    labelString: $L.r_goal_averages.axis,
                    fontSize: 16,
                  },
                  ticks: { callback: (x) => Trunc(data.gsbars.labels[x]) },
                },
              },
              indexAxis: 'y',
              responsive: true,
              maintainAspectRatio: false,
              interaction: { mode: 'index' },
              plugins: {
                title: {
                  display: true,
                  text: $L.o_goal_averages.axis_x,
                },
                legend: {
                  labels: {
                    filter: (item, chart) =>
                      !chart.datasets[item.datasetIndex].hidden,
                  },
                },
                datalabels: {
                  formatter: (value, context) =>
                    context.dataset.stack
                      ? value > 0
                        ? $.precision(
                            (value * 100) / data.gs[context.dataIndex].avg,
                            1e-1,
                          ) + '%'
                        : ''
                      : $.precision(value, 1e-2),
                  display: showDatalabel,
                },
                tooltip: {
                  enabled: false,
                  callbacks: {
                    title: (tooltipItems) => tooltipItems[0].label,
                    afterTitle: (tooltipItems) =>
                      $L.average +
                      ': ' +
                      $.precision(data.gs[tooltipItems[0].dataIndex].avg, 1e-2),
                    label: (tooltipItem) => {
                      let label = tooltipItem.dataset.label,
                        avg = data.gs[tooltipItem.dataIndex].avg;
                      if (label.length == 0) return;
                      if (tooltipItem.datasetIndex < data.col.length)
                        label +=
                          ': ' +
                          $.precision((tooltipItem.raw * 100) / avg, 1e-1) +
                          '%';
                      else label += ': ' + $.precision(tooltipItem.raw, 1e-2);
                      return label;
                    },
                    footer: (tooltipItems) =>
                      data.gs[tooltipItems[0].dataIndex].desc,
                  },
                },
              },
            },
          };
          $scope.goalGraph.chart = new Chart(
            id,
            $.extend(true, {}, $scope.goalGraph.config),
          );
          // Calculate height based on number of goals: Math.max(350, 100 + number of goals * 80)
          const goalGraphHeight = Math.max(350, 100 + data.gs.length * 80);
          $('#' + pid).height(goalGraphHeight);
          // Set min-height on parent container so it grows to calculated height (up to 50vh)
          const parentContainer = $('#' + pid).parent();
          const maxHeightVh = window.innerHeight * 0.5; // 50vh in pixels
          const minHeight = Math.min(goalGraphHeight, maxHeightVh);
          parentContainer.css('min-height', minHeight + 'px');
          $scope.goalGraph.chart.resize();
        },
      };
      // Outcomes Manager Tab
      $scope.OM = {
        outcomes: [],
        questions: [],
        ok: false,
        enabled: OME,
        ready: function () {
          mainscope.outcomesManager.grid.api.forEachNode(
            function (node, index) {
              for (let q of mainscope.OM.questions)
                if (q.id == node.id) node.setSelected(true);
            },
          );
          setIntervalX(
            $scope.outcomesManager.AutoSize,
            100,
            5,
            $scope.outcomesManager,
          );
        },
        button: function (add, del) {
          outBtnR($scope.OM.outcomes, $scope.OM.questions, add, del);
          if ($scope.outcomesManager && $scope.outcomesManager.grid && $scope.outcomesManager.grid.api) {
            $scope.outcomesManager.grid.api.deselectAll();
          }
        },
        select: function (event) {
          $scope.OM.questions = event.api.getSelectedNodes();
          $scope.OM.ok =
            $scope.OM.outcomes.length > 0 && $scope.OM.questions.length > 0;
          if ($scope.OM.outcomes.length > 0 || $scope.OM.questions.length > 0)
            if ($scope.$apply) $scope.$apply();
        },
        load: function () {
          setIntervalX(
            $scope.outcomesManager.AutoSize,
            100,
            5,
            $scope.outcomesManager,
          );
        },
        unload: function () {
          Object.assign($scope.OM, {
            outcomes: [],
            questions: [],
            ok: false,
          });
          $scope.nOutcomes.reset();
          if ($scope.outcomesManager && $scope.outcomesManager.grid && $scope.outcomesManager.grid.api) {
            $scope.outcomesManager.grid.api.deselectAll();
          }
        },
        update: function () {
          $scope.loading = true;
          notify('Updating Goals...');
          ProcessGoals();
          
          // Update goalsSummary grid data
          $scope.goalsSummary.AddModel(data.gs);
          
          // Update studentGoals grid - modify existing grid instead of recreating
          let sgkv = SortObjAry(_.values(data.goal), 'name');
          if ($scope.studentGoals && $scope.studentGoals.grid && $scope.studentGoals.grid.api) {
            // Build new column definitions
            let newKeys = ['respondent'].concat(sgkv.map((x) => x.clppk1));
            let newHeaders = $L.o_student_goals.cols.concat(sgkv.map((x) => x.name));
            let newColDefs = [];
            
            // First column (respondent) - keep existing structure but update field/header
            let firstCol = $scope.studentGoals.grid.columnDefs[0] || {};
            newColDefs.push({
              ...firstCol,
              headerName: newHeaders[0],
              field: newKeys[0],
              checkboxSelection: true,
              pinned: 'left'
            });
            
            // Goal columns - create new ones based on existing structure
            for (let i = 0; i < sgkv.length; i++) {
              let baseCol = $scope.studentGoals.grid.columnDefs[1] || {};
              newColDefs.push({
                ...baseCol,
                headerName: newHeaders[i + 1],
                field: newKeys[i + 1],
                headerTooltip: sgkv[i].desc
              });
            }
            
            // Update grid using setGridOption for ag-grid v34
            if (typeof $scope.studentGoals.grid.api.setGridOption === 'function') {
              $scope.studentGoals.grid.api.setGridOption('columnDefs', newColDefs);
              $scope.studentGoals.grid.api.setGridOption('rowData', data.sg);
            } else if (typeof $scope.studentGoals.grid.api.setColumnDefs === 'function') {
              $scope.studentGoals.grid.api.setColumnDefs(newColDefs);
              if (typeof $scope.studentGoals.grid.api.setRowData === 'function') {
                $scope.studentGoals.grid.api.setRowData(data.sg);
              }
            }
            
            // Update internal references
            $scope.studentGoals.grid.columnDefs = newColDefs;
            $scope.studentGoals.keys = newKeys;
            $scope.studentGoals.headers = newHeaders;
            $scope.studentGoals.sheet = ['respondent'].concat(
              sgkv.map((x) => x.clppk1),
              ['uid', 'sid'],
            );
            $scope.studentGoals.sheetNames = $L.o_student_goals.cols.concat(
              sgkv.map((x) => x.name),
              $L.o_student_goals.postsheet,
            );
          } else {
            // Grid not initialized yet, create it normally
            $scope.studentGoals = new GridBox({
              mode: 'studentGoals',
              id: 10,
              title: $L.o_student_goals.title,
              keys: ['respondent'].concat(sgkv.map((x) => x.clppk1)),
              headers: $L.o_student_goals.cols.concat(sgkv.map((x) => x.name)),
              sheet: ['respondent'].concat(
                sgkv.map((x) => x.clppk1),
                ['uid', 'sid'],
              ),
              sheetNames: $L.o_student_goals.cols.concat(
                sgkv.map((x) => x.name),
                $L.o_student_goals.postsheet,
              ),
              model: data.sg,
              props: {
                rowSelection: 'single',
                suppressRowClickSelection: true,
                onSelectionChanged: $scope.GA.select,
                tooltipShowDelay: 0,
              },
              colProps: [[0], { checkboxSelection: true, pinned: 'left' }],
              auto: true,
              unload: mainscope.GA.unload,
              enabled: $scope.studentGoals ? $scope.studentGoals.enabled : true,
              replace: true,
            });
            $scope.studentGoals.grid.columnDefs.forEach((x, i) => {
              if (i == 0) return;
              x.headerTooltip = sgkv[i - 1].desc;
            });
          }
          
          // Update studentGoalsT grid - modify existing grid instead of recreating
          if ($scope.studentGoalsT && $scope.studentGoalsT.grid && $scope.studentGoalsT.grid.api) {
            // Build new column definitions based on existing structure
            let newColDefsT = [];
            
            // First column (goal) - keep existing structure
            let firstColT = $scope.studentGoalsT.grid.columnDefs[0] || {};
            newColDefsT.push({
              ...firstColT,
              headerName: sot.headers[0],
              field: sot.keys[0],
              pinned: 'left',
              tooltipField: 'desc'
            });
            
            // Student columns - create based on existing structure
            for (let i = 1; i < sot.keys.length; i++) {
              let baseCol = $scope.studentGoalsT.grid.columnDefs[1] || {};
              newColDefsT.push({
                ...baseCol,
                headerName: sot.headers[i],
                field: sot.keys[i],
                headerComponent: CHeader,
                headerComponentParams: {
                  func: 'CHeaderGoalGraph',
                  args: {
                    tag: 'sgt-header',
                    graph: 'goalGraph',
                    grid: 'sg',
                    bar: 'bars',
                    label: 'respondent',
                  },
                },
                headerClass: 'header-check'
              });
            }
            
            // Update grid using setGridOption for ag-grid v34
            if (typeof $scope.studentGoalsT.grid.api.setGridOption === 'function') {
              $scope.studentGoalsT.grid.api.setGridOption('columnDefs', newColDefsT);
              $scope.studentGoalsT.grid.api.setGridOption('rowData', sot.model);
            } else if (typeof $scope.studentGoalsT.grid.api.setColumnDefs === 'function') {
              $scope.studentGoalsT.grid.api.setColumnDefs(newColDefsT);
              if (typeof $scope.studentGoalsT.grid.api.setRowData === 'function') {
                $scope.studentGoalsT.grid.api.setRowData(sot.model);
              }
            }
            
            // Update internal references
            $scope.studentGoalsT.grid.columnDefs = newColDefsT;
            $scope.studentGoalsT.keys = sot.keys;
            $scope.studentGoalsT.headers = sot.headers;
            $scope.studentGoalsT.grid.ntypes = sot.ntypes;
          } else {
            // Grid not initialized yet, create it normally
            $scope.studentGoalsT = new GridBox({
              mode: 'studentGoalsT',
              id: '10t',
              title: $L.o_student_goals.title,
              keys: sot.keys,
              headers: sot.headers,
              model: sot.model,
              props: {
                tooltipShowDelay: 0,
                rowClassRules: { 'row-invisible': 'data.hide' },
                getRowHeight: (params) => (params.data.hide ? 0 : 46),
                components: {
                  agColumnHeader: CHeader,
                  customTooltip: CustomTooltip,
                },
              },
              colProps: [
                [0],
                { pinned: 'left', tooltipField: 'desc' },
                _.range(1, sot.keys.length),
                {
                  headerComponent: CHeader,
                  headerComponentParams: {
                    func: 'CHeaderGoalGraph',
                    args: {
                      tag: 'sgt-header',
                      graph: 'goalGraph',
                      grid: 'sg',
                      bar: 'bars',
                      label: 'respondent',
                    },
                  },
                  headerClass: 'header-check',
                },
              ],
              auto: true,
              ntypes: sot.ntypes,
              unload: mainscope.GA.unload,
              enabled: $scope.studentGoalsT ? $scope.studentGoalsT.enabled : true,
              replace: true,
            });
          }
          
          // Auto-size grids after update
          if ($scope.studentGoals && $scope.studentGoals.grid && $scope.studentGoals.grid.api) {
            $scope.studentGoals.AutoSize();
          }
          if ($scope.studentGoalsT && $scope.studentGoalsT.grid && $scope.studentGoalsT.grid.api) {
            $scope.studentGoalsT.AutoSize();
          }
          
          $scope.loading = false;
          notify('');
        },
      };
      $scope.Remake = function () {
        n_ready = false;
        parseProgress.reset(true);
        $scope.loading = true;
        n_title[2] = $scope.PROG.enabled ? $scope.PROG.sel.join('; ') : '';
        pts = { enabled: $scope.LOA.enabled, col: rfdc()($scope.LOA.col) };
        pts.max = pts.enabled ? $.maximum(pts.col.map((x) => x.pts)) : 1;
        pts.qThreshold = pts.max * threshold;
        pts.rThreshold = pts.qThreshold * data.course[0].rrows.length;
        data = rfdc()(backup);
        if ($scope.PROG.enabled)
          data.score = rfdc()(
            $scope.backup.score.filter((x) => {
              return $scope.backup.student[x.user_pk1].progs.length
                ? $scope.backup.student[x.user_pk1].progs.some((y) =>
                    $scope.PROG.ids.includes(y),
                  )
                : $scope.PROG.ids.includes(-1);
            }),
          );
        if (data.score.length < 1) data.score = rfdc()($scope.backup.score);
        if (pts.enabled)
          data.score.forEach((x) => {
            x.rravg = pts.col[coli[x.rc_pk1]].pts;
          });
        for (x in ram.s) ram.s[x] = 0;
        $scope.OnReady();
        ProcessData();
        if (GGE || OME) ProcessGoals();
        n_ready = true;
        notify('');
      };
      // Levels
      $scope.LOA = {
        col: [],
        enabled: false,
        update: function () {
          if (
            $scope.LOA.enabled == pts.enabled &&
            !(
              $scope.LOA.enabled &&
              $scope.LOA.col.find((x, i) => x.pts != pts.col[i].pts)
            )
          )
            return;
          $scope.Remake();
        },
      };
      // Programs
      $scope.PROG = {
        sel: [],
        ids: [],
        prev: [],
        enabled: false,
        update: function () {
          if (
            $scope.PROG.ids.length < 1 ||
            _.isEqual($scope.PROG.ids, $scope.PROG.prev)
          )
            return;
          $scope.PROG.prev = $scope.PROG.ids.slice();
          $scope.PROG.enabled =
            $scope.PROG.ids.length != $scope.progModel.length;
          $scope.Remake();
        },
        select: function (event) {
          let selected = event.api.getSelectedNodes();
          $scope.PROG.ids = selected.map((x) => x.data.id);
          $scope.PROG.sel = selected.map((x) => x.data.name);
        },
        ready: function (event) {
          if ($scope.PROG.enabled)
            event.api.forEachNode((x) =>
              x.setSelected($scope.PROG.ids.includes(x.data.id)),
            );
          else event.api.selectAll();
        },
      };
      // Export Tab
      $scope.EX = {
        grids: [],
        ok: false,
        interval: null,
        header: true,
        blueprint: false,
        download: function (type) {
          if (!n_ready) return;
          $scope.reportInfo.enabled = $scope.EX.header;
          $scope.outcomesManager.enabled = $scope.EX.blueprint;
          if (type == '.pdf') {
            let doc = {
              pageOrientation: settings.orientation,
              content: [],
              styles: {
                header: { fontSize: 18, bold: true, alignment: 'center' },
                subheader: {
                  fontSize: 16,
                  alignment: 'center',
                  margin: [0, 0, 0, 10],
                },
                table: { margin: [0, 10, 0, 10] },
                tableHeader: { bold: true, fontSize: 13.5 },
                tableTitle: {
                  bold: true,
                  fontSize: 15,
                  fillColor: '#80ceff',
                  alignment: 'center',
                },
              },
            };
            if ($scope.reportInfo.enabled)
              doc.content.push(
                { text: n_title[0], style: 'header' },
                { text: n_title[1], style: 'subheader' },
              );
            if ($scope.reportInfo.enabled && pts && pts.enabled)
              doc.content.push({
                text: $L.level_editor.download_warning,
                style: 'subheader',
              });
            for (let g of $scope.EX.grids)
              if (g.enabled && g.mode != 'info') doc.content.push(g.GetPdf());
            pdfMake.createPdf(doc).download($scope.EX.fileName + type);
          } else if (type == '.docx') {
            let doc = StartDoc(true, true);
            for (let g of $scope.EX.grids)
              if (g.enabled && g.mode != 'info') doc += g.GetDoc();
            doc += '</body>\n</html>';
            saveAs(
              htmlDocx.asBlob(doc, { orientation: settings.orientation }),
              $scope.EX.fileName + type,
            );
          } else {
            let wb = XLSX.utils.book_new();
            for (let g of $scope.EX.grids) if (g.enabled) g.GetSheet(wb);
            if (type == '.csv' && wb.SheetNames.length > 1) {
              let zip = new JSZip();
              for (let name of wb.SheetNames)
                zip.file(name + type, XLSX.utils.sheet_to_csv(wb.Sheets[name]));
              zip.generateAsync({ type: 'blob' }).then(function (content) {
                saveAs(content, $scope.EX.fileName + '.zip');
              });
            } else XLSX.writeFile(wb, $scope.EX.fileName + type);
          }
        },
        full: function () {
          if (!n_ready) return;
          let wb = XLSX.utils.book_new();
          for (let g of $scope.EX.grids) g.GetSheet(wb);
          XLSX.writeFile(wb, $scope.EX.fileName + '.xlsx');
        },
        canvas: function (filename) {
          if (!n_ready) return;
          $scope.goalGraph.canvas.toBlob(function (blob) {
            saveAs(blob, filename);
          });
        },
        doc: function (standard) {
          if (!n_ready) return;
          let fn =
              $scope.EX.fileName +
              '-' +
              (standard ? $L.download.standard : $L.download.summary) +
              '.docx',
            doc = StartDoc(true, true);
          doc += $scope.coursesIncluded.GetDoc();
          doc += $scope.summaryStats.GetDoc();
          if (standard) doc += $scope.rowAnalysis.GetDoc();
          doc += $scope.details.GetDoc();
          if (standard && GGE) doc += $scope.goalsSummary.GetDoc();
          // Add reviewers section (grid table and chart) to standard download if available
          if (standard && $scope.reviewerCount > 1 && $scope.reviewers) {
            doc += $scope.reviewers.GetDoc();
            // Add reviewers bar chart after the grid table
            if ($scope.reviewersGraph && $scope.reviewersGraph.chart && $scope.reviewersGraph.chart.canvas) {
              let can = $scope.reviewersGraph.chart.canvas;
              let height = Math.min(900, 650 * can.height / can.width);
              doc += `<img src="${can.toDataURL()}" width="${height * can.width / can.height}" height="${height}">`;
            }
          }
          doc += $scope.rubric.GetDoc();
          doc += '</body>\n</html>';
          saveAs(
            htmlDocx.asBlob(doc, { orientation: settings.orientation }),
            fn,
          );
        },
      };
    },
  ]);
EacAppSetup(app);
