(function() {
    /**
     * Identifies the EAC webapp root path in any deployment scenario.
     * Works regardless of:
     * - Where the HTML file is located (root, UI2/, or any subfolder)
     * - How deep the webapp root is (top-level domain or nested like /webapps/app-id/)
     * 
     * @returns {string} The webapp root path (e.g., "/" or "/webapps/ea-eacvis-BB66be4e66e3c83")
     */
    function getWebappRoot() {
        // Method 1: Try to find this script element to determine its location
        var script = document.currentScript;
        
        // If currentScript is not available, search all script tags
        if (!script) {
            var scripts = document.getElementsByTagName('script');
            for (var i = 0; i < scripts.length; i++) {
                if (scripts[i].src && scripts[i].src.indexOf('Core/Core.min.js') !== -1) {
                    script = scripts[i];
                    break;
                }
            }
        }
        
        // If we found the script, extract the webapp root from its path
        if (script && script.src) {
            var src = script.src;
            // Resolve relative URLs to absolute
            var url = new URL(src, window.location.href);
            var pathname = url.pathname;
            
            // Find where '/Core/Core.min.js' appears in the path
            var coreIndex = pathname.indexOf('/Core/Core.min.js');
            if (coreIndex !== -1) {
                // Everything before '/Core/Core.min.js' is the webapp root
                var root = pathname.substring(0, coreIndex);
                return root || '/';
            }
        }
        
        // Method 2: Fallback - use page pathname to detect Blackboard deployments
        var path = window.location.pathname;
        var parts = path.split('/').filter(function(p) {
            return p.length > 0;
        });
        
        // Blackboard deployments typically have /webapps/{app-id}/ structure
        if (parts.length >= 2 && parts[0] === 'webapps') {
            return '/' + parts[0] + '/' + parts[1];
        }
        
        // Default to root
        return '/';
    }
    
    /**
     * Loads and parses env.json from the webapp root
     */
    function loadEnvConfig() {
        var root = getWebappRoot();
        var envJsonPath = root + (root.endsWith('/') ? '' : '/') + 'env.json';
        
        var xhr = new XMLHttpRequest();
        xhr.open("GET", envJsonPath, false); // Synchronous request
        xhr.send(null);
        
        if (xhr.status === 200) {
            try {
                window.EAC_ENV_CONFIG = JSON.parse(xhr.responseText);
            } catch (e) {
                console.error("Failed to parse env.json:", e);
            }
        }
    }
    
    // Expose functions globally
    window.getWebappRoot = getWebappRoot;
    window.loadEnvConfig = loadEnvConfig;
    
    // Automatically load env.json on script load (only if not already loaded)
    if (!window.EAC_ENV_CONFIG) {
        loadEnvConfig();
    }
})();
var $jscomp=$jscomp||{};$jscomp.scope={};$jscomp.arrayIteratorImpl=function(a){var b=0;return function(){return b<a.length?{done:!1,value:a[b++]}:{done:!0}}};$jscomp.arrayIterator=function(a){return{next:$jscomp.arrayIteratorImpl(a)}};$jscomp.makeIterator=function(a){var b="undefined"!=typeof Symbol&&Symbol.iterator&&a[Symbol.iterator];return b?b.call(a):$jscomp.arrayIterator(a)};$jscomp.arrayFromIterator=function(a){for(var b,c=[];!(b=a.next()).done;)c.push(b.value);return c};
$jscomp.arrayFromIterable=function(a){return a instanceof Array?a:$jscomp.arrayFromIterator($jscomp.makeIterator(a))};$jscomp.getGlobal=function(a){return"undefined"!=typeof window&&window===a?a:"undefined"!=typeof global&&null!=global?global:a};$jscomp.global=$jscomp.getGlobal(this);$jscomp.ASSUME_ES5=!1;$jscomp.ASSUME_NO_NATIVE_MAP=!1;$jscomp.ASSUME_NO_NATIVE_SET=!1;$jscomp.SIMPLE_FROUND_POLYFILL=!1;
$jscomp.defineProperty=$jscomp.ASSUME_ES5||"function"==typeof Object.defineProperties?Object.defineProperty:function(a,b,c){a!=Array.prototype&&a!=Object.prototype&&(a[b]=c.value)};$jscomp.polyfill=function(a,b,c,d){if(b){c=$jscomp.global;a=a.split(".");for(d=0;d<a.length-1;d++){var e=a[d];e in c||(c[e]={});c=c[e]}a=a[a.length-1];d=c[a];b=b(d);b!=d&&null!=b&&$jscomp.defineProperty(c,a,{configurable:!0,writable:!0,value:b})}};$jscomp.FORCE_POLYFILL_PROMISE=!1;
$jscomp.polyfill("Promise",function(a){function b(){this.batch_=null}function c(a){return a instanceof e?a:new e(function(b,c){b(a)})}if(a&&!$jscomp.FORCE_POLYFILL_PROMISE)return a;b.prototype.asyncExecute=function(a){if(null==this.batch_){this.batch_=[];var b=this;this.asyncExecuteFunction(function(){b.executeBatch_()})}this.batch_.push(a)};var d=$jscomp.global.setTimeout;b.prototype.asyncExecuteFunction=function(a){d(a,0)};b.prototype.executeBatch_=function(){for(;this.batch_&&this.batch_.length;){var a=
this.batch_;this.batch_=[];for(var b=0;b<a.length;++b){var c=a[b];a[b]=null;try{c()}catch(m){this.asyncThrow_(m)}}}this.batch_=null};b.prototype.asyncThrow_=function(a){this.asyncExecuteFunction(function(){throw a;})};var e=function(a){this.state_=0;this.result_=void 0;this.onSettledCallbacks_=[];var b=this.createResolveAndReject_();try{a(b.resolve,b.reject)}catch(k){b.reject(k)}};e.prototype.createResolveAndReject_=function(){function a(a){return function(e){c||(c=!0,a.call(b,e))}}var b=this,c=!1;
return{resolve:a(this.resolveTo_),reject:a(this.reject_)}};e.prototype.resolveTo_=function(a){if(a===this)this.reject_(new TypeError("A Promise cannot resolve to itself"));else if(a instanceof e)this.settleSameAsPromise_(a);else{a:switch(typeof a){case "object":var b=null!=a;break a;case "function":b=!0;break a;default:b=!1}b?this.resolveToNonPromiseObj_(a):this.fulfill_(a)}};e.prototype.resolveToNonPromiseObj_=function(a){var b=void 0;try{b=a.then}catch(k){this.reject_(k);return}"function"==typeof b?
this.settleSameAsThenable_(b,a):this.fulfill_(a)};e.prototype.reject_=function(a){this.settle_(2,a)};e.prototype.fulfill_=function(a){this.settle_(1,a)};e.prototype.settle_=function(a,b){if(0!=this.state_)throw Error("Cannot settle("+a+", "+b+"): Promise already settled in state"+this.state_);this.state_=a;this.result_=b;this.executeOnSettledCallbacks_()};e.prototype.executeOnSettledCallbacks_=function(){if(null!=this.onSettledCallbacks_){for(var a=0;a<this.onSettledCallbacks_.length;++a)f.asyncExecute(this.onSettledCallbacks_[a]);
this.onSettledCallbacks_=null}};var f=new b;e.prototype.settleSameAsPromise_=function(a){var b=this.createResolveAndReject_();a.callWhenSettled_(b.resolve,b.reject)};e.prototype.settleSameAsThenable_=function(a,b){var c=this.createResolveAndReject_();try{a.call(b,c.resolve,c.reject)}catch(m){c.reject(m)}};e.prototype.then=function(a,b){function c(a,b){return"function"==typeof a?function(b){try{d(a(b))}catch(p){f(p)}}:b}var d,f,g=new e(function(a,b){d=a;f=b});this.callWhenSettled_(c(a,d),c(b,f));return g};
e.prototype.catch=function(a){return this.then(void 0,a)};e.prototype.callWhenSettled_=function(a,b){function c(){switch(e.state_){case 1:a(e.result_);break;case 2:b(e.result_);break;default:throw Error("Unexpected state: "+e.state_);}}var e=this;null==this.onSettledCallbacks_?f.asyncExecute(c):this.onSettledCallbacks_.push(c)};e.resolve=c;e.reject=function(a){return new e(function(b,c){c(a)})};e.race=function(a){return new e(function(b,e){for(var d=$jscomp.makeIterator(a),f=d.next();!f.done;f=d.next())c(f.value).callWhenSettled_(b,
e)})};e.all=function(a){var b=$jscomp.makeIterator(a),d=b.next();return d.done?c([]):new e(function(a,e){function f(b){return function(c){g[b]=c;h--;0==h&&a(g)}}var g=[],h=0;do g.push(void 0),h++,c(d.value).callWhenSettled_(f(g.length-1),e),d=b.next();while(!d.done)})};return e},"es6","es3");
$jscomp.polyfill("Promise.prototype.finally",function(a){return a?a:function(a){return this.then(function(b){return Promise.resolve(a()).then(function(){return b})},function(b){return Promise.resolve(a()).then(function(){throw b;})})}},"es9","es3");$jscomp.SYMBOL_PREFIX="jscomp_symbol_";$jscomp.initSymbol=function(){$jscomp.initSymbol=function(){};$jscomp.global.Symbol||($jscomp.global.Symbol=$jscomp.Symbol)};
$jscomp.SymbolClass=function(a,b){this.$jscomp$symbol$id_=a;$jscomp.defineProperty(this,"description",{configurable:!0,writable:!0,value:b})};$jscomp.SymbolClass.prototype.toString=function(){return this.$jscomp$symbol$id_};$jscomp.Symbol=function(){function a(c){if(this instanceof a)throw new TypeError("Symbol is not a constructor");return new $jscomp.SymbolClass($jscomp.SYMBOL_PREFIX+(c||"")+"_"+b++,c)}var b=0;return a}();
$jscomp.initSymbolIterator=function(){$jscomp.initSymbol();var a=$jscomp.global.Symbol.iterator;a||(a=$jscomp.global.Symbol.iterator=$jscomp.global.Symbol("Symbol.iterator"));"function"!=typeof Array.prototype[a]&&$jscomp.defineProperty(Array.prototype,a,{configurable:!0,writable:!0,value:function(){return $jscomp.iteratorPrototype($jscomp.arrayIteratorImpl(this))}});$jscomp.initSymbolIterator=function(){}};
$jscomp.initSymbolAsyncIterator=function(){$jscomp.initSymbol();var a=$jscomp.global.Symbol.asyncIterator;a||(a=$jscomp.global.Symbol.asyncIterator=$jscomp.global.Symbol("Symbol.asyncIterator"));$jscomp.initSymbolAsyncIterator=function(){}};$jscomp.iteratorPrototype=function(a){$jscomp.initSymbolIterator();a={next:a};a[$jscomp.global.Symbol.iterator]=function(){return this};return a};$jscomp.underscoreProtoCanBeSet=function(){var a={a:!0},b={};try{return b.__proto__=a,b.a}catch(c){}return!1};
$jscomp.setPrototypeOf="function"==typeof Object.setPrototypeOf?Object.setPrototypeOf:$jscomp.underscoreProtoCanBeSet()?function(a,b){a.__proto__=b;if(a.__proto__!==b)throw new TypeError(a+" is not extensible");return a}:null;$jscomp.generator={};$jscomp.generator.ensureIteratorResultIsObject_=function(a){if(!(a instanceof Object))throw new TypeError("Iterator result "+a+" is not an object");};
$jscomp.generator.Context=function(){this.isRunning_=!1;this.yieldAllIterator_=null;this.yieldResult=void 0;this.nextAddress=1;this.finallyAddress_=this.catchAddress_=0;this.finallyContexts_=this.abruptCompletion_=null};$jscomp.generator.Context.prototype.start_=function(){if(this.isRunning_)throw new TypeError("Generator is already running");this.isRunning_=!0};$jscomp.generator.Context.prototype.stop_=function(){this.isRunning_=!1};
$jscomp.generator.Context.prototype.jumpToErrorHandler_=function(){this.nextAddress=this.catchAddress_||this.finallyAddress_};$jscomp.generator.Context.prototype.next_=function(a){this.yieldResult=a};$jscomp.generator.Context.prototype.throw_=function(a){this.abruptCompletion_={exception:a,isException:!0};this.jumpToErrorHandler_()};$jscomp.generator.Context.prototype.return=function(a){this.abruptCompletion_={return:a};this.nextAddress=this.finallyAddress_};
$jscomp.generator.Context.prototype.jumpThroughFinallyBlocks=function(a){this.abruptCompletion_={jumpTo:a};this.nextAddress=this.finallyAddress_};$jscomp.generator.Context.prototype.yield=function(a,b){this.nextAddress=b;return{value:a}};$jscomp.generator.Context.prototype.yieldAll=function(a,b){a=$jscomp.makeIterator(a);var c=a.next();$jscomp.generator.ensureIteratorResultIsObject_(c);if(c.done)this.yieldResult=c.value,this.nextAddress=b;else return this.yieldAllIterator_=a,this.yield(c.value,b)};
$jscomp.generator.Context.prototype.jumpTo=function(a){this.nextAddress=a};$jscomp.generator.Context.prototype.jumpToEnd=function(){this.nextAddress=0};$jscomp.generator.Context.prototype.setCatchFinallyBlocks=function(a,b){this.catchAddress_=a;void 0!=b&&(this.finallyAddress_=b)};$jscomp.generator.Context.prototype.setFinallyBlock=function(a){this.catchAddress_=0;this.finallyAddress_=a||0};$jscomp.generator.Context.prototype.leaveTryBlock=function(a,b){this.nextAddress=a;this.catchAddress_=b||0};
$jscomp.generator.Context.prototype.enterCatchBlock=function(a){this.catchAddress_=a||0;a=this.abruptCompletion_.exception;this.abruptCompletion_=null;return a};$jscomp.generator.Context.prototype.enterFinallyBlock=function(a,b,c){c?this.finallyContexts_[c]=this.abruptCompletion_:this.finallyContexts_=[this.abruptCompletion_];this.catchAddress_=a||0;this.finallyAddress_=b||0};
$jscomp.generator.Context.prototype.leaveFinallyBlock=function(a,b){b=this.finallyContexts_.splice(b||0)[0];if(b=this.abruptCompletion_=this.abruptCompletion_||b){if(b.isException)return this.jumpToErrorHandler_();void 0!=b.jumpTo&&this.finallyAddress_<b.jumpTo?(this.nextAddress=b.jumpTo,this.abruptCompletion_=null):this.nextAddress=this.finallyAddress_}else this.nextAddress=a};$jscomp.generator.Context.prototype.forIn=function(a){return new $jscomp.generator.Context.PropertyIterator(a)};
$jscomp.generator.Context.PropertyIterator=function(a){this.object_=a;this.properties_=[];for(var b in a)this.properties_.push(b);this.properties_.reverse()};$jscomp.generator.Context.PropertyIterator.prototype.getNext=function(){for(;0<this.properties_.length;){var a=this.properties_.pop();if(a in this.object_)return a}return null};$jscomp.generator.Engine_=function(a){this.context_=new $jscomp.generator.Context;this.program_=a};
$jscomp.generator.Engine_.prototype.next_=function(a){this.context_.start_();if(this.context_.yieldAllIterator_)return this.yieldAllStep_(this.context_.yieldAllIterator_.next,a,this.context_.next_);this.context_.next_(a);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.return_=function(a){this.context_.start_();var b=this.context_.yieldAllIterator_;if(b)return this.yieldAllStep_("return"in b?b["return"]:function(a){return{value:a,done:!0}},a,this.context_.return);this.context_.return(a);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.throw_=function(a){this.context_.start_();if(this.context_.yieldAllIterator_)return this.yieldAllStep_(this.context_.yieldAllIterator_["throw"],a,this.context_.next_);this.context_.throw_(a);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.yieldAllStep_=function(a,b,c){try{var d=a.call(this.context_.yieldAllIterator_,b);$jscomp.generator.ensureIteratorResultIsObject_(d);if(!d.done)return this.context_.stop_(),d;var e=d.value}catch(f){return this.context_.yieldAllIterator_=null,this.context_.throw_(f),this.nextStep_()}this.context_.yieldAllIterator_=null;c.call(this.context_,e);return this.nextStep_()};
$jscomp.generator.Engine_.prototype.nextStep_=function(){for(;this.context_.nextAddress;)try{var a=this.program_(this.context_);if(a)return this.context_.stop_(),{value:a.value,done:!1}}catch(b){this.context_.yieldResult=void 0,this.context_.throw_(b)}this.context_.stop_();if(this.context_.abruptCompletion_){a=this.context_.abruptCompletion_;this.context_.abruptCompletion_=null;if(a.isException)throw a.exception;return{value:a.return,done:!0}}return{value:void 0,done:!0}};
$jscomp.generator.Generator_=function(a){this.next=function(b){return a.next_(b)};this.throw=function(b){return a.throw_(b)};this.return=function(b){return a.return_(b)};$jscomp.initSymbolIterator();this[Symbol.iterator]=function(){return this}};$jscomp.generator.createGenerator=function(a,b){b=new $jscomp.generator.Generator_(new $jscomp.generator.Engine_(b));$jscomp.setPrototypeOf&&$jscomp.setPrototypeOf(b,a.prototype);return b};
$jscomp.asyncExecutePromiseGenerator=function(a){function b(b){return a.next(b)}function c(b){return a.throw(b)}return new Promise(function(d,e){function f(a){a.done?d(a.value):Promise.resolve(a.value).then(b,c).then(f,e)}f(a.next())})};$jscomp.asyncExecutePromiseGeneratorFunction=function(a){return $jscomp.asyncExecutePromiseGenerator(a())};$jscomp.asyncExecutePromiseGeneratorProgram=function(a){return $jscomp.asyncExecutePromiseGenerator(new $jscomp.generator.Generator_(new $jscomp.generator.Engine_(a)))};
var WIN=function(){};WIN.IsFrame=function(a){try{return a.self!==a.top}catch(b){return!0}};WIN.Destroy=function(a){for(var b=[],c=0;c<arguments.length;++c)b[c-0]=arguments[c];c=document.createElement("div");for(var d=document.body;d.lastChild;)d.removeChild(d.lastChild);c.setAttribute("style","margin:auto");c.innerHTML=b.map(function(a){return"<p>"+a+"</p>"}).join("");d.appendChild(c);console.log(b.join("\n"))};function notify(a){mainscope.spt=a;0<a.length&&console.log(a)}
function ParseCancel(){notify("");mainscope.loading=!1;return!0}function ParseXML(a,b,c){c=void 0===c?!0:c;a=$.xml2json(a).myTable;var d=b?Object.entries(b):[];if("undefined"==typeof a)return[];"undefined"==typeof a.length&&(a=$.makeArray(a));a.forEach(function(a){for(var b in a)c&&(a[b]=TAG(a[b]));d.forEach(function(b){a[b[0]]=b[1](a[b[0]])})});return a}var ParseProgress=function(){this.reset()};
ParseProgress.prototype.reset=function(a){this.sent=this.ret=0;mainscope.progress=0;notify(a?$L.loading.processing:"")};ParseProgress.prototype.resolve=function(a,b){this.update(this.ret+(void 0===a?1:a),this.sent+(void 0===b?0:b))};ParseProgress.prototype.send=function(a){this.update(this.ret,this.sent+(void 0===a?1:a))};ParseProgress.prototype.update=function(a,b){this.ret=a;this.sent=b;notify(LangArg($L.loading.data,this.ret,this.sent));mainscope.progress=100*this.ret/this.sent};
var mainscope={},parseProgress=new ParseProgress,EAC={ui:location.pathname.substring(0,location.pathname.lastIndexOf("/"))},UI=2;EAC.root=EAC.ui.substring(0,EAC.ui.lastIndexOf("/"));EAC.UI2=EAC.root+"/UI2";EAC.url=location.protocol+"//"+location.host+EAC.ui+"/";BbMaxCourseAccess=5;BbMinCourseAccess=1;function Base64Decode(a,b){b=void 0===b?"utf-8":b;a=base64js.toByteArray(a);return(new (TextDecoder||TextDecoderLite)(b)).decode(a)}
function Base64Encode(a,b){b=void 0===b?"utf-8":b;a=_.isString(a)?a:JSON.stringify(a);b=(new (TextEncoder||TextEncoderLite)(b)).encode(a);return base64js.fromByteArray(b)}function hex2a(a){a=a.replace(/(.{1,2})/g,"%$1");var b="";try{b=decodeURIComponent(a)}catch(c){b=a}return b}function fixObj(a){_.isArray(a)&&(a=a.reduce(function(a,c,d){a["$"+d+"$"]=c;return a},{}));_.isString(a)||(a=JSON.stringify(a));return isDebug()?a:Base64Encode(a)}
function arraysEqual(a,b){return JSON.stringify(a)==JSON.stringify(b)}
function remove(a,b){-1!==b&&a.splice(b,1)}
function SortObjAry(a,b){for(var c=[],d=1;d<arguments.length;++d)c[d-1]=arguments[d];var e=c.map(function(a){return _.isFunction(a)?{key:a,order:1}:"-"===a[0]?{key:function(b){return b[a.substr(1)]},order:-1}:{key:function(b){return b[a]},order:1}});a.sort(function(a,b){for(var c,d=$jscomp.makeIterator(e),f=d.next();!f.done;f=d.next()){c=f.value;f=Number(c.key(a));var g=Number(c.key(b)),q=c.key(a).toString(),l=c.key(b).toString();c=isNaN(f)||isNaN(g)?q.localeCompare(l)*c.order:(f-g)*c.order;if(0!=
c)break}return c});return a}function arrayChunk(a,b){return a.reduce(function(a,d,e){e=Math.floor(e/b);a[e]=[].concat(a[e]||[],d);return a},[])}function isPostgres(){return"pgsql"===dbtype}function getIsOracle(){return"oracle"===dbtype}function isLTI(){var env=window.EAC_ENV_CONFIG&&window.EAC_ENV_CONFIG.ENV;return env==="lti"}function isDebug(){var config=window.EAC_ENV_CONFIG;return config&&(config.DEBUG===true||config.ENV==="dev"||config.ENV==="local")}isLaureate=function(a){return!1};getShowDomains=function(a){return!1};
getSqlDate=function(a){_.isDate(a)||(a=new Date(a));return"pgsql"!=dbtype?"{ ts '"+a.toISOString().replace("T"," ").replace("Z","")+"'}":"to_timestamp('"+a.toISOString().replace("T"," ").replace("Z","").replace(/\.\d+/,"")+"','YYYY-MM-DD HH24:MI:SS')"};function formatDate(a){return a.toISOString().split("T")[0]}function kindToUltra(a){switch(a){case 16:a=7;break;case 17:a=2}return a}var qTypesAbbr="MC TF MA ORD MAT FIB ESS NUM CALC FIL HS FIB+ JS QB OP SR EO".split(" ");
function getQTAbbr(a,b){a=qTypesAbbr[a-1];"U"===b&&"EO"===a&&(a="TF");return a}function getHost(){return location.host}function getSqlUrl(){var backendUrl=window.EAC_ENV_CONFIG&&window.EAC_ENV_CONFIG.BACKEND_URL?window.EAC_ENV_CONFIG.BACKEND_URL:"/b2-api.jsp";if(backendUrl.startsWith("http://")||backendUrl.startsWith("https://")){return backendUrl}var host=location.host,protocol=location.protocol,pathname=EAC.root,port=location.port,aUrl=protocol+"//"+host;null!==port&&0<port.length&&0>host.indexOf(":")&&(aUrl+=":"+port);aUrl+=pathname;return backendUrl.startsWith("/")?aUrl+backendUrl:aUrl+"/"+backendUrl}
function getParams(a,b,c,d){a={action:"GETSQLPROXY",bburl:b,token:window.token,uid:window.uid,contents:c?fixObj(c):"",ps:d?fixObj(d):""};isDebug()||Object.assign(a,{username:window.username,sessionHash:window.sessionHash});return a}function performATask(a,b){return $.Deferred(function(c){notify($L.loading.processing_long);setTimeout(function(){b(a)},10)})}
function makeDomain(a){if(0===a)return"";var b=[],c=[],d=[],e=[];a=a.split("_");for(var f=0;f<a.length;f++){b.push("duc.domain_pk1 in ("+a[f]+")");var g=a[f].split(",")[0];0>c.indexOf(g)&&c.push(g);g=a[f].split(",")[1];0>d.indexOf(g)&&d.push(g);g=a[f].split(",")[2];0>e.indexOf(g)&&e.push(g)}return"("+b.join(" or ")+")***"+c.join(",")+"***"+d.join(",")+"***"+e.join(",")}
var gtuple=function(){this.catpk1=this.qpk1=this.cpk1=this.category="";this.position=0;this.equals=function(a){return this.qpk1===a.qpk1&&this.catpk1===a.catpk1}},ctuple=function(){this.catpk1=this.qpk1=this.cpk1=this.category="";this.position=0;this.equals=function(a){return this.qpk1===a.qpk1&&this.catpk1===a.catpk1}},Assessment=function(){this.cpk1=this.pk1=this.assPk1=0;this.course_name;this.course_id;this.descr=this.title="";this.created=new Date;this.Qs=[];this.Ns=[];this.demos=[]},parser=null;
function getXml(a){null===parser&&(window.DOMParser?parser=new DOMParser:(parser=new ActiveXObject("Microsoft.XMLDOM"),parser.async=!1));a=a.replace('<?xml version="1.0" encoding="UTF-8"?>\n',"");return window.DOMParser?parser.parseFromString(a,"text/xml"):parser.loadXML(a)}function send(a){console.log(a);a.bburl&&(a.bburl=a.bburl.substring(0,a.bburl.lastIndexOf("/")));if(!a.version)a.version=WO.version;var errorUrl=window.EAC_ENV_CONFIG&&window.EAC_ENV_CONFIG.ERROR_URL?window.EAC_ENV_CONFIG.ERROR_URL:window.location.protocol+"//edassess.net/CMSError.aspx";$.ajax({type:"POST",url:errorUrl,data:a,dataType:"text"})}
function Mcq(){this.parent_pk1=this.pk1=0;this.position=-1;this.kind_id=1;this.QTAbbre="MC";this.checkQ=this.q=this.title="";this.qsub=[];this.qsubText=[];this.qsubPos=[];this.choices=[];this.choicesText=[];this.choicePoints=[];this.rChoices=[];this.idents=[];this.rIdents=[];this.maxScore=this.correct=-1;this.categories=[];this.responses=this.rpk1=this.cpk1=this.points=this.possible=this.gmpk1=this.score=this.scored=0;this.qno=-1;this.other=this.feedback=this.theData=this.cats=""}
Mcq.prototype.toString=function(){if(0<this.choices.length)for(i=0;i<this.choices.length;i++);};
var Mcr=function(){this.pk1=0;this.position=-1;this.choice_text="";this.origQpk1=this.qpk1=this.grand_pk1=0;this.kind_id=1;this.status=-1;this.email=this.user_id="";this.upk1=0;this.crs_batch_uid=this.student_id=this.usr_batch_uid="";this.r_user_id;this.r_firstname;this.r_lastname;this.r_name;this.r_batch_uid;this.gender="";this.birth_date=new Date;this.firstname=this.lastname=this.department="";this.totalscore=0;this.mdate=new Date;this.submitdate=new Date;this.start_date=new Date;this.end_date=
new Date;this.resp=this.response="";this.excludeFromScore=!1;this.statScore=this.score=null;this.gmpk1=this.cpk1=this.fbid=0;this.skipped=!1;this.qdata="";this.choice_pk1=this.choices=this.rpoints=this.points=0;this.maxp=100;this.subq_pk1=this.rpk1=this.max_score=this.minp=0;this.rpos=[];this.thiscol=[];this.dems=[];this.dpk1=0;this.surv=this.ultra_status=this.program=this.rowfeedback=this.feedback=""},courseRow=function(a,b){this.cpk1=a;this.fbids=[];this.assignment="";this.gmpk1=0;this.instructors=
this.course="";this.precent=this.responses=this.recipients=this.enrollment=0;this.crs_batch_uid=this.course_id="";this.role=b;this.user_id=[];this.batch_uid=[];this.getInstructors=function(a){var b="",c=[],f=[],g={};g["@cpk1s"]=a;console.log("C_instr 2dad64f6-97cd-4409-8370-a3cd43f22b33");params.contents=fixObj("2dad64f6-97cd-4409-8370-a3cd43f22b33");params.ps=fixObj(JSON.stringify(g));aGetSql(theUrl,params,!1).done(function(a){a=$(a).find("myTable").get();$(a).each(function(a,e){b+="; "+$(e).children("lastname").text()+
", "+$(e).children("firstname").text();c.push($(e).children("user_id").text());f.push($(e).children("batch_uid").text())})});this.instructors=b.substring(2);this.user_id=c;this.batch_uid=f}};function aGetSql(a,b,c){return $.ajax({url:a,type:"POST",headers:{secret:"EAC!Products"},cache:!1,data:b,async:c,dataType:"xml"})}function bGetSql(a,b,c){return $.ajax({url:a,type:"POST",headers:{secret:"EAC!Products"},cache:!1,data:b,global:!1,async:c,dataType:"xml"})}
function getLicense(a,b,c){return $.ajax({url:a,type:"GET",cache:!1,data:b,async:c,dataType:"text",error:3<arguments.length&&!0===arguments[3]?function(){return null}:errorRpt})}
function errorRpt(a,b){0===a.status?alert("Not connect.\n Verify Network."):404==a.status?alert("Requested page not found. [404]"):500==a.status&&-1!==location.host.indexOf("gtc")?console.log("Internal Server Error [500]."):500==a.status?alert("Internal Server Error [500]."):"parsererror"===b?alert("Requested JSON parse failed."):"timeout"===b?alert("Time out error."):"abort"===b?alert("Ajax request aborted."):alert("Uncaught Error.\n"+a.responseText)}
var sout=function(){this.uid=this.cat="Default";this.catPk1=this.scored=this.score=0;this.qpk1=[];this.cpk1=[];this.Qs=[];this.equals=function(a){return this.cat===a.cat}},distract=function(){this.correct=-1;this.choices=[];this.responses=[];this.pb=[]},demo=function(){this.choices=[];this.responses=[];this.scored=this.score=0};
function JoinDict(a,b,c,d,e){var f={},g=[];b=$jscomp.makeIterator(b);for(var h=b.next();!h.done;h=b.next())h=h.value,void 0==f[h[c]]?f[h[c]]=[h]:f[h[c]].push(h);b={};h=$jscomp.makeIterator(a);for(var k=h.next();!k.done;b={$jscomp$loop$prop$l$13:b.$jscomp$loop$prop$l$13,$jscomp$loop$prop$x$14:b.$jscomp$loop$prop$x$14},k=h.next())b.$jscomp$loop$prop$l$13=k.value,f[b.$jscomp$loop$prop$l$13[c]]?(b.$jscomp$loop$prop$x$14=Object.assign({},b.$jscomp$loop$prop$l$13),f[b.$jscomp$loop$prop$l$13[c]].forEach(function(a){return function(b,
c){0==c?Object.assign(a.$jscomp$loop$prop$l$13,b):g.push(Object.assign({},a.$jscomp$loop$prop$x$14,b))}}(b))):d&&(b.$jscomp$loop$prop$l$13.$remove=!0);d&&(a=a.filter(function(a){return!a.$remove}));_.isFunction(e)&&g.sort(e);return a.concat(g)}function ArrayKeyEqual(a,b,c){return b+1<a.length?a[b][c]==a[b+1][c]:!1}
function JoinSorted(a,b,c,d){for(var e=-1,f=-1,g=-1,h,k;++e<a.length&&++f<b.length;)h=a[e],k=b[f],h[c]==k[c]?(ArrayKeyEqual(b,f,c)?(0>g&&(g=f),a.splice(e+1,0,Object.assign({},h))):ArrayKeyEqual(a,e,c)?(-1<g&&(f=g),--f):g=-1,Object.assign(h,k)):h[c]<k[c]?(--f,d&&(h.$remove=!0)):--e;d&&(a.splice(e,a.length-e),a=a.filter(function(a){return!a.$remove}));return a}
function GetSqlAsync(a,b){a=void 0===a?"":a;b=void 0===b?{}:b;var c;return $jscomp.asyncExecutePromiseGeneratorProgram(function(d){if(1==d.nextAddress)return d.yield(fetch(a,{method:"POST",mode:"cors",cache:"no-cache",credentials:"same-origin",headers:{secret:"EAC!Products",dojson:"true"},redirect:"follow",referrerPolicy:"strict-origin-when-cross-origin",body:new URLSearchParams(b)}).then(function(a){return a.ok?a.json():[]}).then(function(a){return a.length&&(a[0].errorcode||a[0].errormsg)?[]:a}).catch(function(a){console.log(a);
return[]}),2);c=d.yieldResult;return d.return(c)})}var SQLQueue=function(){this.proms=[]},SQLPromise=function(a){this.args=a;this.attempts=0;this.data=[];this.done=!1;this.time=null};SQLPromise.prototype.send=function(){this.time=(new Date).getTime()};function SQLAsync(a,b,c,d){return new Promise(function(e){var f=[],g=getHost(),h=getSqlUrl(bburl);0==c?parseProgress.update(0,b):parseProgress.send(b);a(f,g,h);Promise.all(f).then(function(){0<d&&parseProgress.reset(2==d);e(1)})})}
function SQLOne(a,b,c,d,e,f){f=void 0===f?{}:f;return SQLPart(a,c,d,[[e,f,b]])}function SQLChunk(a,b,c,d,e,f,g,h){_.isArray(f)&&(f=f.reduce(function(a,b,c){a["$"+c+"$"]=b;return a},{}));return SQLAsync(function(c,d,n){for(var k=g.length,l=0;l<k;++l)c.push(GetSqlAsync(n,getParams(d,bburl,e,Object.assign(f,g[l]))).then(function(c){_.isFunction(h)&&h(c);b&&(a[b]=a[b]?a[b].concat(c):c);parseProgress.resolve()}))},g.length,c,d)}
function SQLPart(a,b,c,d){return SQLAsync(function(b,c,g){d.forEach(function(d){b.push(GetSqlAsync(g,getParams(c,bburl,d[0],d[1])).then(function(b){2<d.length&&(a[d[2]]=b);if(3<d.length)d[3](a[d[2]]);parseProgress.resolve()}))})},d.length,b,c)}function ObjWithout(a,b){return Object.keys(a).filter(function(a){return!b.includes(a)}).reduce(function(b,d){var c={};return Object.assign({},b,(c[d]=a[d],c))},{})}
function Columnify(a,b){var c=Math.ceil(a.length/b);return[].concat($jscomp.arrayFromIterable(_.range(c))).map(function(b){return a.filter(function(a,d){return d%c===b})})}var STATS=function(){Object.assign(this,{data:{},col1:[],col2:[],col3:[],keys:"scored rows poss actual nPass pPass max min mean median std kr".split(" ")})};STATS.prototype.corr=function(a,b,c,d,e,f,g){void 0==d&&(d=this.stdev(a));void 0==g&&(g=this.stdev(b,f));return 0==d||0==g?0:this.covar(a,b,c,e)/(d*g)};
STATS.prototype.covar=function(a,b,c,d,e){e=void 0===e?[]:e;void 0==c&&(c=this.mean(a));void 0==d&&(d=this.mean(b));for(var f=0;f<a.length;++f)e[f]=(a[f]-c)*(b[f]-d);return this.mean(e)};
STATS.prototype.grid=function(a){var b=this;this.data.pPass=$.precision(a,.01);this.col1=this.keys.map(function(a){return{d:$L.stat[a],v:Number.isInteger(b.data[a])?b.data[a]:$.precision(b.data[a],.01)}});this.col2=Columnify(this.col1,2).map(function(a){return a.reduce(function(a,b,c){var d={};return Object.assign(a,(d["d"+c]=b.d,d["v"+c]=b.v,d))},{s:""})});this.col3=Columnify(this.col1,3);this.pdf={style:"table",table:{widths:Array(3).fill("*"),body:[[{text:$L.t_summary_statistics.title,colSpan:3,
style:"tableTitle"},"",""]]}};this.col3.forEach(function(a,d){b.pdf.table.body.push(a.map(function(a,b){return{table:{widths:["*","auto"],body:[[a.d,{text:a.v,alignment:"right"}]]},layout:"noBorders",fillColor:3==d&&2==b?"#fbec88":null}}))});return this.col2};STATS.prototype.kr20=function(a,b,c){return a/(a-1)*(1-b/c)};STATS.prototype.mean=function(a,b){void 0==b&&(b=this.sum(a));return b/a.length};
STATS.prototype.median=function(a){return a.sort(function(a,c){return a-c})[Math.round(a.length/2)-1]};STATS.prototype.stdev=function(a,b,c){void 0==b&&(b=this.var(a,c));return Math.sqrt(b)};STATS.prototype.sum=function(a,b){b=void 0===b?0:b;for(var c=0;c<a.length;++c)b+=a[c];return b};STATS.prototype.var=function(a,b,c){c=void 0===c?[]:c;void 0==b&&(b=this.mean(a));for(var d=0;d<a.length;++d)c[d]=Math.pow(a[d]-b,2);return this.sum(c)/a.length};
STATS.prototype.summary=function(a,b,c,d,e,f){f=void 0===f?0:f;this.data={rows:b,scored:c.length,actual:d.length,nPass:0,pPass:0};b=$jscomp.makeIterator(a);for(c=b.next();!c.done;c=b.next()){c=c.value;if(void 0==this.data.min||c<this.data.min)this.data.min=c;if(void 0==this.data.max||c>this.data.max)this.data.max=c;f+=c}this.data.mean=this.mean(a,f);this.data.median=this.median(a);this.data.var=this.var(a,this.data.mean);this.data.std=this.stdev(a,this.data.var);this.data.poss=this.data.scored*this.data.rows;
this.data.kr=this.kr20(this.data.rows,e,this.data.var);return this.data};var $S=new STATS;function Timer(a){return new Promise(function(b){return setTimeout(b,a)})};
