<%@ page errorPage="error.jsp" %>
<%@page pageEncoding="UTF-8"%>
<%@page import="java.util.*,
        java.io.*,
        java.nio.*,
        java.nio.charset.*,
        java.net.*,
        java.sql.*,
        java.lang.*,
        java.text.*,
        java.util.zip.*,
        java.util.regex.*,
        java.security.*,
        java.security.spec.*,
        javax.crypto.*,
        javax.crypto.spec.*,
        java.util.Base64,
        blackboard.base.*,
        blackboard.db.*,
        blackboard.persist.user.*,
        blackboard.persist.user.impl.*,
        blackboard.persist.course.*,
        blackboard.persist.gradebook.*,
        blackboard.platform.plugin.*,
        blackboard.platform.plugin.impl.*,
        blackboard.data.content.*,
        blackboard.platform.db.*,
        blackboard.platform.session.*,
        blackboard.platform.config.*,
        blackboard.platform.context.*,
        blackboard.data.course.*,
        blackboard.data.user.*,
        blackboard.data.gradebook.*,
        blackboard.data.gradebook.impl.*,
        blackboard.persist.gradebook.impl.*,
        blackboard.platform.filesystem.*,
        blackboard.platform.persistence.*,
        blackboard.platform.context.impl.*,
        blackboard.platform.vxi.data.*,
        blackboard.platform.vxi.persist.impl.*,
        blackboard.platform.vxi.service.*,
        blackboard.platform.*,
        blackboard.platform.log.*,
        blackboard.util.*,
        blackboard.xml.*,
        blackboard.persist.*,
        java.security.MessageDigest,
        java.util.Properties,
        org.json.simple.*,
        org.json.simple.parser.*" %>

<%!
    // Token generation constant - used to hash userId + path for per-user tokens
    public static final String TOKEN_SALT = "EAC#2020";
    
    // Configuration constants
    public static final int MAX_QUERY_LENGTH = 10000;
    public static final int MAX_ROWS_RETURNED = 10000;
    
    // Read environment configuration from env.json (generated file in webapp root)
    // Returns the config map, or null if not found
    // This method uses ServletContext to reliably locate the webapp root
    public static Map<String, Object> readEnvConfig(javax.servlet.ServletContext application) {
        try {
            // Get the real path to the webapp root
            String webappRoot = application.getRealPath("/");
            if (webappRoot == null) {
                // Fallback: try to get it from the context path
                webappRoot = application.getRealPath("");
            }
            
            // Construct path to env.json in webapp root
            File envFile = new File(webappRoot, "env.json");
            
            // If not found, try alternative locations
            if (!envFile.exists()) {
                // Try relative to WEB-INF
                File webinfFile = new File(webappRoot, "WEB-INF/../env.json");
                if (webinfFile.exists()) {
                    envFile = webinfFile;
                } else {
                    // Try direct path (for development)
                    envFile = new File("src/main/webapp/env.json");
                }
            }
            
            if (!envFile.exists()) {
                System.err.println("Warning: env.json not found. Tried: " + new File(webappRoot, "env.json").getAbsolutePath());
                return null;
            }
            
            JSONParser parser = new JSONParser();
            try (FileReader reader = new FileReader(envFile)) {
                // env.json is a flat structure (not nested by environment)
                Map<String, Object> config = (Map<String, Object>) parser.parse(reader);
                return config;
            }
        } catch (Exception e) {
            System.err.println("Error reading env.json: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
    
    /**
     * Get a specific config value from env.json
     * @param application ServletContext (use 'application' in JSP)
     * @param key Configuration key (e.g., "BACKEND_URL", "ENV", "DEBUG", "LICENSE_CHECK_URL")
     * @param defaultValue Fallback value if key not found
     * @return Configuration value or defaultValue
     */
    public static String getEnvConfigValue(javax.servlet.ServletContext application, String key, String defaultValue) {
        Map<String, Object> config = readEnvConfig(application);
        if (config != null && config.containsKey(key)) {
            Object value = config.get(key);
            return value != null ? value.toString() : defaultValue;
        }
        return defaultValue;
    }
    
    /**
     * Get the VERSION from env.json
     * @param application ServletContext (use 'application' in JSP)
     * @return Version string or "0.0.0" if not found
     */
    public static String getVersion(javax.servlet.ServletContext application) {
        return getEnvConfigValue(application, "VERSION", "0.0.0");
    }
    
    /**
     * Get the application root path from the request
     * @param request The HttpServletRequest
     * @return The root application path
     */
    public static String getPath(javax.servlet.http.HttpServletRequest request) {
        return getPath(request, null);
    }
    
    /**
     * Get the application path from the request with optional path appended
     * @param request The HttpServletRequest
     * @param path Optional path to append (e.g., "/api.jsp"). If null or empty, returns just the root path
     * @return The full application path
     */
    public static String getPath(javax.servlet.http.HttpServletRequest request, String path) {
        String scheme = request.getScheme();          // http or https
        String serverName = request.getServerName();  // example.com
        int serverPort = request.getServerPort();     // 80, 443, or custom
        String contextPath = request.getContextPath();// "" or "/appname-random"
        
        boolean defaultPort =
            ("http".equals(scheme) && serverPort == 80) ||
            ("https".equals(scheme) && serverPort == 443);
        
        String basePath = scheme + "://" +
               serverName +
               (defaultPort ? "" : ":" + serverPort) +
               contextPath;
        
        if (path != null && !path.isEmpty()) {
            // Ensure path starts with / if it doesn't already
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return basePath + path;
        }
        
        return basePath;
    }
    
    // Generate token for a user: hash(userId + path + TOKEN_SALT)
    public static String generateUserToken(String userId, javax.servlet.http.HttpServletRequest request) {
        try {
            String path = getPath(request, "/b2-api.jsp");
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String input = userId + path + TOKEN_SALT;
            byte[] hashbytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            
            // Convert to hex string
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hashbytes.length; i++) {
                String hex = Integer.toHexString(0xff & hashbytes[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        } catch (Exception e) {
            System.err.println("Error generating token: " + e.getMessage());
            return null;
        }
    }
    
    /**
     * Generate license token for check-license and register-license API calls
     * Token is SHA-256 hash of (hostname + TOKEN_SALT)
     * Extracts hostname from endpoint URL to ensure consistency with server validation
     * @param endpointUrl The full endpoint URL (e.g., "https://bd-partner-a-ultra.blackboard.com/webapps/.../api.jsp")
     * @return Token string or null on error
     */
    public static String generateLicenseToken(String endpointUrl) {
        try {
            // Extract hostname from endpoint URL (e.g., "bd-partner-a-ultra.blackboard.com")
            // This ensures consistency with how the server extracts hostname from the same URL
            java.net.URL url = new java.net.URL(endpointUrl);
            String hostname = url.getHost();
            
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String input = hostname + TOKEN_SALT;
            byte[] hashbytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            
            // Convert to hex string
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < hashbytes.length; i++) {
                String hex = Integer.toHexString(0xff & hashbytes[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        } catch (Exception e) {
            System.err.println("Error generating license token: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
    
    // Validate token for a user
    public static boolean validateUserToken(String token, String userId, javax.servlet.http.HttpServletRequest request) {
        if (token == null || userId == null || request == null) {
            return false;
        }
        String expectedToken = generateUserToken(userId, request);
        return expectedToken != null && expectedToken.equals(token);
    }
    
    // SQL injection protection
    public static boolean isSQLInjectionSafe(String sql) {
        if (sql == null || sql.isEmpty()) {
            return false;
        }
        
        // Check for dangerous patterns
        String upperSQL = sql.toUpperCase().trim();
        
        // Allow SELECT, INSERT, UPDATE, DELETE statements (queries come from controlled sources)
        if (!upperSQL.startsWith("SELECT") && 
            !upperSQL.startsWith("INSERT") && 
            !upperSQL.startsWith("UPDATE") && 
            !upperSQL.startsWith("DELETE")) {
            return false;
        }
        
        // Block dangerous keywords that should never be allowed
        String[] dangerousKeywords = {
            "DROP", "CREATE", "ALTER", "EXEC", "EXECUTE", "TRUNCATE", "MERGE", "REPLACE",
            "GRANT", "REVOKE", "COMMIT", "ROLLBACK", "SAVEPOINT"
        };
        
        for (String keyword : dangerousKeywords) {
            if (upperSQL.contains(keyword)) {
                return false;
            }
        }
        
        // Block semicolons (queries should be single statements)
        if (sql.contains(";")) {
            return false;
        }
        
        return true;
    }
    
    // Escape JSON string
    public static String escapeJsonString(String str) {
        if (str == null) return "";
        return str.replace("\\", "\\\\")
                 .replace("\"", "\\\"")
                 .replace("\n", "\\n")
                 .replace("\r", "\\r")
                 .replace("\t", "\\t");
    }
    
    // Escape XML string
    public static String escapeXmlString(String str) {
        if (str == null) return "";
        return str.replace("&", "&amp;")
                 .replace("<", "&lt;")
                 .replace(">", "&gt;")
                 .replace("'", "&#039;")
                 .replace("\"", "&#034;");
    }
    
    // Convert List to JSON array
    public static String convertListToJson(List<?> list) {
        if (list == null) return "[]";
        
        StringBuilder json = new StringBuilder();
        json.append("[");
        
        boolean first = true;
        for (Object item : list) {
            if (!first) json.append(",");
            
            if (item instanceof Map) {
                json.append(convertMapToJson((Map<?, ?>) item));
            } else if (item instanceof String) {
                json.append("\"").append(escapeJsonString((String) item)).append("\"");
            } else if (item instanceof Number || item instanceof Boolean) {
                json.append(item);
            } else {
                json.append("\"").append(String.valueOf(item)).append("\"");
            }
            first = false;
        }
        
        json.append("]");
        return json.toString();
    }
    
    // Convert Map to JSON object
    public static String convertMapToJson(Map<?, ?> map) {
        if (map == null) return "{}";
        
        StringBuilder json = new StringBuilder();
        json.append("{");
        
        boolean first = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!first) json.append(",");
            
            String key = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            
            json.append("\"").append(escapeJsonString(key)).append("\":");
            
            if (value instanceof String) {
                json.append("\"").append(escapeJsonString((String) value)).append("\"");
            } else if (value instanceof Number || value instanceof Boolean) {
                json.append(value);
            } else if (value instanceof List) {
                json.append(convertListToJson((List<?>) value));
            } else if (value instanceof Map) {
                json.append(convertMapToJson((Map<?, ?>) value));
            } else {
                json.append("\"").append(String.valueOf(value)).append("\"");
            }
            first = false;
        }
        
        json.append("}");
        return json.toString();
    }
    
    // Convert ResultSet to List of Maps
    public static List<Map<String, Object>> resultSetToList(ResultSet rs) throws SQLException {
        List<Map<String, Object>> results = new ArrayList<>();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        
        int rowCount = 0;
        while (rs.next() && rowCount < MAX_ROWS_RETURNED) {
            Map<String, Object> row = new HashMap<>();
            
            for (int i = 1; i <= columnCount; i++) {
                String columnName = metaData.getColumnName(i);
                Object value = rs.getObject(i);
                
                if (value instanceof Blob) {
                    Blob blob = (Blob) value;
                    byte[] bytes = blob.getBytes(1, (int) blob.length());
                    value = Base64.getEncoder().encodeToString(bytes);
                } else if (value instanceof byte[]) {
                    value = Base64.getEncoder().encodeToString((byte[]) value);
                }
                
                row.put(columnName.toLowerCase(), value);
            }
            
            results.add(row);
            rowCount++;
        }
        
        return results;
    }
    
    // Convert ResultSet to JSON array (raw format - compatible with current frontend)
    public static String resultSetToJsonArray(ResultSet rs) throws SQLException {
        List<Map<String, Object>> results = resultSetToList(rs);
        return convertListToJson(results);
    }
    
    // Convert ResultSet to XML string
    public static String resultSetToXml(ResultSet rs) throws SQLException {
        StringBuilder xml = new StringBuilder();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        
        int rowCount = 0;
        while (rs.next() && rowCount < MAX_ROWS_RETURNED) {
            xml.append("<myTable>");
            
            for (int i = 1; i <= columnCount; i++) {
                String columnName = metaData.getColumnName(i).toLowerCase();
                String columnType = metaData.getColumnTypeName(i).toUpperCase();
                Object value = rs.getObject(i);
                
                if (value instanceof Blob || "BLOB".equals(columnType) || "IMAGE".equals(columnType)) {
                    Blob blob = rs.getBlob(i);
                    byte[] bytes = blob.getBytes(1, (int) blob.length());
                    String base64 = Base64.getEncoder().encodeToString(bytes);
                    xml.append("<").append(columnName).append(">").append(base64).append("</").append(columnName).append(">");
                } else {
                    String field = value != null ? value.toString() : "";
                    field = escapeXmlString(field);
                    xml.append("<").append(columnName).append(">").append(field).append("</").append(columnName).append(">");
                }
            }
            
            xml.append("</myTable>");
            rowCount++;
        }
        
        return xml.toString();
    }
    
    // Create JSON success response with metadata (future-proof format)
    public static String createJSONSuccessResponse(Map<String, Object> data) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"success\":true,");
        json.append("\"timestamp\":").append(System.currentTimeMillis());
        
        if (data != null && !data.isEmpty()) {
            json.append(",\"data\":");
            json.append(convertMapToJson(data));
        }
        
        json.append("}");
        return json.toString();
    }
    
    // Create JSON error response with metadata
    public static String createJSONErrorResponse(String errorId, String message) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"success\":false,");
        json.append("\"timestamp\":").append(System.currentTimeMillis());
        json.append(",\"error\":{");
        json.append("\"id\":\"").append(escapeJsonString(errorId)).append("\",");
        json.append("\"message\":\"").append(escapeJsonString(message)).append("\"");
        json.append("}");
        json.append("}");
        return json.toString();
    }
    
    /**
     * Parse response type from request
     * Priority: 1) responsetype parameter, 2) dojson header (backwards compatibility)
     * 
     * @param request The HttpServletRequest
     * @return String: "json", "xml", "rawjson", or "rawxml"
     */
    public static String parseResponseType(javax.servlet.http.HttpServletRequest request) {
        // First check for responsetype parameter in request body
        String responsetype = request.getParameter("responsetype");
        if (responsetype != null && !responsetype.isEmpty()) {
            responsetype = responsetype.toLowerCase().trim();
            // Validate the value
            if ("json".equals(responsetype) || "xml".equals(responsetype) || 
                "rawjson".equals(responsetype) || "rawxml".equals(responsetype)) {
                return responsetype;
            }
        }
        
        // Fall back to dojson header for backwards compatibility
        String dojsonHeader = request.getHeader("dojson");
        if (dojsonHeader != null) {
            return "rawjson";
        } else {
            return "rawxml";
        }
    }
    
    /**
     * Execute SQL query and return results in the requested format
     * 
     * @param sqlQuery The SQL query to execute
     * @param responseType "json", "xml", "rawjson", or "rawxml" - response format
     * @return Map with keys: "statusCode" (int), "response" (String), "rowCount" (int, only if metadata format)
     */
    public static Map<String, Object> executeQuery(String sqlQuery, String responseType) {
        // Determine format and metadata inclusion from responseType
        boolean includeMetadata = "json".equals(responseType) || "xml".equals(responseType);
        String format = responseType.replace("raw", "").toLowerCase(); // "json" or "xml"
        
        Map<String, Object> result = new HashMap<>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        
        try {
            // Validate SQL query length
            if (sqlQuery == null || sqlQuery.isEmpty()) {
                result.put("statusCode", 400);
                if (includeMetadata) {
                    result.put("response", createJSONErrorResponse("QUERY_REQUIRED", "SQL query is required"));
                } else {
                    result.put("response", format.equals("json") ? "[]" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentElement />");
                }
                return result;
            }
            
            if (sqlQuery.length() > MAX_QUERY_LENGTH) {
                result.put("statusCode", 400);
                if (includeMetadata) {
                    result.put("response", createJSONErrorResponse("QUERY_TOO_LONG", "SQL query too long. Maximum length is " + MAX_QUERY_LENGTH + " characters"));
                } else {
                    result.put("response", format.equals("json") ? "[]" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentElement />");
                }
                return result;
            }
            
            // Check for SQL injection
            if (!isSQLInjectionSafe(sqlQuery)) {
                result.put("statusCode", 400);
                if (includeMetadata) {
                    result.put("response", createJSONErrorResponse("SQL_INJECTION_DETECTED", "SQL query contains potentially dangerous content"));
                } else {
                    result.put("response", format.equals("json") ? "[]" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentElement />");
                }
                return result;
            }
            
            // Execute query
            conn = ConnectionManager.getDefaultConnection();
            stmt = conn.createStatement();
            stmt.setQueryTimeout(300); // 5 minutes timeout
            
            String upperSQL = sqlQuery.toUpperCase().trim();
            
            // Handle SELECT queries (return ResultSet)
            if (upperSQL.startsWith("SELECT")) {
                rs = stmt.executeQuery(sqlQuery);
                
                if ("xml".equals(format)) {
                    // XML format
                    String xmlData = resultSetToXml(rs);
                    if (includeMetadata) {
                        // Metadata XML format
                        StringBuilder xmlResponse = new StringBuilder();
                        xmlResponse.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                        xmlResponse.append("<results>");
                        xmlResponse.append("<rowCount>").append(xmlData.split("<myTable>").length - 1).append("</rowCount>");
                        xmlResponse.append("<data>").append(xmlData).append("</data>");
                        xmlResponse.append("</results>");
                        result.put("response", xmlResponse.toString());
                    } else {
                        // Raw XML format (current format - backwards compatible)
                        StringBuilder xmlResponse = new StringBuilder();
                        xmlResponse.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                        xmlResponse.append("<results>").append(xmlData).append("</results>");
                        result.put("response", xmlResponse.toString());
                    }
                } else {
                    // JSON format
                    List<Map<String, Object>> results = resultSetToList(rs);
                    
                    if (includeMetadata) {
                        // Metadata format (future-proof)
                        Map<String, Object> responseData = new HashMap<>();
                        responseData.put("rowCount", results.size());
                        responseData.put("results", results);
                        result.put("response", createJSONSuccessResponse(responseData));
                        result.put("rowCount", results.size());
                    } else {
                        // Raw JSON array format (current format - compatible with frontend)
                        result.put("response", convertListToJson(results));
                    }
                }
            } else {
                // Handle INSERT, UPDATE, DELETE queries (return int - rows affected)
                int rowsAffected = stmt.executeUpdate(sqlQuery);
                
                if ("xml".equals(format)) {
                    if (includeMetadata) {
                        StringBuilder xmlResponse = new StringBuilder();
                        xmlResponse.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                        xmlResponse.append("<results>");
                        xmlResponse.append("<rowCount>").append(rowsAffected).append("</rowCount>");
                        xmlResponse.append("<data></data>");
                        xmlResponse.append("</results>");
                        result.put("response", xmlResponse.toString());
                    } else {
                        result.put("response", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentElement />");
                    }
                } else {
                    if (includeMetadata) {
                        // Metadata format
                        Map<String, Object> responseData = new HashMap<>();
                        responseData.put("rowCount", rowsAffected);
                        responseData.put("results", new ArrayList<>());
                        result.put("response", createJSONSuccessResponse(responseData));
                        result.put("rowCount", rowsAffected);
                    } else {
                        // Raw format - empty array for non-SELECT queries
                        result.put("response", "[]");
                    }
                }
            }
            
            result.put("statusCode", 200);
            return result;
            
        } catch (SQLException e) {
            result.put("statusCode", 500);
            if (includeMetadata) {
                result.put("response", createJSONErrorResponse("SQL_EXECUTION_ERROR", "Error executing SQL query: " + e.getMessage()));
            } else {
                result.put("response", format.equals("json") ? "[]" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentElement />");
            }
            return result;
        } catch (Exception e) {
            result.put("statusCode", 500);
            if (includeMetadata) {
                result.put("response", createJSONErrorResponse("INTERNAL_ERROR", "Internal error: " + e.getMessage()));
            } else {
                result.put("response", format.equals("json") ? "[]" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DocumentElement />");
            }
            return result;
        } finally {
            // Clean up resources
            if (rs != null) try { rs.close(); } catch (SQLException e) {}
            if (stmt != null) try { stmt.close(); } catch (SQLException e) {}
            if (conn != null) try { ConnectionManager.releaseDefaultConnection(conn); } catch (Exception e) {}
        }
    }
    
    /**
     * Check license using the new API
     * @param request HttpServletRequest to get endpoint path
     * @param eacVersion Optional EAC version
     * @param bbVersion Optional Blackboard version
     * @param username Optional username
     * @return License result: "true", "false", or "pl:..." format string, or null on error
     */
    public static String checkLicense(javax.servlet.http.HttpServletRequest request, String eacVersion, String bbVersion, String username) {
        try {
            String endpoint = getPath(request, "/api.jsp");
            
            // Generate token using shared function from util.jsp
            // Pass endpoint URL to ensure hostname extraction matches server validation
            String token = generateLicenseToken(endpoint);
            if (token == null) {
                return null; // Token generation failed
            }
            
            // Build request body
            Map<String, Object> requestBody = new HashMap<>();
            requestBody.put("endpoint", endpoint);
            requestBody.put("token", token);
            if (eacVersion != null && !eacVersion.isEmpty()) {
                requestBody.put("eacVersion", eacVersion);
            }
            if (bbVersion != null && !bbVersion.isEmpty()) {
                requestBody.put("bbVersion", bbVersion);
            }
            if (username != null && !username.isEmpty()) {
                requestBody.put("username", username);
            }
            
            // Make POST request
            // Read URL from env.json
            String licenseCheckUrl = getEnvConfigValue(request.getServletContext(), "LICENSE_CHECK_URL", null);
            if (licenseCheckUrl == null) {
                return null; // Error - required config missing
            }
            URL url = new URL(licenseCheckUrl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            
            // Write request body
            try (java.io.OutputStreamWriter writer = new java.io.OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8)) {
                writer.write(convertMapToJson(requestBody));
                writer.flush();
            }
            
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                return null; // Error - return null to indicate failure
            }
            
            // Read response
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            
            // Parse JSON response
            JSONParser parser = new JSONParser();
            JSONObject jsonResponse = (JSONObject) parser.parse(response.toString());
            Object licenseObj = jsonResponse.get("license");
            
            if (licenseObj == null) {
                return null;
            }
            
            if (licenseObj instanceof Boolean) {
                return ((Boolean) licenseObj) ? "true" : "false";
            } else if (licenseObj instanceof String) {
                String licenseStr = (String) licenseObj;
                // If it's a string, assume it's in pl: format or return as-is
                return licenseStr;
            } else {
                // Convert to string
                return licenseObj.toString();
            }
            
        } catch (Exception e) {
            System.err.println("Error checking license: " + e.getMessage());
            e.printStackTrace();
            return null; // Return null on error
        }
    }
    
    /**
     * Register license using the new API
     * @param request HttpServletRequest to get endpoint path
     * @param licenseKey The license key to register
     * @param eacVersion Optional EAC version
     * @param bbVersion Optional Blackboard version
     * @param username Optional username
     * @return License result: "true", "false", or "pl:..." format string, or null on error
     */
    public static String registerLicense(javax.servlet.http.HttpServletRequest request, String licenseKey, String eacVersion, String bbVersion, String username) {
        try {
            String endpoint = getPath(request, "/api.jsp");
            
            // Generate token using shared function from util.jsp
            // Pass endpoint URL to ensure hostname extraction matches server validation
            String token = generateLicenseToken(endpoint);
            if (token == null) {
                return null; // Token generation failed
            }
            
            // Build request body
            Map<String, Object> requestBody = new HashMap<>();
            requestBody.put("endpoint", endpoint);
            requestBody.put("token", token);
            requestBody.put("licenseKey", licenseKey);
            if (eacVersion != null && !eacVersion.isEmpty()) {
                requestBody.put("eacVersion", eacVersion);
            }
            if (bbVersion != null && !bbVersion.isEmpty()) {
                requestBody.put("bbVersion", bbVersion);
            }
            if (username != null && !username.isEmpty()) {
                requestBody.put("username", username);
            }
            
            // Make POST request
            // Read URL from env.json
            String licenseRegisterUrl = getEnvConfigValue(request.getServletContext(), "LICENSE_REGISTER_URL", null);
            if (licenseRegisterUrl == null) {
                return null; // Error - required config missing
            }
            URL url = new URL(licenseRegisterUrl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            
            // Write request body
            try (java.io.OutputStreamWriter writer = new java.io.OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8)) {
                writer.write(convertMapToJson(requestBody));
                writer.flush();
            }
            
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                return null; // Error - return null to indicate failure
            }
            
            // Read response
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8))) {
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            
            // Parse JSON response
            JSONParser parser = new JSONParser();
            JSONObject jsonResponse = (JSONObject) parser.parse(response.toString());
            Object licenseObj = jsonResponse.get("license");
            
            if (licenseObj == null) {
                return null;
            }
            
            if (licenseObj instanceof Boolean) {
                return ((Boolean) licenseObj) ? "true" : "false";
            } else if (licenseObj instanceof String) {
                String licenseStr = (String) licenseObj;
                // If it's a string, assume it's in pl: format or return as-is
                return licenseStr;
            } else {
                // Convert to string
                return licenseObj.toString();
            }
            
        } catch (Exception e) {
            System.err.println("Error registering license: " + e.getMessage());
            e.printStackTrace();
            return null; // Return null on error
        }
    }
%>

