var DefaultColors=GetColors(10,1,false,true), differed=false, page='none';
pdfMake.fonts={Roboto:{normal:'Roboto-Regular.ttf',bold:'Roboto-Medium.ttf',
	italics:'Roboto-Italic.ttf', bolditalics:'Roboto-MediumItalic.ttf'} };

function StartDoc(x, o) {
	return `${(x?'<!DOCTYPE html>':'')}<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:w="urn:schemas-microsoft-com:office:word" xmlns="http://www.w3.org/TR/REC-html40"><head><meta charset="utf-8"><title>${(n_title?n_title[0]:'EAC')}</title><style> p.MsoNormal, li.MsoNormal, div.MsoNormal {mso-style-unhide:no; mso-style-qformat:yes; mso-style-parent:""; margin:0in; margin-bottom:.0001pt; mso-pagination:widow-orphan; font-size:12.0pt; font-family:"Times New Roman",serif; mso-fareast-font-family:"Times New Roman"; mso-fareast-theme-font: minor-fareast;} </style></head> <body>${(n_title ? '<h2 style="text-align:center; font-family:\'Calibri\', sans-serif;">' +n_title[0]+ '</h2>'+(o?'<p style="text-align:center; font-family:\'Calibri\', sans-serif;">' +n_title[2]+ '</p>':'')+'<p style="text-align:center; font-family:\'Calibri\', sans-serif;">' +n_title[1]+ '</p>':'')}${differed ? '<p style=" text-align:center; font-family:\'Calibri\', sans-serif;">' +$L.msg.test_differed+ '</p>':''}${page=='outcome'&&pts&&pts.enabled ? '<p style=" text-align:center; font-family:\'Calibri\', sans-serif;">' +$L.level_editor.download_warning+ '</p>':''}`;
}

/*if (isDebug()){
	shortcut.add("Ctrl+Shift+E", function() {
		if (isDebug()) throw "Test Error";
	});
}*/

function GetLang(id) {
	if (id.startsWith('es')) return 'es';
	else return 'en';
}
function LoadLang(id) {
	$.ajaxSetup({async:false});
	$.getJSON('../Lang/'+id+'.json?v=6.2.282', function(response){
		$L = response;
	});
	$.ajaxSetup({async:true});
}
var storedObject = { set:function(key, obj, base64) {
		if (!base64) localStorage.setItem(key, JSON.stringify(obj));
		else localStorage.setItem(key, Base64Encode(JSON.stringify(obj)));
	}, get:function(key, base64) {
		try { if (!base64) return JSON.parse(localStorage.getItem(key));
			else return JSON.parse(Base64Decode(localStorage.getItem(key)));
		} catch(e) { return false; }
	}
}
function LangArg() {
	let str = arguments[0];
	for (let i = 1; i < arguments.length; i++) str = str.replace('{'+(i-1)+'}', arguments[i]);
	return str;
}
function AryInsert(original, item, index) {
	return [...original.slice(0, index), item, ...original.slice(index)];
}

function stripFilename(str, ext = '.xlsx', time = true) {
	let ts = time ? '-' + (new Date().toISOString()) : '';
	return `${str}${ts}${ext}`.replace(/:\s+/g, '-').replace(/[\\/*?"<>|\s]+/g, '_');
}

// class for ag-grid container
function CustomTooltip () {}
CustomTooltip.prototype.init = function(params) {
	var eGui=this.eGui=document.createElement('div'), color=params.color||'white';
	var header=params.rowIndex === undefined;
	eGui.classList.add('custom-tooltip');
	eGui.style['background-color'] = color;
	if (header && params.value) {
		eGui.innerHTML = params.value;
	} else {
		let data = params.api.getDisplayedRowAtIndex(params.rowIndex).data;
		eGui.innerHTML = data[params.colDef.tooltipField];
	}
};
CustomTooltip.prototype.getGui = function() {
	return this.eGui;
};
class CHeader {
	init(p) {
		let field=p.column.colDef.field, index=isNaN(field)?-1:Number(field);
		this.eGui = document.createElement('div');
		$(this.eGui).addClass('flex-center full-size');
		if (index>-1) this.eGui.onclick=function(){window[p.func](this,event,index,p.args,true)};
		this.Update(p);
	}
	getGui() {
		return this.eGui;
	}
	refresh(p) {
		this.Update(p);
		return true;
	}
	Update(p) {
		let field=p.column.colDef.field,index=!p.args||isNaN(field)?-1:Number(field);
		this.eGui.innerHTML=`<div class="flex-center">${index>-1?`<span style="margin-right:10px;"><div ref="eWrapper" class="ag-wrapper ag-input-wrapper ag-checkbox-input-wrapper ${p.args.tag}" role="presentation" ><input ref="eInput" class="ag-input-field-input ag-checkbox-input" type="checkbox" aria-label="checkbox" tabindex="-1"></div></span>`:''}<span>${p.displayName}</span></div>`;
	}
}
class CustomHeaderWithButtons {
	init(params) {
		this.params = params;
		
		// Get sortable/filterable from column definition
		const colDef = params.column.getColDef();
		this.sortable = colDef.sortable !== false;
		this.filterable = colDef.filter !== false && colDef.filter !== null;
		
		// Create the main container - ag-grid expects this structure
		this.eGui = document.createElement('div');
		this.eGui.className = 'ag-header-cell';
		this.eGui.setAttribute('role', 'columnheader');
		
		// Create the label container (ag-grid's standard structure)
		this.eLabelContainer = document.createElement('div');
		this.eLabelContainer.className = 'ag-cell-label-container';
		this.eLabelContainer.setAttribute('role', 'presentation');
		
		// Create menu button
		this.eMenuButton = document.createElement('span');
		this.eMenuButton.className = 'ag-header-icon ag-header-cell-menu-button';
		this.eMenuButton.setAttribute('ref', 'eMenu');
		
		// Create label wrapper
		this.eLabel = document.createElement('div');
		this.eLabel.className = 'ag-header-cell-label';
		this.eLabel.setAttribute('role', 'presentation');
		
		// Create custom buttons container
		this.eButtonsContainer = document.createElement('div');
		this.eButtonsContainer.style.cssText = 'margin-right:20px; display:inline-flex;';
		this.eButtonsContainer.className = 'header-ctr';
		this.eButtonsContainer.onclick = function(e) { e.stopPropagation(); };
		
		const deselectBtn = document.createElement('button');
		deselectBtn.className = 'header-btn';
		deselectBtn.textContent = '–';
		deselectBtn.title = $L.icon.deselect;
		deselectBtn.onclick = function(e) { e.stopPropagation(); gs.degroup(); };
		
		const reselectBtn = document.createElement('button');
		reselectBtn.className = 'header-btn';
		reselectBtn.textContent = '+';
		reselectBtn.title = $L.icon.reselect;
		reselectBtn.onclick = function(e) { e.stopPropagation(); gs.reselect(); };
		
		this.eButtonsContainer.appendChild(deselectBtn);
		this.eButtonsContainer.appendChild(reselectBtn);
		
		// Create header text
		this.eText = document.createElement('span');
		this.eText.className = 'ag-header-cell-text';
		this.eText.setAttribute('role', 'columnheader');
		this.eText.setAttribute('ref', 'eText');
		
		// Create filter icon - always show when filterable
		this.eFilterIcon = document.createElement('span');
		this.eFilterIcon.className = 'ag-header-icon ag-filter-icon';
		this.eFilterIcon.setAttribute('ref', 'eFilter');
		if (this.filterable) {
			// Ensure filter icon is always visible
			this.eFilterIcon.style.display = 'inline-block';
			this.eFilterIcon.style.visibility = 'visible';
			this.eFilterIcon.style.opacity = '1';
		} else {
			this.eFilterIcon.style.display = 'none';
		}
		
		// Create sort icons (ag-grid will manage visibility)
		this.eSortOrder = document.createElement('span');
		this.eSortOrder.className = 'ag-header-icon ag-sort-order';
		this.eSortOrder.setAttribute('ref', 'eSortOrder');
		
		this.eSortAsc = document.createElement('span');
		this.eSortAsc.className = 'ag-header-icon ag-sort-ascending-icon';
		this.eSortAsc.setAttribute('ref', 'eSortAsc');
		
		this.eSortDesc = document.createElement('span');
		this.eSortDesc.className = 'ag-header-icon ag-sort-descending-icon';
		this.eSortDesc.setAttribute('ref', 'eSortDesc');
		
		this.eSortNone = document.createElement('span');
		this.eSortNone.className = 'ag-header-icon ag-sort-none-icon';
		this.eSortNone.setAttribute('ref', 'eSortNone');
		
		// Assemble the structure - filter icon should be on the right side
		this.eLabel.appendChild(this.eButtonsContainer);
		this.eLabel.appendChild(this.eText);
		// Add filter icon after text (on the right side like other columns)
		if (this.filterable) {
			this.eLabel.appendChild(this.eFilterIcon);
		}
		// Add sort icons after filter icon
		if (this.sortable) {
			this.eLabel.appendChild(this.eSortOrder);
			this.eLabel.appendChild(this.eSortAsc);
			this.eLabel.appendChild(this.eSortDesc);
			this.eLabel.appendChild(this.eSortNone);
		}
		
		this.eLabelContainer.appendChild(this.eMenuButton);
		this.eLabelContainer.appendChild(this.eLabel);
		this.eGui.appendChild(this.eLabelContainer);
		
		// Update display name
		this.updateParams(params);
		
		// Setup event handlers for sort/filter
		this.setupEventHandlers();
		
		// Listen for sort changes on the column (not the API)
		if (this.sortable) {
			this.sortChangedListener = () => {
				this.updateSortIcons();
			};
			params.column.addEventListener('sortChanged', this.sortChangedListener);
		}
		
		// Listen for filter changes on the column
		if (this.filterable) {
			this.filterChangedListener = () => {
				this.updateFilterIcon();
			};
			params.column.addEventListener('filterChanged', this.filterChangedListener);
		}
		
		// Initial icon updates
		this.updateSortIcons();
		this.updateFilterIcon();
	}
	
	getGui() {
		return this.eGui;
	}
	
	refresh(params) {
		this.params = params;
		this.updateParams(params);
		this.updateSortIcons();
		this.updateFilterIcon();
		return true;
	}
	
	destroy() {
		// Clean up event listeners
		if (this.sortChangedListener && this.params) {
			this.params.column.removeEventListener('sortChanged', this.sortChangedListener);
		}
		if (this.filterChangedListener && this.params) {
			this.params.column.removeEventListener('filterChanged', this.filterChangedListener);
		}
	}
	
	setupEventHandlers() {
		// Make header text clickable for sorting using ag-grid's progressSort method
		if (this.sortable && this.eText) {
			this.eText.style.cursor = 'pointer';
			this.eText.addEventListener('click', (e) => {
				// Don't trigger sort if clicking on the custom buttons area
				if (e.target.closest('.header-ctr')) return;
				e.stopPropagation();
				// Use ag-grid's progressSort method (cycles through sort states)
				if (this.params.progressSort) {
					this.params.progressSort(e.shiftKey);
				}
			});
		}
		
		// Make the entire label clickable for sorting (ag-grid default behavior)
		if (this.sortable && this.eLabel) {
			this.eLabel.style.cursor = 'pointer';
			this.eLabel.addEventListener('click', (e) => {
				// Don't trigger sort if clicking on the custom buttons area or filter icon
				if (e.target.closest('.header-ctr') || e.target.closest('.ag-filter-icon')) return;
				e.stopPropagation();
				// Use ag-grid's progressSort method
				if (this.params.progressSort) {
					this.params.progressSort(e.shiftKey);
				}
			});
		}
		
		// Wire up filter icon click - use showColumnMenu without parameter
		if (this.filterable && this.eFilterIcon) {
			this.eFilterIcon.style.cursor = 'pointer';
			this.eFilterIcon.addEventListener('click', (e) => {
				e.stopPropagation();
				// Use ag-grid's showColumnMenu method
				if (this.params.showColumnMenu) {
					this.params.showColumnMenu();
				}
			});
		}
		
		// Wire up sort icons to use progressSort
		if (this.sortable) {
			[this.eSortAsc, this.eSortDesc, this.eSortNone].forEach(icon => {
				if (icon) {
					icon.style.cursor = 'pointer';
					icon.addEventListener('click', (e) => {
						e.stopPropagation();
						// Use ag-grid's progressSort method
						if (this.params.progressSort) {
							this.params.progressSort(e.shiftKey);
						}
					});
				}
			});
		}
	}
	
	updateSortIcons() {
		if (!this.sortable) return;
		
		const sort = this.params.column.getSort();
		
		// Hide all sort icons
		if (this.eSortOrder) this.eSortOrder.style.display = 'none';
		if (this.eSortAsc) this.eSortAsc.style.display = 'none';
		if (this.eSortDesc) this.eSortDesc.style.display = 'none';
		if (this.eSortNone) this.eSortNone.style.display = 'none';
		
		// Show appropriate icon based on sort state
		if (sort === 'asc' && this.eSortAsc) {
			this.eSortAsc.style.display = 'inline-block';
		} else if (sort === 'desc' && this.eSortDesc) {
			this.eSortDesc.style.display = 'inline-block';
		} else if (this.eSortNone) {
			this.eSortNone.style.display = 'inline-block';
		}
	}
	
	updateFilterIcon() {
		if (!this.filterable || !this.eFilterIcon) return;
		
		// Always show filter icon when filterable
		this.eFilterIcon.style.display = 'inline-block';
		this.eFilterIcon.style.visibility = 'visible';
		this.eFilterIcon.style.opacity = '1';
		
		// Check if filter is active and update appearance
		const isFilterActive = this.params.column.isFilterActive ? this.params.column.isFilterActive() : false;
		
		// Add/remove class to indicate active filter state
		if (isFilterActive) {
			this.eFilterIcon.classList.add('ag-filter-icon-filtered');
		} else {
			this.eFilterIcon.classList.remove('ag-filter-icon-filtered');
		}
	}
	
	updateParams(params) {
		const displayName = params.displayName || params.column.getColDef().headerName || '';
		if (this.eText) {
			this.eText.textContent = displayName;
		}
	}
}

// Shared helper function to render rubric/outcome links with specified OA parameter
function renderRubricLink(eGui, value, rowData, oaValue) {
	// If value is already HTML (contains <a> tag), render it directly
	// Otherwise create a link element
	if (value && value.trim().startsWith('<')) {
		// Value is already HTML, render it directly
		eGui.innerHTML = value;
		// Re-attach onclick handler to the link if it exists
		let link = eGui.querySelector('a');
		if (link) {
			// Ensure link stays blue even after being visited
			link.style.color = '#0066cc';
			link.style.textDecoration = 'none';
			// Set onclick handler with hardcoded OA value
			link.onclick = (function(rowData, oaValue) {
				return function(event) {
					popRubrics(this, event, rowData, oaValue);
					return false;
				};
			})(rowData, oaValue);
		}
	} else {
		// Create link element for plain text values
		let link = document.createElement('a');
		link.href = `${EAC.url}EacRubrics.html?report=${value}`;
		link.target = '_blank';
		link.className = 'popup';
		link.style.whiteSpace = 'normal';
		link.style.wordWrap = 'break-word';
		link.style.overflowWrap = 'break-word';
		link.style.color = '#0066cc';
		link.style.textDecoration = 'none';
		link.title = value;
		link.textContent = value;
		// Set onclick handler with hardcoded OA value
		link.onclick = (function(rowData, oaValue) {
			return function(event) {
				popRubrics(this, event, rowData, oaValue);
				return false;
			};
		})(rowData, oaValue);
		// Clear and add the link
		eGui.innerHTML = '';
		eGui.appendChild(link);
	}
}

class RubricCellRenderer {
	init(params) {
		this.eGui = document.createElement('div');
		this.eGui.style.display = 'flex';
		this.eGui.style.alignItems = 'center';
		this.updateParams(params);
	}
	getGui() {
		return this.eGui;
	}
	refresh(params) {
		this.updateParams(params);
		return true;
	}
	updateParams(params) {
		let value = params.value || '';
		// Get the row data directly from params.node.data - this is the specific row for this cell
		let rowData = params.node && params.node.data ? params.node.data : (params.data || null);
		// Rubrics list links: hardcode OA=false
		renderRubricLink(this.eGui, value, rowData, false);
	}
}
class OutcomeCellRenderer {
	init(params) {
		this.eGui = document.createElement('div');
		this.eGui.style.display = 'flex';
		this.eGui.style.alignItems = 'center';
		this.updateParams(params);
	}
	getGui() {
		return this.eGui;
	}
	refresh(params) {
		this.updateParams(params);
		return true;
	}
	updateParams(params) {
		let value = params.value || '';
		// Get the row data directly from params.node.data - this is the specific row for this cell
		let rowData = params.node && params.node.data ? params.node.data : (params.data || null);
		// Outcomes list links: hardcode OA=true
		renderRubricLink(this.eGui, value, rowData, true);
	}
}
class PieChartCellRenderer {
	init(params) {
		this.eGui = document.createElement('div');
		this.eGui.style.maxHeight = '100%';
		this.eGui.style.maxWidth = '100%';
		this.scope = null;
		this.updateParams(params);
	}
	getGui() {
		return this.eGui;
	}
	refresh(params) {
		this.updateParams(params);
		return true;
	}
	destroy() {
		// Clean up Angular scope when cell is destroyed
		if (this.scope) {
			this.scope.$destroy();
			this.scope = null;
		}
	}
	updateParams(params) {
		const value = params.value || '';
		// Clean up previous scope if it exists
		if (this.scope) {
			this.scope.$destroy();
			this.scope = null;
		}
		
		// Clear previous content
		this.eGui.innerHTML = '';
		
		// If value contains eac-chart directive, compile it with Angular
		if (value && value.includes('eac-chart')) {
			// Get Angular injector to access $compile service
			const injector = angular.element(document.body).injector();
			if (injector) {
				const $compile = injector.get('$compile');
				this.scope = injector.get('$rootScope').$new();
				
				// Set the HTML content
				this.eGui.innerHTML = value;
				
				// Compile the Angular directive
				$compile(this.eGui)(this.scope);
			} else {
				// Fallback: just set innerHTML if Angular isn't available
				this.eGui.innerHTML = value;
			}
		} else {
			// For non-directive content, just set innerHTML
			this.eGui.innerHTML = value;
		}
	}
}
class GridBox {
	constructor(args) { //title, keys, headers, model, props, auto
		this.filter = SetDefault(args.filter, true);
		if (args.copy) this.filter = args.copy.filter;
		let bas = _.bind(this.AutoSize, this), defaultProps = { localeText:$L.grid, onVirtualColumnsChanged:this.Scroll, suppressMenuHide:true, components:{customTooltip:CustomTooltip, rubricCellRenderer:RubricCellRenderer, outcomeCellRenderer:OutcomeCellRenderer, pieChartCellRenderer:PieChartCellRenderer, customHeaderWithButtons:CustomHeaderWithButtons}, popupParent:document.querySelector("body"), suppressColumnVirtualisation: true, suppressScrollOnNewData: true, /*enableCellTextSelection: true, ensureDomOrder: true*/ }, defaultColDef = { resizable:true, sortable:true, tooltipComponent:'customTooltip', /*wrapText:true, autoHeight:true*/ };
		Object.assign(this, { props:{}, hidden:[], alert:false });
		if ('copy' in args) {
			this.ntypes = args.copy.ntypes;
			AssignKeys(this, args.copy, ['mode', 'title', 'sheetTitle', 'keys', 'headers', 'auto', 'fit', 'autoIfNeeded', 'autoIfScroll', 'sheet', 'sheetNames']);
			this.grid = $.extend({columnDefs:args.copy.grid.columnDefs, onRowDataChanged:bas, onGridSizeChanged:bas, onGridReady:bas, onDragStopped:this.ColChange.bind(this)}, defaultProps);
			this.grid.defaultColDef = defaultColDef;
			// For blueprint grids, use the first key (No/no column) as row ID to preserve scroll position and selection
			if (this.mode === 'blueprint' && this.keys && this.keys.length > 0) {
				const rowIdField = this.keys[0]; // First key is 'No' or 'no'
				this.grid.getRowId = (params) => {
					return params.data[rowIdField];
				};
			}
			this.AddProps(args.copy.props);
			this.AddModel(args.copy.grid.rowData);
			this.enabledObj = false;
			this.enabledVal = false;
		} else {
			this.mode = args.mode;
			this.title = args.title;
			this.sheetHeader = SetDefault(args.sheetHeader, args.title);
			this.sheetTitle = SetDefault(args.sheetTitle, args.title);
			this.id = args.id;
			this.keys = args.keys;
			this.headers = SetDefault(args.headers, this.keys);
			let columns = Array(this.keys.length);
			for (let i = 0; i < this.keys.length; i++) columns[i] = { headerName:this.headers[i], field:this.keys[i], cellClass:['cell-vertical-align-text-left'] };
			this.grid = $.extend({columnDefs:columns, onRowDataChanged:bas, onGridSizeChanged:bas, onGridReady:bas, onDragStopped:this.ColChange.bind(this)}, defaultProps);
			this.grid.defaultColDef = defaultColDef;
			// For blueprint grids, use the first key (No/no column) as row ID to preserve scroll position and selection
			if (this.mode === 'blueprint' && this.keys && this.keys.length > 0) {
				const rowIdField = this.keys[0]; // First key is 'No' or 'no'
				this.grid.getRowId = (params) => {
					return params.data[rowIdField];
				};
			}
			if ('props' in args) this.AddProps(args.props);
			if (_.isArray(args.auto)) {
				this.auto = args.auto;
				for (let col of this.grid.columnDefs) if (_.contains(args.auto, col.field)) col.suppressSizeToFit = true;
			} else if (args.auto) this.auto = this.keys;
			else this.auto = false;
			this.ntypes = SetDefault(args.ntypes, []);
			let stype = { i:'int', f:'float', s:'string' };
			if (args.stypes) this.ntypes = args.stypes.split('').map(x => stype[x]);
			this.fit = !('auto' in args) || _.isArray(args.auto);
			this.autoIfNeeded = args.autoIfNeeded;
			this.autoIfScroll = args.autoIfScroll;
			this.sheet = SetDefault(args.sheet, this.keys);
			this.sheetNames = SetDefault(args.sheetNames, args.sheet, this.headers).map(x => toTitleCase(x));
			this.sheetData = SetDefault(args.sheetData, false);
			if ('model' in args) this.AddModel(args.model);
			this.enabledObj = SetDefault(args.getEnabled, false);
			this.enabledVal = SetDefault(args.enabled, (appHome) ? appHome.includes(this.id) : false);
			if (args.replace) mainscope.main.grids = mainscope.main.grids.filter(x=>x.id!=this.id);
			if (!this.enabledObj && this.enabledVal && !args.refresh) mainscope.main.grids.push(this);
			if ('colProps' in args) this.AddColProps(args.colProps);
			if ('pdfkeys' in args) {
				if (_.isArray(args.pdfkeys)) {
					this.pdfkeys = [];
					for (let a of args.pdfkeys) this.pdfkeys.push(this.grid.columnDefs[a]);
				} else if (args.pdfkeys.sheet) {
					this.pdfkeys = this.sheet.map(x => {return {field:x}; });
					this.sheetNames.forEach((x,i) => {this.pdfkeys[i].headerName=x;} );
				} else {
					this.pdfkeys = this.grid.columnDefs.slice(args.pdfkeys.start, args.pdfkeys.end);
				}
			}
			if ('pdfdata' in args) this.pdfdata = args.pdfdata;
			this.pdfwidths = SetDefault(args.pdfwidths, []);
			this.pdfbars = args.pdfbars;
			if (args.format) this.Format();
			this.load = SetDefault(args.load, function(){}); 
			this.unload = SetDefault(args.unload, function(){});
			this.sort = SetDefault(args.sort, []);
			this.autoSort = SetDefault(args.autoSort, false);
			this.cacheDownload = SetDefault(args.cacheDownload, true);
		}
		this.downloadPdf=!['studentLandscape', 'landscapeStudent', 'studentGoalPerf'].includes(this.mode);
		this.gridInstance = null; // Store the grid instance
	}
	InitGrid(gridContainerIdOrElement) {
		// Initialize ag-grid using vanilla JS
		// Can accept either an ID string or a DOM element
		try {
			let gridDiv;
			if (typeof gridContainerIdOrElement === 'string') {
				gridDiv = document.querySelector('#' + gridContainerIdOrElement);
			} else {
				gridDiv = gridContainerIdOrElement;
			}
			
			if (!gridDiv) {
				console.error('Grid container not found:', gridContainerIdOrElement);
				return;
			}
			
			// Check if grid is already initialized on this container
			// In ag-grid v34, we can check if the container has ag-grid attributes
			// But if the container was removed from DOM (ng-if), we need to re-initialize
			if (this.grid.api && this.gridInstance && gridDiv.querySelector('.ag-root-wrapper')) {
				// Grid is already initialized and DOM element exists
				// If there's existing rowData, update it
				// Use setGridOption for ag-grid v34+
				if (this.grid.rowData && Array.isArray(this.grid.rowData) && this.grid.api) {
					if (typeof this.grid.api.setGridOption === 'function') {
						this.grid.api.setGridOption('rowData', this.grid.rowData);
					} else if (typeof this.grid.api.setRowData === 'function') {
						this.grid.api.setRowData(this.grid.rowData);
					}
				}
				return;
			}
			
			// If grid was previously initialized but DOM was removed (ng-if), clear the API references
			if (this.grid.api && !gridDiv.querySelector('.ag-root-wrapper')) {
				// Grid instance exists but DOM was removed - need to re-initialize
				this.grid.api = null;
				this.gridInstance = null;
				this.grid.columnApi = null;
			}
			
			// Check if agGrid is available
			if (typeof agGrid === 'undefined' || !agGrid.createGrid) {
				console.error('agGrid is not loaded or createGrid method not available');
				return;
			}
			
			// Use legacy CSS-based theming (required for vanilla JS with script tags)
			if (!this.grid.theme) {
				this.grid.theme = 'legacy'; // Use legacy CSS-based theming
			}
			
			// Store reference to grid container for later use
			this.gridContainer = gridDiv;
			
			// Ensure onGridReady callback is set to capture the API
			const originalOnGridReady = this.grid.onGridReady;
			this.grid.onGridReady = (params) => {
				// Store API references - params.api is the definitive API object
				this.grid.api = params.api;
				this.grid.columnApi = params.api; // columnApi methods are now on api
				this.gridInstance = params.api;
				// Store grid container reference in API for AutoSize to use
				if (params.api) {
					params.api._gridContainer = gridDiv;
				}
				// If rowData was set before the grid was ready, set it now
				// Use setGridOption for ag-grid v34+
				if (this.grid.rowData && Array.isArray(this.grid.rowData) && params.api) {
					if (typeof params.api.setGridOption === 'function') {
						params.api.setGridOption('rowData', this.grid.rowData);
					} else if (typeof params.api.setRowData === 'function') {
						params.api.setRowData(this.grid.rowData);
					}
				}
				// Call original callback if it exists (it's bound to AutoSize)
				if (originalOnGridReady) {
					originalOnGridReady.call(this, params);
				}
			};
			
			// Ensure rowData is set in grid options if it exists
			// This ensures createGrid uses the latest data
			if (this.grid.rowData && Array.isArray(this.grid.rowData)) {
				this.grid.rowData = this.grid.rowData;
			}
			
			// In ag-grid v34, use createGrid to initialize the grid
			// createGrid returns the grid API immediately, but we also store it in onGridReady
			const gridApi = agGrid.createGrid(gridDiv, this.grid);
			// Store API immediately if available (for cases where AddModel is called before onGridReady)
			// In ag-grid v34, createGrid returns the API directly
			if (gridApi) {
				// Always update the API reference from createGrid return value
				this.grid.api = gridApi;
				this.grid.columnApi = gridApi; // columnApi methods are now on api
				this.gridInstance = gridApi;
				// If rowData was set before the grid was created, set it now
				// Use setGridOption for ag-grid v34+
				if (this.grid.rowData && Array.isArray(this.grid.rowData)) {
					if (typeof gridApi.setGridOption === 'function') {
						gridApi.setGridOption('rowData', this.grid.rowData);
					} else if (typeof gridApi.setRowData === 'function') {
						gridApi.setRowData(this.grid.rowData);
					}
				}
			}
		} catch (error) {
			console.error('Error initializing grid:', error, 'Grid container:', gridContainerIdOrElement);
			throw error; // Re-throw to be caught by error handler
		}
	}
	AddProps(props) {
		Object.assign(this.grid, props);
		Object.assign(this.props, props);
	}
	AddColProps(ary) {
		let args = (arguments.length == 1) ? ary : arguments;
		for (let i = 0; i < args.length - 1; i+=2) for (let index of args[i]) Object.assign(this.grid.columnDefs[index], args[i+1]);
	}
	AddModel(model, sheetData, pdfdata, keepSelection) {
		if (this.autoSort && this.sort.length) model = SortObjAry(model, ...this.sort);
		let selection = [];
		if (this.grid.api && typeof this.grid.api.getSelectedNodes === 'function') {
			selection = this.grid.api.getSelectedNodes();
		}
		this.grid.rowData = SetDefault(model, []);
		
		// In ag-grid v34, use setGridOption instead of setRowData
		// The API is stored in this.grid.api
		const gridApi = this.grid.api || this.gridInstance;
		
		// Use setGridOption('rowData', data) for ag-grid v34+
		if (gridApi && typeof gridApi.setGridOption === 'function') {
			gridApi.setGridOption('rowData', this.grid.rowData);
		} else if (gridApi && typeof gridApi.setRowData === 'function') {
			// Fallback for older ag-grid versions
			gridApi.setRowData(this.grid.rowData);
		}
		this.Format();
		if (sheetData) this.sheetData=sheetData;
		if (pdfdata) this.pdfdata=pdfdata;
		if (keepSelection && this.grid.api && typeof this.grid.api.getRowNode === 'function') {
			selection.forEach(x => {
				const rowNode = this.grid.api.getRowNode(x.id);
				if (rowNode && typeof rowNode.setSelected === 'function') {
					rowNode.setSelected(true);
				}
			});
		}
	}
	AutoSize() {
		_.defer(function(gridBox, auto, fit, needed, autoIfScroll){
			if (!gridBox.grid.api) return;
			// In ag-grid v34, columnApi methods are merged into api
			const api = gridBox.grid.api;
			const allColumns = api.getColumns();
			if (!allColumns || allColumns.length === 0) return;
			
			// Calculate used width for autoIfScroll check
			let usedWidth = 0;
			allColumns.forEach(col => {
				const width = col.getActualWidth();
				if (width) usedWidth += width;
			});
			
			// Get container element - use stored reference
			let container = api._gridContainer || gridBox.gridContainer;
			if (!container && gridBox.id) {
				// Try to find it by the grid's ID
				container = document.querySelector('#' + gridBox.id + '-grid');
			}
			// Last resort: find by class (may not be accurate if multiple grids)
			if (!container) {
				container = document.querySelector('.ag-theme-quartz');
			}
			if (!container) return;
			const availableWidth = container.clientWidth;
			const ais = autoIfScroll && usedWidth > availableWidth;
			
			// Auto-size columns if needed
			if (ais || auto) {
				api.autoSizeColumns(allColumns);
			}
			
			// Size columns to fit if needed
			if (fit && !needed) {
				api.sizeColumnsToFit();
			}
			
			if ((fit && needed) || ais) {
				// Recalculate after auto-sizing
				usedWidth = 0;
				allColumns.forEach(col => {
					const width = col.getActualWidth();
					if (width) usedWidth += width;
				});
				if (usedWidth < availableWidth) {
					api.sizeColumnsToFit();
				}
			}
			
			if (auto || fit) {
				api.resetRowHeights();
			}
		}, this, this.auto, this.fit, this.autoIfNeeded, this.autoIfScroll);
	}
	ColChange() {
		if (!this.grid.api) return;
		// In ag-grid v34, columnApi methods are merged into api
		const allColumns = this.grid.api.getColumns();
		if (!allColumns) return;
		let displayed = allColumns.map(x => x.getColDef().field);
		for (let col of this.grid.columnDefs) {
			if (!displayed.includes(col.field) && !this.hidden.includes(col.field)) {
				this.hidden.push(col.field);
				this.alert = col;
				// Trigger Angular digest if mainscope exists (for backward compatibility)
				if (mainscope && mainscope.$apply) mainscope.$apply();
				return;
			}
		}
	}
	get enabled() {
		if (_.isBoolean(this.enabledObj)) return this.enabledVal;
		return this.enabledObj.enabledVal;
	}
	set enabled(value) {
		if (_.isBoolean(this.enabledObj)) this.enabledVal = value;
		else this.enabledObj.enabledVal = value;
	}
	GetData() {
		let data = this.grid, gridData = [], sheetData = this.sheetData;
		if (!sheetData) {
			if (data.api != undefined) {
				gridData = Array(data.api.getDisplayedRowCount());
				for (let i = 0; i < gridData.length; i++) gridData[i] = data.api.getDisplayedRowAtIndex(i).data;
			}
			else gridData = data.rowData;
			sheetData = gridData.map(function(x) {
				let obj = {};
				for (let i = 0; i < this.sheet.length; i++) obj[this.sheet[i]] = x[this.sheet[i]];
				return obj;
			}, this);
		}
		return sheetData;
	}
	GetSheet(book, extraHeader) {
		let data = this.grid, gridData = [], sheetData = this.sheetData;
		if (!sheetData) {
			if (data.api != undefined) {
				gridData = Array(data.api.getDisplayedRowCount());
				for (let i = 0; i < gridData.length; i++) gridData[i] = data.api.getDisplayedRowAtIndex(i).data;
			}
			else gridData = data.rowData;
			sheetData = gridData.map(function(x) {
				let obj = {};
				for (let i = 0; i < this.sheet.length; i++) obj[this.sheet[i]] = x[this.sheet[i]];
				return obj;
			}, this);
		}
		let cells = [];
		if (extraHeader) cells.push([this.sheetHeader]);
		cells.push(this.sheetNames);
		for (let i = 0; i < sheetData.length; i++) cells.push(this.sheet.map(x => _.isNumber(sheetData[i][x])?$.precision(sheetData[i][x],1e-3):sheetData[i][x]));
		if (this.footer) cells.push([this.footer]);
		let ws = XLSX.utils.aoa_to_sheet(cells);
		XLSX.utils.book_append_sheet(book, ws, TruncSheet(this.sheetTitle));
	}
	GetDoc() { // # doc 
		let bar = false, stackedBars = ['goalsSummary','rowAnalysis'];
		let cds = this.pdfkeys && this.mode!='details' ? this.pdfkeys : this.grid.columnDefs;
		if (this.mode=='goalsSummary' && page=='test') bar = 'Avg';
		//else if (this.mode=='rowAnalysis') bar = 'avg';
		let table = (this.mode!='coursesIncluded'?'<p class=MsoNormal><span style="font-family:\'Calibri\',sans-serif;"><o:p>&nbsp;</o:p></span></p>\n':'') + '<table style="width:100%; border:1px solid black; border-collapse:collapse;mso-padding-left-alt:5pt;mso-padding-right-alt:5pt;">\n<thead>\n<tr>\n<th style="border:1px solid black; background-color:#80CEFF; font-family:\'Calibri\', sans-serif; font-size:14pt;" colspan="';
		if (this.mode=='summaryStatistics') {
			let arg = [[0,3,6],[1,4,7],[2,5,8],[-1,9,-2]];
			table += arg[0].length+'">'+toTitleCase($L.t_summary_statistics.title)+'</th>\n</tr>';
			for (let row of arg) {
				table += '<tr>\n';
				for (let i=0; i<row.length; ++i) {
					let cell = row[i];
					if (cell < -1) continue;
					table += `<td ${(i<row.length-1 && row[i+1]<-1)?'colspan="' + (-1*row[i+1]) + '" ':''} style="border:1px solid black;${cell==-1?' background-color:#7f7f7f;">':'"><p style="font-family:\'Calibri\', sans-serif;">'+summaryDownload[cell].Description+'<w:PTab Alignment="RIGHT" RelativeTo="MARGIN" Leader="NONE"></w:PTab>'+summaryDownload[cell].Value+'</p>'}</td>\n`;
				}
				table += '</tr>\n';
			}
			table += '</table>\n';
			return table;
		} else if (this.mode=='summaryStats') {
			table += `${$S.col3[0].length}">${toTitleCase($L.t_summary_statistics.title)}</th>\n</tr>`;
			$S.col3.forEach((x,i)=>{
				table += '<tr>\n';
				x.forEach((y,j)=>{ table += `<td style="border:1px solid black;${i==3&&j==2?' background-color:#fbec88;':''}"><p style="font-family: 'Calibri', sans-serif;">${y.d}<w:PTab RelativeTo="MARGIN" Alignment="RIGHT" Leader="NONE"></w:PTab>${y.v}</p></td>\n`; });
				table += '</tr>\n';
			});
			table += '</table>\n';
			return table;
		}
		table += cds.length+'">'+toTitleCase(this.sheetHeader)+'</th>\n</tr>\n<tr>\n';
		for (let c of cds) table += '<th style="border:1px solid black; font-family:\'Calibri\', sans-serif;'+(bar===c.field?' background-color:#AAFFAA;':'')+'">'+toTitleCase(c.headerName)+'</th>\t';
		table += '</tr>\n</thead>\n';
		this.grid.rowData.forEach((row, rownum) => {
			if (this.mode=='details' && !row.no) return;
			table += '<tr>\n';
			cds.forEach((col, colnum) => {
				let value = row[col.field]!=undefined?row[col.field]:'';
				if (!(_.isString(value)&&value.trim()==='')&&!isNaN(value)) value = $.precision(value, 1e-2);
				let r = (_.isNumber(value) || !isNaN(Number(value)))?' text-align:right;':'';
				if (this.mode=='distractors') table += `<td style="border:1px solid black; font-family:\'Calibri\', sans-serif;${row.no?' border-top:3px solid black;':''}${(row.correct==$L.correct_value && colnum>2)?' background-color:#AAFFAA;':''}${r}">${value}</td>`;
				else if (this.mode=='questionSummary') table += '<td style="border:1px solid black; font-family:\'Calibri\', sans-serif;'+(col.field==row.correct?' background-color:#AAFFAA;':'')+r+'">'+value+'</td>';
				else if (this.mode=='details' && page=='outcome') {
					if (row.no) {
						if (colnum == 3) {
							let dat = row.counts.map((x,i)=>`<span style="color:${DefaultColors[i]}">&nbsp;&nbsp;&#x25fc;&nbsp;&nbsp;</span> ${x} (${$.precision(100*x/row.total, 1e-1)}%) ${data.col[i].rcol}<br />`);
							table += '<td style="border:1px solid black; font-family:\'Calibri\', sans-serif;">' + dat.join('') + '</td>';
						} else if (colnum == 4) {
							let percents = row.counts.map(x=>$.precision(x/row.total, 1e-3));
							let pie = pimg2.drawPie(percents);
							table += `<td style="border:1px solid black; font-family:\'Calibri\', sans-serif; text-align:center;"><img src="${pie}" alt="${$L.aria.pie}"/></td>`;
						} else if (colnum == 2) table += `<td style="border:1px solid black; font-family:\'Calibri\', sans-serif;${r}">${$.precision(value, 1e-2)}</td>`;
						else table += `<td style="border:1px solid black; font-family:\'Calibri\', sans-serif;${r}">${value}</td>`;
					}
				} else table += '<td style="border:1px solid black; font-family:\'Calibri\', sans-serif;'+r+'">'+value+'</td>';
			});
			table += '</tr>\n';
			if (bar) table += '<tr>\n<td colspan="'+cds.length+'" style="padding:0pt 0pt 0pt 0pt;"><table style="width:100%; mso-cellspacing:0pt;"><tr><td style="background-color:#AAFFAA; width:'+(row[bar]*100)+'%; border-right:1px solid black; font-size:50%;">&nbsp;</td><td></td></tr></table></td>\n</tr>\n';
			else if (stackedBars.includes(this.mode)&&page=='outcome') {
				table += '<tr>\n<td colspan="'+cds.length+'" style="padding:0pt 0pt 0pt 0pt;"><table style="width:100%; mso-cellspacing:0pt;"><tr>';
				row.bars.forEach((percent, i) => {
					table += '<td style="background-color:'+DefaultColors[i]+'; width:'+(percent/pts.max)+'%; border-right:1px solid black; font-size:50%;">&nbsp;</td>';
				});
				table += '<td></td></tr></table></td>\n</tr>\n';
			}
		});
		table += '</table>\n';
		return table;
	}
	GetPdf() {
		if (this.mode=='details' && page=='outcome') {
			let result = [], keys = this.pdfkeys != undefined ? this.pdfkeys : this.grid.columnDefs, data = this.grid.rowData, stack = [], colors = GetColors(window.data.col.length, 1, false, true);
			result.push(Array(keys.length + 1).fill(''));
			result[0][0] = {text:this.sheetHeader, colSpan:keys.length + 1, style:'tableTitle'};
			result.push(keys.map(x => ({text:toTitleCase(x.headerName), style:'tableHeader'})));
			result[1].push({text:toTitleCase($L.r_details.cols[4]), style:'tableHeader'});
			for (let i = 0; i < data.length; i++) {
				if (data[i] == null) continue;
				if (i % window.data.col.length == 0) {
					result.push(Array(keys.length + 1));
					for (let j = 0; j < keys.length - 1; j++) {
						if (data[i][keys[j].field]==undefined) _.last(result)[j]='';
						else if (j==2) _.last(result)[j]=$.precision(data[i][keys[j].field], 1e-2);
						else _.last(result)[j]=data[i][keys[j].field];
					}
					_.last(result)[keys.length - 1] = {stack:[{ul:[elipses(data[i].level, 75)], markerColor:colors[i % window.data.col.length], type:'square'}]};
					stack = [data[i].percent];
				} else {
					_.last(result)[keys.length - 1].stack.push({ul:[elipses(data[i].level, 75)], markerColor:colors[i % window.data.col.length], type:'square'});
					stack.push(data[i].percent);
				}
				if (i % window.data.col.length == window.data.col.length - 1) {
					_.last(result)[keys.length]={width:100,image:pimg.drawPie(stack)};
				}
			}
			this.pdfdata = {style:'table', table:{headerRows:2, widths:(new Array(keys.length + 1).fill('auto')), body:result, dontBreakRows:true, keepWithHeaderRows:true}};
			for (let col of this.pdfwidths) this.pdfdata.table.widths[col] = '*';
		} else if (this.mode=='goalsSummary' && page=='rubric') {
			let result = [], keys = this.pdfkeys != undefined ? this.pdfkeys : this.grid.columnDefs, data = this.grid.rowData, colors = GetColors(scoreQs[0].choicesText.length, 1, false, true);
			result.push(Array(keys.length + 1).fill(''));
			result[0][0] = {text:this.sheetHeader + ' (' + $L.r_goals_summary.cols[3] + ': ' + data[0].Threshhold + ')', colSpan:keys.length + 1, style:'tableTitle'};
			result.push(keys.map(x => ({text:toTitleCase(x.headerName), style:'tableHeader', fillColor:(this.pdfbars==x.field ? '#aaffaa':'')})));
			result[1].push({text:toTitleCase($L.r_details.cols[3]), style:'tableHeader'});
			for (let i = 0; i < data.length; i++) {
				if (data[i] == null) continue;
				result.push(Array(keys.length + 1));
				for (let j = 0; j < keys.length; j++) {
					_.last(result)[j] = data[i][keys[j].field] != undefined ? data[i][keys[j].field] : '';
				}
				_.last(result)[0] = breakWord(_.last(result)[0]);
				_.last(result)[keys.length] = {stack:scoreQs[0].choicesText.map((x, n) => {return {ul:[elipses(data[i][x] + ' ' + x, 75)], markerColor:colors[n], type:'square'}})};
				let bar = Array(keys.length + 1).fill({});
				bar[0] = {table:{widths:data[i].bars.map(x => x + '%'), body:[colors.map(x => {return {text:'', fillColor:x, border:[false, false, true, false]}})]}, colSpan:keys.length + 1, margin:[-5,0,0,0]};
				result.push(bar);
			}
			this.pdfdata = {style:'table', table:{headerRows:2, widths:(new Array(keys.length + 1).fill('auto')), body:result, dontBreakRows:true, keepWithHeaderRows:true}};
			for (let col of this.pdfwidths) this.pdfdata.table.widths[col] = '*';
			this.pdfdata.heights = new Array(keys.length + 1).fill('auto');
			for (let b = 1; b < this.pdfdata.heights.length; b += 2) this.pdfdata.heights[b] = 10;
			this.pdfdata.layout = {paddingLeft:PaddingBar, paddingRight:PaddingBar, paddingTop:PaddingBar, paddingBottom:PaddingBar};
		}
		else if (!this.pdfdata||['goalsSummary','itemAnalysis','rowAnalysis'].includes(this.mode)) {
			let result = [], keys = this.pdfkeys != undefined ? this.pdfkeys : this.grid.columnDefs, data = this.grid.rowData;
			result.push(Array(keys.length).fill(''));
			result[0][0] = {text:this.sheetHeader, colSpan:keys.length, style:'tableTitle'};
			if (this.pdfbars) result.push(keys.map(x => ({text:toTitleCase(x.headerName), style:'tableHeader', fillColor:(this.pdfbars==x.field ? '#aaffaa' : '')})));
			else result.push(keys.map(x => ({text:toTitleCase(x.headerName), style:'tableHeader'})));
			for (let i = 0; i < data.length; i++) {
				if (data[i] == null) continue;
				result.push(Array(keys.length));
				for (let j = 0; j < keys.length; j++) {
					let val = data[i][keys[j].field];
					if (val == undefined) val = '';
					else if (!isNaN(val)) val = $.precision(val, 1e-2);
					if (this.mode == 'questionSummary' && keys[j].field == data[i].correct) _.last(result)[j] = {text:data[i][keys[j].field], fillColor: '#aaffaa'};
					else if (this.mode == 'distractors' && data[i].correct == $L.correct_value && ['correct','responses','PtBis'].includes(keys[j].field)) _.last(result)[j] = {text:data[i][keys[j].field], fillColor: '#aaffaa'};
					else _.last(result)[j] = val;
				}
				if (this.pdfbars) {
					let bar = Array(keys.length).fill({});
					bar[0] = {table:{widths:[(data[i][this.pdfbars] * 100) + '%'], body:[[{text:'', fillColor:'#aaffaa', border:[false, false, true, false]}]]}, colSpan:keys.length, margin:[-5,0,0,0]};
					result.push(bar); //'#80ceff'
				}
			}
			this.pdfdata = {style:'table', table:{headerRows:2, widths:(new Array(keys.length).fill('auto')), body:result, dontBreakRows:true, keepWithHeaderRows:true}};
			for (let col of this.pdfwidths) this.pdfdata.table.widths[col] = '*';
			if (this.pdfbars) {
				this.pdfdata.heights = new Array(keys.length).fill('auto');
				for (let b = 1; b < this.pdfdata.heights.length; b += 2) this.pdfdata.heights[b] = 10;
				this.pdfdata.layout = {paddingLeft:PaddingBar, paddingRight:PaddingBar, paddingTop:PaddingBar, paddingBottom:PaddingBar};
			}
		}
		if (this.cacheDownload) return this.pdfdata;
		let tmp = this.pdfdata;
		this.pdfdata = undefined;
		return tmp;
	}
	Scroll(e) {
		//console.log(e);
		//e.columnApi.autoSizeColumns();
	}
	SetSheet(keys, names) {
		this.sheet = keys;
		this.sheetNames = (arguments.length >= 2) ? names : keys.map(function(x){ return toTitleCase(x); });
	}
	Format() {
		let i = 0;
		for (let col of this.grid.columnDefs) {
			let type = this.ntypes[i++];
			if (type == undefined) {
				for (let row of this.grid.rowData) {
					if (!row || !row[col.field]) continue;
					else if (!_.isNumber(row[col.field])) {
						type = false;
						break;
					} else if (!Number.isInteger(row[col.field])) {
						type = 'float';
						break;
					} else type = 'int';
				}
			}
			if (type && type!='string') {
				if (!_.isArray(col.cellClass)) col.cellClass = [];
				if (!col.cellClass.includes('number-cell')) col.cellClass.push('number-cell');
				if (type!='percent' && this.filter) col.filter='agNumberColumnFilter';
			} else if (this.filter) {
				col.filter = 'agTextColumnFilter';
				col.filterParams = { caseSensitive:false };
			}
			if (type == 'float') col.valueFormatter = params=>_.isNumber(params.value)?params.value.toFixed(2):params.value;
		}
	}
	Nav(focus) {
		if (mainscope.tab == 'main') {
			if (focus) {
				for (let grid of mainscope.main.grids) grid.Nav(false);
				if (!this.enabled) this.load();
				this.enabled = true;
			} else if (this.enabled) {
				this.unload();
				this.enabled = false;
			} else {
				this.load();
				this.enabled = true;
			}
			if (this.enabled) mainscope.main.grids.push(this);
			else mainscope.main.grids = _.without(mainscope.main.grids, this);
		}
		mainscope.loadTab('main');
	}
}

class PImg {
	constructor(w, h) {
		this.w = w;
		this.h = h;
		this.canvas = document.createElement('canvas');
		this.canvas.width = w;
		this.canvas.height = h;
		this.ctx = this.canvas.getContext('2d');
		this.initial_rotation = Math.PI / -2;
	}
	drawLine(x1, y1, x2, y2, w, c) {
		this.ctx.beginPath();
		this.ctx.moveTo(x1, y1);
		this.ctx.lineTo(x2, y2);
		this.ctx.lineWidth = w;
		this.ctx.strokeStyle = c;
		this.ctx.stroke();
	}
	drawArc(x, y, r, a1, a2) {
		this.ctx.beginPath();
		this.ctx.arc(x, y, r, a1, a2);
		this.ctx.stroke();
	}
	drawSlice(x, y, r, a1, a2, c) {
		this.ctx.fillStyle = c;
		this.ctx.beginPath();
		this.ctx.moveTo(x, y);
		this.ctx.arc(x, y, r, a1, a2);
		this.ctx.closePath();
		this.ctx.fill();
	}
	drawRad(x, y, r, a, w, c) {
		this.drawLine(x, y, x + r * Math.cos(a), y + r * Math.sin(a), w, c);
	}
	calcFont(t, x, y, w, h, f) {
		let min = 1, max = h, s;
		while (min + 1 != max) {
			s = Math.floor((min + max) / 2);
			this.ctx.font = s + 'px ' + f;
			if (this.ctx.measureText(t).width > w) max = s;
			else min = s;
		}
	}
	drawPie(data) {
		this.colors = GetColors(data.length);
		this.ctx.clearRect(0, 0, this.w, this.h);
		let total = 0, color_index = 0, start_angle = this.initial_rotation;
		for (let d of data) total += d;
		for (let d of data) {
			let slice_angle = 2 * Math.PI * d / total;
			this.drawSlice(this.w/2, this.h/2, Math.min(this.w/2,this.h/2), start_angle, start_angle + slice_angle, this.colors[color_index % this.colors.length]);
			this.drawRad(this.w/2, this.h/2, Math.min(this.w/2,this.h/2), start_angle, this.w/50, '#ffffff');
			this.drawRad(this.w/2, this.h/2, Math.min(this.w/2,this.h/2), start_angle + slice_angle, this.w/50, '#ffffff');
			start_angle += slice_angle;
			++color_index;
		}
		return this.canvas.toDataURL();
	}
}
let pimg = new PImg(500, 500), pimg2 = new PImg(100, 100);;

class BarChart {
	constructor(args) {
		this.data = args.data;
		this.baseId = args.id;
		this.title = SetDefault(args.title, this.baseId);
		this.ylabel = args.ylabel;
		this.filename = SetDefault(args.filename, this.title);
		this.barThickness = SetDefault(args.barThickness, 75);
		this.groupSize = SetDefault(args.groupSize, 1);
		this.scroll = 28;
		this.config = {
			type:'horizontalBar',
			options: {
				elements: {rectangle:{borderWidth:2}},
				scales: {
					xAxes: [{position:'top', ticks:{beginAtZero:true, max:1}}],
					yAxes: [{ticks:{display:false}, maxBarThickness:27}]
				},
				responsive: true,
				maintainAspectRatio: false,
				title: {display:false,text:'Goal Averages'},
				tooltips: {yAlign:'center',
					callbacks: { title: function(tooltipItems, data) {
							return data.labels[tooltipItems[0].index];
						}
					}
				},
				legend: {display: false}
			}
		}
		this.bars = {
			getLength:this.getLength.bind(this),
			getItemAtIndex:this.getItemAtIndex.bind(this),
			items:new Array(Math.floor(this.data.datasets[0].data.length / this.groupSize))
		};
		for (let i=0; i<this.bars.getLength(); i++) this.bars.items[i] = {id:this.baseId+i, height:this.barThickness*this.groupSize};
		if (this.bars.items.length > 0) _.last(this.bars.items).height += this.barThickness * (this.data.datasets[0].data.length % this.groupSize);
	}
	getLength() {
		return this.bars.items.length;
	}
	getItemAtIndex(index) {
		if (index >= this.getLength()) return;
		_.defer(this.drawChart.bind(this), index);
		return this.bars.items[index];
	}
	drawChart(index) {
		if (!$('#'+this.baseId+'Scale').attr("loaded")) this.drawScale();
		let start = index * this.groupSize, end = (index + 1) * this.groupSize;
		if (index == this.getLength() - 1) end = this.data.datasets[0].data.length;
		let item = this.bars.items[index];
		if(!document.getElementById(item.id)) {
			setTimeout(this.drawChart.bind(this), 100, index);
			return;
		}
		if ($('#'+item.id).attr("loaded")) return;
		let config = $.extend(true, {}, this.config);
		config.data = {
			labels:this.data.labels.slice(start, end),
			datasets:[{
				label: 'Average',
				backgroundColor: 'rgba(0, 105, 170, 0.5)',
				borderColor: '#0069aa',
				borderWidth: 1,
				data:this.data.datasets[0].data.slice(start, end)
			}]
		};
		for (let i=1; i<this.data.datasets.length; i++) config.data.datasets.push({
			label:this.data.datasets[i].label,
			backgroundColor:this.data.datasets[i].backgroundColor,
			borderColor:this.data.datasets[i].borderColor,
			borderWidth:this.data.datasets[i].borderWidth,
			data:this.data.datasets[i].data.slice(start, end)
		});
		item.chart = new Chart(item.id, config);
		item.start = start;
		item.end = end;
		$('#'+item.id).attr("loaded", "true");
	}
	drawScale() {
		this.scale = new Chart(this.baseId+'Scale', $.extend(true, {}, this.config));
		$('#'+this.baseId+'Scale').attr("loaded", "true");
	}
	addDataset(dataset) {
		this.data.datasets.push(dataset);
		for (let item of this.bars.items) {
			if (item.chart) {
				item.chart.data.datasets[1] = {
					label:dataset.label,
					backgroundColor:dataset.backgroundColor,
					borderColor:dataset.borderColor,
					borderWidth:dataset.borderWidth,
					data:dataset.data.slice(item.start, item.end)
				};
				item.chart.update();
			}
		}
	}
	removeDataset() {
		this.data.datasets.pop();
		for (let item of this.bars.items) {
			if (item.chart) {
				item.chart.data.datasets = [item.chart.data.datasets[0]];
				item.chart.update();
			}
		}
	}
	update() {
		for (let item of this.bars.items) if (item.chart) item.chart.update();
	}
}

// Class for bar graph data
class BarGraph {
	constructor(title, keys_label, bars_label, obj) {
		this.title = title;
		this.keys_label = keys_label;
		this.bars_label = bars_label;
		this.Update(obj);
		this.size = 700;
	}
	Reset() {
		this.bars = [this.bars[0]];
	}
	Style(value) {
		let width = value * this.size;
		return { width:(width+"px"), color:(width < 30 ? 'black' : 'white') };
	}
	Update(obj) {
		this.keys = obj.keys;
		this.count = obj.count;
		this.bars = [obj.bar];
	}
}
// Chart.register({ id: 'clearChart',
// 	beforeDraw: function(chartInstance) {
// 		var ctx = chartInstance.chart.ctx;
// 		ctx.fillStyle = "white";
// 		ctx.fillRect(0, 0, chartInstance.chart.width, chartInstance.chart.height);
// 	}
// });
Chart.register(ChartDataLabels);
function Trunc(str) {
	let i = str.lastIndexOf(' ');
	if(i>27) return str.substring(0,25) + '...' + str.substring(i);
	return str;
}
function TruncLen(str, len) {
	if (str.length>len+2) return str.substring(0,len) + '...';
	return str;
}
function TruncRow(no, name, suffix) {
	if (!suffix) return `${no}.${TruncLen(name, 20)}`;
	return suffix.map(x=>`${no}.${TruncLen(name, 20)}${x}`);
}
function TruncSheet(str) {
	if (str.length <= 30) return str;
	return `${str.substring(0, 20)}...${str.substring(str.length-6)}`;
}
function ChartTooltipPercent(tooltipItem, data) {
	var label = data.datasets[tooltipItem.datasetIndex].label || '';
	if (label) label += ': ';
	label += (tooltipItem.xLabel * 100) + '%';
	return label;
}

// class for selecting combined reports
let theGS = null, forceGroup = true;
class GridSelector {
	constructor(grid) {
		this.group = [];
		this.prev = [];
		this.selection = [];
		this.newNode = null;
		this.grid = grid;
		this.qdpk1s = [];
		this.data = [];
		theGS = this;
	}
	degroup() {
		theGS.deselect(true);
	}
	deselect(clearGroup) {
		theGS.selection = [];
		if (clearGroup) theGS.group = [];
		theGS.update();
	}
	reselect() {
		theGS.selection = this.group;
		theGS.update();
	}
	update() {
		if (!theGS.grid || !theGS.grid.api) return;
		theGS.grid.api.forEachNode(node => theGS.selection.indexOf(node) >= 0 ? node.setSelected(true) : node.setSelected(false));
		theGS.grid.api.refreshCells();
		theGS.qdpk1s = [];
		theGS.data = [];
		for (let s of theGS.selection) {
			theGS.qdpk1s.push(s.data.gmpk1!=undefined ? s.data.qdpk1+"xxx"+s.data.gmpk1 : s.data.qdpk1);
			theGS.data.push({pk1:s.data.pk1, gmpk1:s.data.gmpk1, qdpk1:s.data.qdpk1, rrpk1s:s.data.rrpk1s, rapk1:s.data.rapk1, rrows:s.data.rrows, Name:s.data.Name, title:s.data.title});
		}
		selected_qdpk1s = theGS.qdpk1s;
		// Trigger Angular digest if mainscope exists (for backward compatibility)
		if (mainscope && mainscope.$apply) mainscope.$apply();
	}
	select(event) {
		theGS.prev = theGS.selection;
		theGS.selection = event.api.getSelectedNodes();
		if (theGS.selection.length == theGS.prev.length + 1) {
			theGS.newNode = theGS.findNode(theGS.selection, theGS.prev);
			if (theGS.group.indexOf(theGS.newNode) < 0) {
				if (!(mainscope.tab=='tests' && !forceGroup)) {
					theGS.group = [];
					theGS.selection = [];
				}
				theGS.grid.api.forEachNodeAfterFilter(node => {
					if (node.data.qtype == theGS.newNode.data.qtype && node.data.Name == theGS.newNode.data.Name) {
						theGS.group.push(node);
						if (theGS.selection.indexOf(node) < 0) theGS.selection.push(node);
					}
				});
			}
		} else if (theGS.selection.length == theGS.prev.length-1) {
			let removedNode = theGS.findNode(theGS.prev, theGS.selection);
			let removedGroup = theGS.selection.filter(x => x.data.qtype == removedNode.data.qtype && x.data.Name == removedNode.data.Name);
			if (!removedGroup.length) theGS.group = theGS.group.filter(x => !(x.data.qtype == removedNode.data.qtype && x.data.Name == removedNode.data.Name));
		}
		theGS.update();
	}
	inGroup(params) {
		return theGS.group.indexOf(params.node) >= 0;
	}
	findNode(searchAry, fromAry) {
		for (let s of searchAry) if (fromAry.indexOf(s) < 0) return s;
	}
}

function toTitleCase(str) {
	if (!str) return "";
	return str.replace(/\w\S*/g, function(txt){
		return txt.charAt(0).toUpperCase() + txt.substr(1);
	});
}

function elipses(str, len) {
	return (str.length > len) ? str.substring(0, len - 3) + '...' : str;
}

function breakWord(str) {
	return str.replace(/([\(\)\[\]\{\}\<\>\\\/\'\"\-\_\,\.\;\:\|])/g, '\u200B$1\u200B').replace(/([^\s\u200B]{5})/g, '$1\u200B');
}

function obj2pdf(doc, obj, mode, rubric) { // #pdf downlaod report
	if (obj.chart) {
		doc.content.push({style:'table',table:{widths:['*'],body:[[{text:obj.title, style:'tableTitle'}], [{image:obj.chart.canvas.toDataURL(), fit:[500, 500]}]]}});
		return;
	}
	doc.content.push(obj.pdfdata);
}

let prevPadding = [], enablePadding = false;
function PaddingBar(i, node) {
	if (i == 0) enablePadding = false;
	if (prevPadding[0]==prevPadding[1] && prevPadding[0]==prevPadding[2] && prevPadding[0]>1) enablePadding = prevPadding[0]%2==0;
	prevPadding.push(i);
	if (prevPadding.length > 3) prevPadding.shift();
	return enablePadding ? 0 : 4;
}

let prevPadding2 = [], enablePadding2 = false;
function PaddingBar2(i, node) {
	if (i == 0) enablePadding2 = false;
	if (prevPadding2[0]==prevPadding2[1] && prevPadding2[0]==prevPadding2[2] && prevPadding2[0]>1) enablePadding2 = prevPadding2[0] % (scoreQs[0].choicesText.length + 1) == 1;
	prevPadding2.push(i);
	if (prevPadding2.length > 3) prevPadding2.shift();
	return enablePadding2 ? 0 : 4;
}

function MakeSummaryPdf(format, colspan) { // # pdf summary
	summaryPdf = {style:'table',table:{widths:(new Array(format[0].length).fill('*')),body:[[{text:$L.t_summary_statistics.title, colSpan:3, style:'tableTitle'},'','']]}};
	for (let row of format) {
		let newrow = [];
		for (let cell of row) {
			if (cell == -1) newrow.push({text:'', fillColor:'#7f7f7f'});
			else if (cell == -2) {
				newrow[newrow.length - 1].colSpan = 2;
				newrow.push({});
			}
			else newrow.push({table:{widths:['*','auto'],body:[[summaryDownload[cell].Description,{text:summaryDownload[cell].Value,alignment:'right'}]]},layout:'noBorders'});
		}
		summaryPdf.table.body.push(newrow);
	}
}

function pbStyle(params) {
	if (params.value > 0) return {color:(params.data.correct == $L.correct_value ? 'green' : 'red')};
	else if (params.value < 0) return {color:(params.data.correct == $L.correct_value ? 'red' : 'green')};
}
function pbStyle2(params) {
	if (params.value >= 0.15) return {color:'green'};
	else if (params.value < 0) return {color:'red'};
}

// add directives to angular app
function EacAppSetup(app) {
	// Generic Replace Filter
	app.filter('strReplace', function () {
		return function (input, from, to) {
			input = input || '';
			from = from || '';
			to = to || '';
			return input.replace(new RegExp(from, 'g'), to);
		};
	})
	// Escape / unescape html special characters
	.filter('escape', function () {
		return function (input, mode) {
			if (mode == undefined) mode = true;
			return mode ? _.escape(input) : _.unescape(input);
		};
	})
	// Container Template
	.directive('eacBox', function(){
		return {
			restrict:'E',
			transclude: {'tool': '?eacTool', 'ltool':'?eacLtool'},
			scope: { header: '@', height: '@', width: '@' },
			controller: function($scope){
				$scope.hide = false;
				$scope.height = $scope.height || '100%';
				$scope.width = $scope.width || '100%';
			},
			templateUrl:'EacBox.html?v=6.2.282'
		};
	})
	// Grid Template
	.directive('eacGrid', ['$timeout', function($timeout){
		return {
			restrict:'E',
			transclude: { 'tool':'?eacTool', 'ltool':'?eacLtool' },
			scope: { name:'=', height:'@', width:'@', showDownload:'=?download', showPop:'=?pop', jumpVar:'=?jump', cjumpVar:'=?coljump' },
			link: function($scope, element) {
				$scope.$L = $L;
				$scope.theme = "ag-theme-quartz";
				$scope.jumpVar = $scope.jumpVar || false;
				$scope.cjumpVar = $scope.cjumpVar || false;
				$scope.showJump = true;
				$scope.questions = [];
				if (_.isBoolean($scope.jumpVar) && $scope.jumpVar && $scope.name && $scope.name.grid && $scope.name.grid.rowData!=undefined) $scope.questions = Array.apply(null, {length: $scope.name.grid.rowData.length}).map(Function.call, Number);
				else if (_.isString($scope.jumpVar) && $scope.jumpVar && $scope.name && $scope.name.grid && $scope.name.grid.rowData!=undefined) {
					for (let i=0; i<$scope.name.grid.rowData.length; i++) if (_.isNumber($scope.name.grid.rowData[i][$scope.jumpVar])) $scope.questions.push(i);
				}
				else if ($scope.cjumpVar && $scope.name && $scope.name.grid && $scope.name.grid.rowData!=undefined) $scope.questions = scoreQs.map(x => x.position.toString());
				else $scope.showJump = false;
				if ($scope.showDownload == undefined) $scope.showDownload = true;
				if ($scope.showPop == undefined) $scope.showPop = true;
				// Initialize grid using vanilla JS after DOM is ready
				// Use a function that finds the grid container directly from the element
				function initGridWhenReady() {
					if (!$scope.name) {
						$timeout(initGridWhenReady, 50);
						return;
					}
					// Find the grid container div directly from the element
					// It should have class 'ag-theme-quartz' and id ending in '-grid'
					const gridDiv = element[0].querySelector('.ag-theme-quartz[id$="-grid"]') || 
					                element[0].querySelector('.ag-theme-quartz');
					
					if (!gridDiv) {
						$timeout(initGridWhenReady, 50);
						return;
					}
					
					// Check if grid was previously initialized but DOM was removed (ng-if scenario)
					// If the grid API exists but the DOM element doesn't have ag-grid structure, re-initialize
					if ($scope.name.grid.api && !gridDiv.querySelector('.ag-root-wrapper')) {
						// Grid was destroyed by ng-if, clear API references to force re-initialization
						$scope.name.grid.api = null;
						$scope.name.gridInstance = null;
						$scope.name.grid.columnApi = null;
					}
					
					// Generate an ID if one doesn't exist or is empty
					if (!$scope.name.id || $scope.name.id === '') {
						// Generate a unique ID based on the grid's title or mode
						const baseName = ($scope.name.mode || $scope.name.title || 'grid').replace(/\s+/g, '-').toLowerCase();
						const uniqueId = 'grid-' + baseName + '-' + Math.random().toString(36).substr(2, 9);
						$scope.name.id = uniqueId;
						gridDiv.id = uniqueId + '-grid';
					} else {
						// Ensure the grid div has the correct ID
						gridDiv.id = $scope.name.id + '-grid';
					}
					
					// Wait for agGrid to be available
					if (typeof agGrid === 'undefined' || !agGrid.createGrid) {
						console.warn('agGrid not yet loaded, retrying grid initialization...');
						setTimeout(function() {
							$scope.name.InitGrid(gridDiv);
						}, 100);
					} else {
						// Pass the DOM element directly instead of ID
						$scope.name.InitGrid(gridDiv);
					}
				}
				$timeout(initGridWhenReady, 0);
				$scope.download = function(type) { // #pdf downlaod single
					if (type == '.doc') {
						let doc = StartDoc();
						doc += $scope.name.GetDoc();
						doc += '</body>\n</html>';
						saveAs(new Blob([doc], {type:'text/plain;charset=utf-8'}), stripFilename($scope.name.sheetHeader, type));
					} else if (type == '.docx') {
						let doc = StartDoc(true);
						doc += $scope.name.GetDoc();
						doc += '</body>\n</html>';
						saveAs(htmlDocx.asBlob(doc, {orientation:settings.orientation}), stripFilename($scope.name.sheetHeader, type));
					}else if (type == '.pdf') {
						let doc = {
							pageOrientation:settings.orientation,
							content:[
								{text: n_title[0], style: 'header'},
								{text: n_title[1], style: 'subheader'},
							], styles: {
								header: { fontSize:18, bold:true, alignment:'center' },
								subheader: { fontSize:16, alignment:'center', margin:[0,0,0,10] },
								table: { margin:[0, 10, 0, 10] },
								tableHeader: { bold:true, fontSize:13.5},
								tableTitle:{bold:true, fontSize:15, fillColor:'#80ceff', alignment:'center'}
							},
						};
						if (differed) doc.content.push({text:$L.msg.test_differed});
						doc.content.push($scope.name.GetPdf());
						pdfMake.createPdf(doc).download(stripFilename($scope.name.sheetHeader, type));
					} else {
						let wb = XLSX.utils.book_new();
						$scope.name.GetSheet(wb, true);
						XLSX.writeFile(wb, stripFilename($scope.name.sheetHeader, type));
					}
				};
				$scope.jump = { num:1,
					change:function() {
						if ($scope.cjumpVar) $scope.name.grid.api.ensureColumnVisible($scope.questions[$scope.jump.num-1]);
						else $scope.name.grid.api.ensureIndexVisible($scope.questions[$scope.jump.num-1], 'top');
					}
				};
				$scope.pop = function() {
					$scope.nw = window.open('EacPop.html', $scope.name.title, `width=${screen.width/2},height=${screen.height/2}`);
					$scope.nw.scope = $scope;
				};
				$scope.undo = function() {
					if ($scope.name.grid.api) {
						$scope.name.grid.api.setColumnVisible($scope.name.alert.field, true);
					}
					$scope.name.hidden.pop();
					$scope.name.alert = false;
				};
				$scope.reset = function() {
					if ($scope.name.grid.api) {
						$scope.name.hidden.forEach(field => {
							$scope.name.grid.api.setColumnVisible(field, true);
						});
						for (let i = 0; i < $scope.name.keys.length; i++) {
							$scope.name.grid.api.moveColumn($scope.name.keys[i], i);
						}
					}
					$scope.name.hidden = [];
					$scope.name.alert = false;
					$scope.name.AutoSize();
				};
			},
			templateUrl:'EacGrid.html?v=6.2.282'
		};
	}])
	.directive('eacGridNav', function(){
		return {
			restrict:'E',
			scope: { name:'=', label:'@' },
			link: function($scope) {
				$scope.CheckTab = function() {
					return mainscope.tab != 'main';
				};
			},
			template:`
				<div layout class="eac-grid-nav">
					<md-button class="nav-add" ng-click="name.Nav(false)" aria-label="{{label}}">
						<md-icon ng-if="!name.enabled">add</md-icon>
						<md-icon ng-if="name.enabled">remove</md-icon>
					</md-button>
					<md-button flex ng-click="name.Nav(true)" class="nav-button" ng-class="{highlight:name.enabled}" ng-bind="label" aria-label="{{label}}"></md-button>
				</div>`
		};
	})
	// Chart Template
	.directive('eacChart', function(){
		return {
			restrict:'E',
			transclude: { 'tool':'?eacTool', 'ltool':'?eacLtool' },
			scope:{ name:'=?', height:'@', obj:'@', index:'@', showPop:'=?pop', menu:'=?', tt:'=?tooltip' },
			link: function($scope) {
				$scope.$L = $L;
				if ($scope.showPop == undefined) $scope.showPop = true;
				if ($scope.tt == undefined) $scope.tt = true;
				if ($scope.index) $scope.name = mainscope[$scope.obj][$scope.index];
				else if ($scope.obj) $scope.name = mainscope[$scope.obj];
				$scope.ttt = function() {
					$scope.tt = !$scope.tt;
					$scope.name.chart.config.options.plugins.tooltip.enabled = $scope.tt;
					$scope.name.chart.update();
				};
				$scope.DownloadImg = function(ext){
					if (!$scope.name.chart||!$scope.name.chart.ctx) return;
					$scope.name.chart.canvas.toBlob(function(blob) {
						saveAs(blob, $scope.name.filename+ext);
					});
				};
				$scope.DownloadPdf = function(){
					if (!$scope.name.chart||!$scope.name.chart.ctx) return;
					pdfMake.createPdf({
						pageOrientation:settings.orientation,
						content:[
							{text:$scope.name.title, style:'header'},
							{image:$scope.name.chart.canvas.toDataURL(), fit:[500, 500]}
						], styles: {
							header:{fontSize:18, bold:true, alignment:'center'}
						}
					}).download($scope.name.filename+'.pdf');
				};
				$scope.pop = function() {
					$scope.nw = window.open('EacPop.html', $scope.name.title, `width=${screen.width/2},height=${screen.height/2}`);
					$scope.nw.root = window;
					$scope.nw.chart = {
						id:'pop_'+$scope.name.id,
						pid:'pop_'+$scope.name.pid,
						title:$scope.name.title,
						filename:$scope.name.filename,
						config:$scope.name.config
					};
				};
				$scope.Check = function($scope) {
					if (!$scope.name || !document.getElementById($scope.name.id)) {
						setTimeout($scope.Check, 100, $scope);
						return;
					}
					$scope.name.init($scope.name.id, $scope.name.pid);
				};
				_.defer($scope.Check, $scope);
			},
			templateUrl:'EacChart.html?v=6.2.282'
		};
	})
	// Test Template
	.directive('eacTest', function(){
		return {
			restrict:'E',
			scope: { name: '=', height: '@', width: '@' },
			controller: function($scope, $sce){
				$scope.$L = $L;
				$scope.jump = { num:1,
					change:function() {
						let originalScroll=document.documentElement.scrollTop;
						if ($scope.jump.num != null) document.getElementById($scope.jump.num).scrollIntoView();
						document.documentElement.scrollTop = originalScroll;
					}
				};
				$scope.Table = function(mode) {
					let s=mode=='docx'?{p:'.0pt',a:'width=40',b:'width=20'}:{p:'px',a:'',b:''}, node=`<table style="width:100%; border:none; mso-padding-left-alt:5pt; padding-right:5px; mso-padding-right-alt:5pt; padding-left:5px;">`;
					$scope.name.questions.forEach((x,i)=>{
						/*node += `<tr id="${x.id}"><td style="width:40px;">${i+1}.</td><td colspan="2">${x.text}<br />${x.outcomes}</td></tr>`;
						if (x.kind_id==6) {
							let correct = x.answers[1].correct;
							node += `<tr><td style="color:${correct?'green':'red'};">${correct?'&#x2713;':'&#x2717;'}</td><td colspan="2" style="text-decoration:underline; ${correct?'color:green;':''}">${x.answers[1].choice}</td></tr>`;
							if (!correct) node += `<tr><td></td><td colspan="2" style="color:green;">${x.answers[0].choice}</td></tr>`;
						} else if (x.kind_id==7 || x.kind_id==16) {
							node += `<tr><td></td><td colspan="2">${x.answers[0].choice}</td></tr>`;
						} else {
							x.answers.forEach((y,j)=>{
								let mark = y.chosen&&y.correct?'v':' ';
								if ((y.chosen&&!y.correct)||(y.correct&&!y.chosen)) mark = 'x';
								node += `<tr><td style="${mark=='v'?'color:green;':(mark=='x'?'color:red;':'')}">${mark=='v'?'&#x2713;':(mark=='x'?'&#x2717;':'')}</td><td style="width:20px; ${y.chosen?'border:1px solid black;':''}">${Num2abc(j)}.</td><td style="${y.correct?'color:green;':''}">${y.choice}</td></tr>`;
							});
						}
						node += `<tr><td colspan="3">&nbsp;</td></tr>`;*/
						// mso-table-layout-alt:fixed;
						node += `<tr id="${x.id}"><td style="page-break-inside: avoid;"><table style="width:100%; border:none; mso-padding-left-alt:5pt; mso-padding-right-alt:5pt; padding-left:5px; padding-right:5px; mso-table-layout-alt:fixed;"><tr><td ${s.a} style="width:40${s.p};">${i+1}.</td><td colspan="2">${_.escape(x.text)}<br />${_.escape(x.outcomes)}</td></tr>`;
						if (x.kind_id==6) {
							let correct = x.answers[1].correct;
							node += `<tr><td style="color:${correct?'green':'red'};">${correct?'&#x2713;':'&#x2717;'}</td><td colspan="2" style="text-decoration:underline; ${correct?'color:green;':''}">${_.escape(x.answers[1].choice)}</td></tr>`;
							if (!correct) node += `<tr><td></td><td colspan="2" style="color:green;">${_.escape(x.answers[0].choice)}</td></tr>`;
						} else if (x.kind_id==7 || x.kind_id==16) {
							node += `<tr><td></td><td colspan="2">${_.escape(x.answers[0].choice)}</td></tr>`;
						} else {
							x.answers.forEach((y,j)=>{
								let mark = y.chosen&&y.correct?'v':' ';
								if ((y.chosen&&!y.correct)||(y.correct&&!y.chosen)) mark = 'x';
								node += `<tr><td style="${mark=='v'?'color:green;':(mark=='x'?'color:red;':'')}">${mark=='v'?'&#x2713;':(mark=='x'?'&#x2717;':'')}</td><td ${s.b} style="width:20${s.p}; ${y.chosen?'border:1px solid black;':''}">${Num2abc(j)}.</td><td style="${y.correct?'color:green;':''}">${_.escape(y.choice)}</td></tr>`;
							});
						}
						node += `</table></td></tr><tr><td>&nbsp;</td></tr>`;
					});
					node += `</table>`;
					return mode=='html' ? $sce.trustAsHtml(node) : node;
				}
				$scope.download = function(type) { // #pdf downlaod single
					if (type == '.docx') {
						let doc = StartDoc(true);
						doc += `<h2 style="font-family:\'Calibri\', sans-serif;">${$scope.name.title}</h2>${$scope.Table('docx')}</body></html>`;
						saveAs(htmlDocx.asBlob(doc, {orientation:settings.orientation}), $scope.name.title+type);
					} else if (type == '.pdf') {
						let doc = {
							pageOrientation:settings.orientation,
							content:[
								{text: n_title[0], style: 'header'},
								{text: n_title[1], style: 'subheader'},
							], styles: {
								header: { fontSize:18, bold:true, alignment:'center' },
								subheader: { fontSize:16, alignment:'center', margin:[0,0,0,10] },
								table: { margin:[0, 10, 0, 10] },
								tableHeader: { bold:true, fontSize:13.5},
								tableTitle:{bold:true, fontSize:15, fillColor:'#80ceff', alignment:'center'}
							}, images: {
								check:location.origin+EAC.root+'/Images/check.png',
								cross:location.origin+EAC.root+'/Images/cross.png'
							}
						};
						if (differed)doc.content.push({text:$L.msg.test_differed});
						doc.content.push({text: $scope.name.title, style: 'subheader'});
						let rows = [];
						$scope.name.questions.forEach((x,i)=>{
							let choices = [];
							choices.push([`${i+1}.`, {text:`${x.text}\n${x.outcomes}`, colSpan:2}, {}]);
							if (x.kind_id==6) {
								let correct = x.answers[1].correct;
								choices.push([{image:correct?'check':'cross'}, {text:x.answers[1].choice, decoration:'underline', color:correct?'green':'black', colSpan:2}, {}]);
								if (!correct) choices.push(['', {text:x.answers[0].choice, color:'green', colSpan:2}, {}]);
							} else if (x.kind_id==7 || x.kind_id==16) {
								choices.push([{}, {text:x.answers[0].choice, colSpan:2}, {}]);
							} else {
								x.answers.forEach((y,j)=>{
									let mark=y.chosen&&y.correct?{image:'check'}:{};
									if ((y.chosen&&!y.correct)||(y.correct&&!y.chosen)) mark = {image:'cross'};
									choices.push([mark, {text:`${Num2abc(j)}.`, border:y.chosen?[true,true,true,true]:[false,false,false,false]}, {text:y.choice, color:y.correct?'green':'black'}]);
								});
							}
							rows.push([{table:{widths:[40,20,'*'], body:choices}, layout:{defaultBorder:false}}], ['\n']);
						});
						doc.content.push({table:{widths:['*'], dontBreakRows:true, body:rows}, layout:{defaultBorder:false}});
						pdfMake.createPdf(doc).download($scope.name.title+type);
					}
				};
			},
			templateUrl:'EacTest.html?v=6.2.282'
		};
	})
	.directive('inputClear', function(){
		return {
			restrict: 'A',
			compile: function (element, attrs) {
				var color = attrs.inputClear;
				var style = color ? "color:" + color + ";" : "";
				var action = attrs.ngModel + " = ''";
				element.after(
					`<md-button class="animate-show md-icon-button md-accent" ng-show="${attrs.ngModel}" ng-click="${action}" style="position: absolute; top: -40px; right:0px; margin: 13px 0px;">
						<md-icon style="${style}">backspace</md-icon>
					</md-button>`);
			}
		};
	})
	.directive('eacList', function(){
		return {
			restrict:'E',
			transclude: { 'tool':'?eacTool', 'ltool':'?eacLtool' },
			scope:{obj:'=name', height:'@', width:'@'},
			link:function($scope) {
				$scope.search='';
				$scope.$L = $L;
			},
			templateUrl:'EacList.html?v=6.2.282'
		};
	})
	/*.directive('clearable', function(){ // doesn't work
		var directive = {
			restrict: 'A',
			require: 'ngModel',
			link: link
		};
		return directive;

		function link(scope, elem, attrs, ctrl) {
			elem.addClass('clearable');
			elem.bind('input', () => { elem[toggleClass(elem.val())]('x'); });
			elem.on('mousemove', function(e) {
				if(elem.hasClass('x')) {
					elem[toggleClass(this.offsetWidth - 25 < e.clientX - this.getBoundingClientRect().left)]('onX');
				}
			});
			elem.on('click', function(e) {
				if(elem.hasClass('onX')) {
					elem.removeClass('x onX').val(undefined);
					ctrl.$setViewValue(undefined);
					ctrl.$render();
					scope.$digest();
				}
			});

			function toggleClass(v) {
				return v ? 'addClass' : 'removeClass';
			}
		}
	})*/
	.config(function($mdDateLocaleProvider) {
		$mdDateLocaleProvider.months = $L.calendar.months;
		$mdDateLocaleProvider.shortMonths = $L.calendar.short_months;
		$mdDateLocaleProvider.days = $L.calendar.days;
		$mdDateLocaleProvider.shortDays = $L.calendar.short_days;
		$mdDateLocaleProvider.firstDayOfWeek = $L.calendar.first_day_of_week;
	})
	.config(function($mdThemingProvider) {
		$mdThemingProvider.definePalette('eacPalette', {
			'50':'0069aa', '100':'8fadbf', '200':'0069aa', '300':'0069aa',
			'400':'0069aa', '500':'0069aa', '600':'0069aa', '700':'0069aa',
			'800':'0069aa', '900':'0069aa', 'A100':'e17009', 'A200':'e17009',
			'A400':'e17009', 'A700':'e17009', 'contrastDefaultColor':'light',
			'contrastDarkColors':['50', '100', '200', '300', '400', 'A100'],
			'contrastLightColors':undefined //set if default is dark
		});
		$mdThemingProvider.theme('default')
			.primaryPalette('eacPalette')
			.accentPalette('eacPalette')
	})
	.factory('$exceptionHandler', ['$log', function($log) {
		return function myExceptionHandler(exception, cause) {
			window.onerror(exception);
			$log.warn(exception, cause);
		};
	}])
}

class GoalSelector {
	constructor(goals, home) {
		this.check = 0;
		this.filter = '';
		this.filtered = '';
		this.goalCount = 0;
		this.home = SetDefault(home, false);
		this.selected = [];
		this.setTypes = [];
		this.showUnavailable = false;
		
		let setType = {};
		for (let goal of goals) {
			if (goal.pk1 == 0) continue;
			if (!setType[goal.dsname]) setType[goal.dsname] = { label:_.unescape(goal.dsname), goalSet:{}, pk1:goal.typepk1 };
			let st = setType[goal.dsname].goalSet;
			if (!st[goal.myset]) st[goal.myset] = { label:_.unescape(goal.myset), category:{}, pk1:goal.setpk1 };
			let gs = st[goal.myset].category;
			if (!gs[goal.realcat]) gs[goal.realcat] = { label:_.unescape(goal.realcat), goal:{}, pk1:goal.catpk1 };
			let ct = gs[goal.realcat].goal;
			if (!ct[goal.category]) {
				let avail = goal.st_status=='A' && goal.sd_visible=='Y' && goal.alignable_ind=='Y';
				ct[goal.category] = {label:_.unescape(goal.category),data:goal,show:true,check:avail?0:3,search:_.unescape(goal.unique_id).toLowerCase()+'\n'+_.unescape(goal.desc).toLowerCase()+'\n'+_.unescape(goal.realcat).toLowerCase(),filter:true,available:avail};
			}
		}
		
		for (let st of Object.keys(setType).sort().map(x => setType[x])) {
			let goalSets = [], totalSet = 0;
			for (let gs of Object.keys(st.goalSet).sort().map(x => st.goalSet[x])) {
				let categories = [], totalCat = 0;
				for (let ct of Object.keys(gs.category).sort().map(x => gs.category[x])) {
					let goals = Object.keys(ct.goal).sort().map(x => ct.goal[x]);
					let gl = goals.filter(x => x.available).length;
					categories.push({show:false, selected:0, total:gl, check:gl>0?0:3, goals:goals, label:ct.label, search:ct.label.toLowerCase(), filter:true, pk1:ct.pk1});
					totalCat += gl;
				}
				goalSets.push({show:false, selected:0, total:totalCat, check:totalCat>0?0:3, categories:categories, label:gs.label, search:gs.label.toLowerCase(), filter:true, pk1:gs.pk1});
				totalSet += totalCat;
			}
			this.setTypes.push({show:false, selected:0, total:totalSet, check:totalSet>0?0:3, goalSets:goalSets, label:st.label, search:st.label.toLowerCase(), filter:true, pk1:st.pk1});
			this.goalCount += totalSet;
		}
		this.title = this.total();
	}
	*[Symbol.iterator]() {
		for (let st of this.setTypes) {
			yield {node:st, level:3};
			for (let gs of st.goalSets) {
				yield {node:gs, level:2};
				for (let ct of gs.categories) {
					yield {node:ct, level:1};
					for (let g of ct.goals) {
						yield {node:g, level:0};
					}
				}
			}
		}
	}
	changeAll(value) {
		if (value == this.check) {
			for (let el of this) el.node.show = el.level>0 ? value==1 : true;
		} else {
			for (let st of this.setTypes) this.changeType(st, value);
		}
		this.update();
	}
	changeType(setType, value) {
		if (setType.check==3) return;
		let desired = setType.check>0 ? 0 : 1;
		if (value != undefined) desired = value;
		for (let gs of setType.goalSets) this.changeSet(gs, desired);
		if (value == undefined) this.update();
	}
	changeSet(goalSet, value) {
		if (goalSet.check==3) return;
		let desired = goalSet.check>0 ? 0 : 1;
		if (value != undefined) desired = value;
		for (let cat of goalSet.categories) this.changeCat(cat, desired);
		if (value == undefined) this.update();
	}
	changeCat(category, value) {
		if (category.check==3) return;
		let desired = category.check>0 ? 0 : 1;
		if (value != undefined) desired = value;
		for (let goal of category.goals) this.changeGoal(goal, desired);
		if (value == undefined) this.update();
	}
	changeGoal(goal, value) {
		if (!goal.available) return;
		if (value == undefined) {
			goal.check = goal.check ? 0 : 1;
			this.update();
		} else goal.check = value;
	}
	parts() {
		let res = [], ga = [], maxl = CHUNK_SIZE;
		for (let st of this.setTypes) {
			for (let gs of st.goalSets) {
				for (let ct of gs.categories) {
					for (let g of ct.goals) {
						if (g.check == 1) ga.push(g.data.pk1.substring(1));
					}
				}
			}
		}
		maxl = Math.max(Math.ceil(ga.length/MAX_QUERIES), CHUNK_SIZE);
		arrayChunk(ga,maxl).forEach(x=>res.push(`g.pk1 in (${x.join(',')})`));
		return res;
	}
	search(filter) {
		if (filter != undefined) this.filter = filter;
		this.filtered = this.filter.toLowerCase();
		let results = 0, show = this.filter ? false : true;
		for (let el of this) el.node.filter = show;
		if (show) return;
		for (let st of this.setTypes) {
			if (results > 30) return;
			for (let gs of st.goalSets) {
				if (results > 30) break;
				for (let ct of gs.categories) {
					if (results > 30) break;
					for (let g of ct.goals) {
						if (g.search.includes(this.filtered)) {
							ct.filter = true;
							g.filter = true;
							++results;
						}
					}
					if (ct.filter) gs.filter = true;
				}
				if (gs.filter) st.filter = true;
			}
		}
	}
	show(parent, child) {
		if (child!=undefined&&child.check==3&&!this.showUnavailable) return false;
		return parent.show || this.filter;
	}
	total() {
		return this.home ? ' '+LangArg($L.selected_format, this.selected.length, this.goalCount) : '';
	}
	update() {
		this.selected = [];
		for (let st of this.setTypes) {
			if (!st.total) continue;
			st.selected = 0;
			for (let gs of st.goalSets) {
				if (!gs.total) continue;
				gs.selected = 0;
				for (let ct of gs.categories) {
					if (!ct.total) continue;
					ct.selected = 0;
					for (let g of ct.goals) {
						if (!g.available) continue;
						if (g.check) {
							++ct.selected;
							this.selected.push(g);
						}
					}
					if (ct.selected == ct.total) ct.check = 1;
					else ct.check = ct.selected==0 ? 0 : 2;
					gs.selected += ct.selected;
				}
				if (gs.selected == gs.total) gs.check = 1;
				else gs.check = gs.selected==0 ? 0 : 2;
				st.selected += gs.selected;
			}
			if (st.selected == st.total) st.check = 1;
			else st.check = st.selected==0 ? 0 : 2;
		}
		if (this.selected.length == this.goalCount) this.check = 1;
		else this.check = this.selected.length==0 ? 0 : 2;
		
		if (this.home) {
			this.title = this.total();
		} else {
			mainscope.OM.outcomes = this.selected;
			mainscope.OM.ok = mainscope.OM.outcomes.length != 0 && mainscope.OM.questions.length != 0;
		}
	}
	reset() {
		this.check = 0;
		this.filter = '';
		this.selected = [];
		this.title = this.total();
		this.showUnavailable = false;
		for (let el of this) {
			if (el.node.check != 3) el.node.check = 0;
			el.node.filter = true;
			if (el.level > 0) el.node.selected = 0;
			el.node.show = el.level==0;
		}
	}
}

class OutGroup {
	constructor(set) {
		this.set = set || '';
		this.show = false;
		this.children = [];
		this.selected = 0;
		this.s = this.set.toLowerCase();
	}
	get label() {
		return '('+this.selected+' / '+this.children.length+') '+this.set;
	}
	get checked() {
		return this.selected == this.children.length;
	}
	get indeterminate() {
		return this.selected > 0 && this.selected < this.children.length;
	}
	reset() {
		this.change(false);
		this.show = false;
	}
	change(value) {
		if (value == undefined) value = (this.selected == 0);
		for (let child of this.children) child.change(value);
	}
	filter(search) {
		let f = search.toLowerCase();
		if (this.s.includes(f)) {
			if (this.s==f) this.show = true;
			for (let child of this.children) child.show = true;
			return true;
		}
		let found = false;
		for (let child of this.children) {
			if (child.l.includes(f) || child.d.includes(f)) {
				child.show = true;
				found = true;
			}
			else child.show = false;
		}
		this.show = found;
		return found;
	}
	add(cat) {
		this.children.push(new OutRow(cat, this));
	}
}
class OutRow {
	constructor(cat, group) {
		this.label = cat.category || '';
		this.desc = cat.desc || '';
		this.data = cat;
		this.selected = false;
		this.group = group;
		this.l = this.label.toLowerCase();
		this.d = this.desc.toLowerCase();
		this.show = true;
	}
	change(value) {
		if (value == this.selected) return;
		else if (value != undefined) this.selected = value;
		this.group.selected += this.selected ? 1 : -1;
		if (this.selected) mainscope.OM.outcomes.push(this);
		else mainscope.OM.outcomes.splice(mainscope.OM.outcomes.indexOf(this), 1);
		mainscope.OM.ok = mainscope.OM.outcomes.length != 0 && mainscope.OM.questions.length != 0;
	}
}

class ntuple {
	constructor(qpk1, cpk1, category, catpk1) {
		this.qpk1 = qpk1 || "";
		this.cpk1 = cpk1 || "";
		this.category = category || "";
		if (catpk1 < 0) this.category = category.split('- ')[0];
		this.catpk1 = catpk1 || "";
		this.position = 0;
		this.equals = this.Equals;
	}
	Equals(other) {
		return this.qpk1 === other.qpk1 && this.catpk1 === other.catpk1;
	}
}
class nsout {
	constructor(outcome, question) {
		this.Qs = [question.No - 1];
		this.cat = outcome.unique_id;
		this.uid = outcome.unique_id;
		this.catPk1 = outcome.pk1;
		this.cpk1 = [question.cpk1];
		this.equals = this.Equals;
		this.qpk1 = [question.qpk1];
		this.score = SetDefault(question.score, 0);
		this.scored = SetDefault(question.scored, 0);
		this.position = [question.No.toString()];
	}
	Equals(other) {
		return this.qpk1 === other.qpk1 && this.catPk1 === other.catPk1;
	}
}
function nRemove(array, value) {
	if (!array) return [];
	var index = array.indexOf(value);
	if (index > -1) {
	  array.splice(index, 1);
	}
	return array;
}
function nRemoveSout(category, question) {
	for (let i = 0; i < souts.length; i++) {
		if (souts[i].cat != category) continue;
		souts[i].Qs = nRemove(souts[i].Qs, question.No - 1);
		souts[i].cpk1 = nRemove(souts[i].cpk1, question.cpk1);
		souts[i].qpk1 = nRemove(souts[i].qpk1, question.qpk1);
		souts[i].position = nRemove(souts[i].position, question.No.toString());
		if (question.score) souts[i].score -= question.score;
		if (question.scored) souts[i].scored -= question.scored;
	}
}

function setIntervalX(callback, delay, repetitions, obj) {
	let x = 0;
	if (obj) callback = _.bind(callback, obj);
	let intervalID = setInterval(function () {
	   if (++x > repetitions) clearInterval(intervalID);
	   if (callback()) clearInterval(intervalID);
	}, delay);
	return intervalID;
}

function AssignKeys(target, source, keys) {
	for (let key of keys) target[key] = source[key];
	return target;
}

function SetDefault(args) {
	for (let arg of arguments) if (arg != undefined) return arg;
}

function fetchProgram(triple, dbatch) {
	let program = false;
	//var program = ' -- ';
	for (var p = 0; p < progs.length && !program; p++) {
		if (!progs[p].domain_pk1) continue;
		var codes = progs[p].domain_pk1;
		if (codes.length) {
			var vcodes = codes.split('_');
			for (var v = 0; v < vcodes.length && !program; v++) {
				if (vcodes[v].indexOf(triple) > -1) program = progs[p].name;
			}
		}
	}
	if (triple === dbatch || !program) {
		program = ' -- ';
	}
	return program;
}

function GetColors(n, a = 1, reverse, hex) {
	//let colors = [`rgba(0, 105, 170, ${a})`, `rgba(86, 101, 180, ${a})`, `rgba(138, 93, 178, ${a})`, `rgba(181, 81, 162, ${a})`, `rgba(214, 70, 136, ${a})`, `rgba(233, 70, 102, ${a})`, `rgba(237, 87, 63, ${a})`, `rgba(225, 112, 9, ${a})`];
	let colors = hex ? ['#da5626', '#f6893d', '#febc38', '#ca3541', '#27647b', '#849fad', '#aecbc9', '#d8c6b4', '#57575f', '#152329'] : [`rgba(218, 85, 38,${a})`, `rgba(246, 137, 61,${a})`, `rgba(254, 188, 56,${a})`, `rgba(202, 53, 66,${a})`, `rgba(39, 100, 123,${a})`, `rgba(132, 159, 173,${a})`, `rgba(174, 203, 201,${a})`, `rgba(216, 198, 180,${a})`, `rgba(87, 87, 95,${a})`, `rgba(21, 35, 41,${a})`];
	if(reverse) colors = colors.reverse();
	return colors.slice(0, n);
}

function Date2MDY(d) {
	return `${d.getMonth()+1}/${d.getDate()}/${d.getFullYear()}`;
}

function BinarySearch(ary, key, val, def={}, cpr=(a,b)=>{return a-b;}) {
	let beg = 0, end = ary.length-1, mid = Math.floor((beg+end)/2), cmp;
	while (beg<end) {
		cmp = cpr(val, ary[mid][key]);
		if (cmp == 0) break;
		else if (cmp < 0) end = mid - 1;
		else if (cmp > 0) beg = mid + 1;
		mid = Math.floor((beg+end)/2);
	}
	return ary[mid][key]==val ? ary[mid] : def;
}

function Num2abc(n) {
	let letters = "abcdefghijklmnopqrstuvwxyz", b26 = "0123456789abcdefghijklmnop";
	return letters[b26.indexOf(n.toString(26))];
}

function StripTags(str) {
	return str.replace(/&lt;[^&]*&gt;/g, '');
}

let domParser = new DOMParser();
function TAG(str, unsafe) {
	let doc = domParser.parseFromString(str.replace(/\n/g,' '),'text/html');
	let s = doc.body.textContent || "";
	if (unsafe) s = _.escape(s);
	return s;
}
function Untag(str) {
	if (str === undefined || str === null || str === '') return '';
	let doc = domParser.parseFromString(_.unescape(str).replace(/\n/g,' '),'text/html');
	return doc.body.textContent || "";
}

function getDatalabelCallback(size) {
	return function(ctx) {
		var scale = ctx.chart.scales.x;  // 'y' is your scale id
		var value = ctx.dataset.data[ctx.dataIndex];
		var range = Math.max(scale.max - scale.min, 1);
		return (ctx.chart.height / range) * value > size;
	}
}
var datalabelMinSize = 48;
function showDatalabel(ctx) {
	var scale = ctx.chart.scales.x;  // 'y' is your scale id
	var value = ctx.dataset.data[ctx.dataIndex];
	var range = Math.max(scale.max - scale.min, 1);
	return (ctx.chart.width / range) * value > datalabelMinSize;
}

class ModeData {
	constructor(arg='', pk1s='') {
		if (arg.name) {
			this.name = rfdc()(arg.name);
			this.filter = rfdc()(arg.filter);
		} else {
			this.name = arg.toLowerCase();
			this.filter = this.isAdmin ? pk1s : '';
		}
	}

	get isAdmin() {
		return this.name == 'administrator';
	}
	get isEnt() {
		return this.name == 'enterprise';
	}
	get isInst() {
		return this.name == 'instructor';
	}

	get itoken() {
		return this.isInst ? ' ' : '--';
	}
	get etoken() {
		return (this.isEnt && !isDebug()) ? ' ' : '--';
	}
	get atoken() {
		return (this.isAdmin) ? ' ' : '--';
	}
}

function SQLConcat(data, key, level, finish, param, queries) {
	return SQLAsync((proms, host, theUrl) => {
		queries.forEach(x=>{proms.push(GetSqlAsync(theUrl, getParams(host, bburl, x, param)).then(ary=>{
			data[key] = data[key].concat(ary);
			parseProgress.resolve();
		})); });
	}, queries.length, level, finish);
}

function SQLCallback(level, finish, param, queries, callback) {
	return SQLAsync((proms, host, theUrl) => {
		queries.forEach(x=>{proms.push(GetSqlAsync(theUrl, getParams(host, bburl, x, param)).then(ary=>{
			callback(ary);
			parseProgress.resolve();
		})); });
	}, queries.length, level, finish);
}

function ajGetSql(theUrl, params, async) {
	return $.ajax({url:theUrl, type:"POST", headers:{secret:"EAC!Products", dojson:'true'},
		cache:false, data:params, async:async, dataType:"json"});
}

function bjGetSql(theUrl, params, async) {
	return $.ajax({url:theUrl, type:"POST", headers:{secret:"EAC!Products", dojson:'true'},
		cache:false, data:params, global:false, async:async, dataType:"json"});
}
