page = 'test';
var WO=window.opener,parentscope=WO.mainscope,errData;
var settings = parentscope.settings;
var tsettings = rfdc()(settings.tests), $L = parentscope.$L;
let appHome = tsettings.home;
let n_title = [], n_ready=false, args_ia = {}, args_ss = {};
let summaryData = [], summaryDownload, summaryPdf;
let ia_data, dt_data;
let fixedCats = false;
let qs_fields = ['no', 'type', 'question', 'pv', 'pb', 'cd'], qs_cols = $L.t_questions_summary.cols, qs_data = [];
let duds = [], calculatedFormulaAnswers = {};
let sheetPK = ['usr_batch_uid', 'student_id', 'usr_email', 'crs_batch_uid'];

const permissions=parentscope.permissions,modes=parentscope.modes,OME=(permissions.ig&&modes.includes('instructor'))||(permissions.eg&&modes.includes('enterprise'))||(permissions.ag&&modes.includes('administrator')),GGE=permissions.gg;

var survey = false;
var doKr = true;
var cancel = false;
var avgt = 0;
var alltests1 = [];
var qds = [];
var showDomains = false;
var maxRecs = 0;
var minRecs = 100000;
var domain_pk1 = 1;
var domain_name = '';
var isPool = false;

var progs = [];
var dtod = parentscope.maxDate;
var dfod = parentscope.minDate;
var row;
var waitForIt = false;//true check()?

var qcount = 0; // non-demographic questions
var qSetNo = 0;
var bburl = null;
var token = null;
var dbtype = null;
var role = null;
var uid = null;
var username = null;
var sessionHash = null;
var ultrastatus = 'C';
var lang = 'en_US';
var langProps = null;
var pageHeader = new Array(3);
var cpk1;
var cats = null;
var rsql = '';
var sql = '';
var theUrl = '';
var host = '';
var params;
var ass;
var outcomes = new Array();
var distractors;
var currentPercentile = tsettings.di;
var passPercent = tsettings.threshold;
var myGridDataS;
var myOutsData;
var myOutsDatag;
var rawQData;
var rawCData;
var recs = 0;
var pos = 0;
var scoreQs = [];
var uniqueQs = [];
var excluded = [];
var demoQs = [];
var defaultCat;

var souts;
var outmgr;
var rawScores;
var isOracle;
var crs;
var smcolHeaders;
var eKinds = [1, 2, 3, 5, 17];
var pb;
var phd = "";
var grandTot = 0;
var utot = [];
var poss = 0;
var ptot = [];
var skips = [];
var multiTest = false;
var gmpk1 = "";
var crsData = [];
var fbidsRaw = [];
var fbidOrder = [];
var atables = [];
var myOutsData = [];
var smIvyData;
var outmgrShow = false;
var tr = [];

window.onerror = function (message, source, lineno, colno, error) {
	errData = {
		message:message,
		source:source,
		lineno:lineno,
		colno:colno,
		error:error,
		username:username,
		subject:'EAC Error',
		bburl:bburl,
		mode:parentscope.mode,
		node:parentscope.GetProgram ? parentscope.GetProgram() : '',
		filter:parentscope.filter,
		datemin:Date2MDY(parentscope.minDate),
		datemax:Date2MDY(parentscope.maxDate),
		page:location.pathname,
		tab:mainscope.tab+':'+JSON.stringify(mainscope.main.grids.map(g => g.title)),
		report:JSON.stringify(n_title),
		comment:'',
        version:WO.version
	}
	console.log(errData);
	send(errData);
	mainscope.err.show = true;
};

$(document).ready(
	function () {
		document.documentElement.lang = $L._ID;
		lang = window.opener.lang;
		langProps = window.opener.langProps;
		outmgrShow = window.opener.outmgrShow;
		domain_pk1 = window.opener.domain_pk1;
		domain_name = window.opener.domain_name;
		progs = window.opener.progs;
		showDomains = window.opener.showDomains;
		$('#footer').html(window.opener.footer);
		notify($L.loading.initialize);
		key = window.name;
		var query = null;
		if (!isDebug()) {
			if (key.split(':::').length > 0) {
				query = JSON.parse($.base64.decode(key.split(':::')[1]));
				sessionStorage.setItem(key.split(':::')[0], $.base64.encode(key.split(':::')[1]));
			} else {
				query=JSON.parse($.base64.decode(sessionStorage.getItem(key)));
			}
		} else {
			if (key.split(':::').length > 0) {
				query = JSON.parse(key.split(':::')[1]);
				sessionStorage.setItem(key.split(':::')[0],key.split(':::')[1]);
			} else query = JSON.parse(sessionStorage.getItem(key));
		}
		var quid = query.id;
		var quids = quid.split('_');
		var uquids = [];
		if (quids.length > 1) {
			quid = '';
			for (var u = 0; u < quids.length; u++) {
				if (uquids.indexOf(quids[u]) < 0) uquids.push(quids[u]);
			}
			quid = uquids.join(',');
			if (quid.split(',').length > 1) multiTest = true;
		}
		bburl = query.bburl;
		token = query.token;
		dbtype = query.dbtype;
		role = query.role;
		uid = query.uid;
		username = query.username;
		sessionHash = query.sessionHash;
		ultrastatus = query.ultrastatus;
		console.log("userid = " + uid + " username = " + username + " sessionHash = " + sessionHash);
		isOracle = getIsOracle();
		defaultCat = new sout();
		host = getHost();
		if (isDebug()) {
			theUrl = getSqlUrl(bburl);
			params = getParams(host, bburl);
		} else {
			theUrl = getSqlUrl();
			params = getParams(host);
		}
		console.log('at simple test');
		var rubricHeaders = window.opener.rubricHeaders;
		if (quid.indexOf('*') > -1) isPool = true;
		getSimpleTest(quid, holdQData, rubricHeaders, domain_name, domain_pk1, alltests1, qds);
		notify($L.loading.getting_questions);
	});

function fillGrids() {
	pageHeader[0] = ass.title;
	let phd0 = phd.substring(4);
	phd += '<br />';
	maxd = "2000";
	mind = "2050";
	for (var i = 0; i < rawScores.length; i++) {
		theR = rawScores[i];
		var d = theR.mdate;
		maxd = (d > maxd) ? d : maxd;
		mind = (d < mind) ? d : mind;
		if (isNaN(utot[theR.fbid])) utot[theR.fbid] = 0;
		var thisScore = theR.score * theR.status;
		utot[theR.fbid] += thisScore;
	}
	mind = mind.split('T')[0];
	now = new Date();
	dmin = new Date(mind);
	var parts = mind.match(/(\d+)/g);
	dmin = new Date(parts[0], parts[1] - 1, parts[2]);
	maxd = maxd.split('T')[0];
	parts = maxd.match(/(\d+)/g);
	dmax = new Date(parts[0], parts[1] - 1, parts[2]);
	let phd1 = dmin.toLocaleDateString(lang.replace('_', '-')) + " - " + dmax.toLocaleDateString(lang.replace('_', '-'));
	phd += phd1;
	if (showDomains) {
		if (domain_name.length > 0) phd += '<br />' + domain_name;
		else if (outmgrShow) phd += '<br />' + 'All Nodes';
	}
	let phd2 = (domain_name.length>0 && (isDebug()||getShowDomains(bburl))) ? domain_name : "";
	n_title = [phd0, phd1, phd2];
	console.log(n_title);
	
	pageHeader[1] = dmin.toLocaleDateString(lang.replace('_', '-')) + " - " + dmax.toLocaleDateString(lang.replace('_', '-'));
	if (showDomains) {
		if (domain_name.length > 0) pageHeader[1] += ':::' + domain_name;
		else if (outmgrShow) pageHeader[1] += ':::' + 'All Nodes';
	} else {
		if (domain_name.length > 0) pageHeader[1];
		else if (outmgrShow) pageHeader[1];
	}
	pos = scoreQs.length;
	qcount = scoreQs.length
	var u = 'Total pts = ' + grandTot + '\n';
	recs = 0;
	var max = 0;
	var min = 10000;
	md = new Array();
	var stddev = 0;
	for (n in utot) {
		if (!utot.hasOwnProperty(n) || typeof utot[n]==='function') continue;
		u += n + '=' + utot[n] + '\n';
		md.push(utot[n]);
		max = (utot[n] > max) ? utot[n] : max;
		min = (utot[n] < min) ? utot[n] : min;
		recs++;
	}
	md.sort(function (a, b) {
		if (a == b) return 0;
		return a < b ? 1 : -1;
	});
	// console.log(u);
	if (md.length % 2 == 1) median = md[Math.round(md.length / 2) - 1];
	else median = md[md.length/2]+((md[md.length/2 - 1]-md[md.length/2])/2);
	stddev = Math.round($.stdev(md) * 1000) / 1000;
	var kr = kr20(md, pos, rawScores, -1);
	biserial = ptBiserial(md, pos, rawScores);
	args_ia = {md:md, pos:pos, rawScores:rawScores, currentPercentile:currentPercentile, ptot:ptot, recs:recs};
	args_ss = {recs:recs, poss:poss, max:max, min:min, grandTot:grandTot, kr:kr, stddev:stddev, qcount:qcount, skips:skips};
	
	n_ready=true;
}

function FinishLoading() {
	doOutcomes(scoreQs);
	makeMyGridDataS();
	fixedCats = true;
	MakeQuestionSummary();
}

let goalGraphLabels = [];
function MakeGoalGraph() {
	let labels = {};
	let goalData = {
		labels: [],
		datasets: [{
			label: $L.t_goal_averages.data[0],
			backgroundColor: 'rgba(0, 105, 170, 0.5)',
			borderColor: 'rgba(0, 105, 170, 1)',
			borderWidth: 1,
			data: Array(myOutsData.length)
		}, {
			label: $L.t_goals_summary.cols[4],
			backgroundColor: 'rgba(254, 188, 56, 0.75)',
			borderColor: 'rgba(254, 188, 56, 1)',
			borderWidth: 1,
			data: Array(myOutsData.length)
		}, {
			label:'--',
			backgroundColor:'rgba(225, 112, 9, 0.5)',
			borderColor:"rgba(225, 112, 9, 1)",
			borderWidth:1,
			data:Array(myOutsData.length),
			hidden: true
		}]
	};
	for (var i = 0; i < myOutsData.length; i++) {
		labels[myOutsData[i].Outcomes] = myOutsData[i].Scored;
		goalData.datasets[0].data[i] = myOutsData[i].Avg * 100;
		goalData.datasets[1].data[i] = myOutsData[i]['Percent Met'] * 100;
	}
	for (let key of Object.keys(labels)) goalData.labels.push(`${key} (${labels[key]})`);
	goalGraphLabels = goalData.labels;
	return goalData;
}

// makeSummaryStatsTable
function GetSummaryData() {
	summaryDownload = [
		{Description:$L.stat.responses, Value:recs},
		{Description:$L.stat.questions, Value:qcount},
		{Description:$L.stat.possible, Value:poss},
		{Description:$L.stat.actual, Value:(poss - skips.length)},
		{Description:$L.stat.std, Value:$.precision(args_ss.stddev, 1e-3)},
		{Description:$L.stat.highest, Value:$.precision(args_ss.max, 1e-2)},
		{Description:$L.stat.lowest, Value:$.precision(args_ss.min, 1e-2)},
		{Description:$L.stat.mean, Value:$.precision(avgt, 1e-2)},
		{Description:$L.stat.median, Value:$.precision(median, 1e-2)},
		{Description:$L.stat.kr, Value:(isNaN(args_ss.kr) ? args_ss.kr : Number.parseFloat(args_ss.kr).toPrecision(3))}
	];
	//MakeSummaryPdf([[1,7,5],[2,8,6],[3,4,9]]);
	MakeSummaryPdf([[0,3,7],[1,5,8],[2,6,4],[-1,9,-2]]);
	for (let i = 0, j = 0; i < summaryDownload.length; i++) {
		if (i < summaryDownload.length/2) summaryData.push({d1:summaryDownload[i].Description, v1:summaryDownload[i].Value});
		else Object.assign(summaryData[j++], {s:' ', d2:summaryDownload[i].Description, v2:summaryDownload[i].Value});
	}
	summaryDownload.splice(8, 0, summaryDownload.splice(4, 1)[0]);
	if (!isNaN(args_ss.kr)) summaryDownload[9].Value = Number.parseFloat(summaryDownload[9].Value);
	return summaryData;
}

function GetStudentQCols() {
	smcolHeaders = new Array();
	smcolHeaders.push("Respondent","Attempt_Date","Total","Peer Avg","Diff");
	let sq = {headers:$L.t_student_questions.cols.slice(0, 5)};
	for (var p = 0, posl = pos; p < posl; p++) {
		smcolHeaders.push(scoreQs[p].position.toString());
		sq.headers.push(scoreQs[p].position.toString());
	}
	smcolHeaders.push("Incorrect Q Nos"); //"rowMcr"
	sq.headers.push($L.t_student_questions.cols[5]);
	if (showDomains) {
		smcolHeaders.push("Node");
		sq.headers.push($L.t_student_questions.cols[6]);
	}
	sq.keys = smcolHeaders;
	sq.sheet = smcolHeaders.concat(["category", "student_id", "usr_email", "crs_batch_uid"]);
	sq.sheetNames = sq.headers.concat($L.t_student_questions.sheet.slice(7));
	return sq;
}

// makeItemAnalysisTable
function GetItemAnalysisData() {
	//console.log(args_ia);
	let md=args_ia.md, pos=args_ia.pos, rawScores=args_ia.rawScores, currentPercentile=args_ia.currentPercentile, ptot=args_ia.ptot, recs=args_ia.recs;
	// headers
	cdi = calcDI(md, pos, rawScores, currentPercentile);
	colHeaders = ['no', 'title', 'question', 'pv', 'pb', 'cd', 'di'];
	var myGridData = new Array();
	for (var g = 0, gl = scoreQs.length; g < gl; g++) {
		col = 0;
		var aQ = scoreQs[g];
		if (aQ.scored===0 || ass.demos.indexOf(aQ.pk1)!==-1) continue;
		cd = kr20(md, pos, rawScores, g);
		var row = new Object();
		row[colHeaders[col++]] = aQ.position;
		var title = (aQ.title == null || aQ.title === "undefined" || aQ.title === undefined) ? "--" : aQ.title;
		row[colHeaders[col++]] = TAG(title);
		row[colHeaders[col++]] = aQ.q;
		row[colHeaders[col++]] = (Math.round((aQ.score / aQ.scored)*100)/100);
		row[colHeaders[col++]] = biserial[g];
		row[colHeaders[col++]] = cd;
		row[colHeaders[col++]] = cdi[g];
		myGridData.push(row);
	}
	ia_data = myGridData;
	return myGridData;
}

function fixCats() {
	for (let i = 0; i < cats.length; i++) {
		if (cats[i].category=="") cats[i].category=TAG(cats[i].title.split(':')[0]);
		if (cats[i].category.includes("**Set")) {
			remove(cats, i--);
			continue;
		}
		let sep = cats[i].title.lastIndexOf(':'), desc = "";
		if (sep >= 0) desc = cats[i].title.substring(sep + 1).trim();
		else desc = cats[i].title;
		cats[i].desc = desc;
	}
	fixedCats = true;
}

function MakeQuestionSummary() {
	qs_data = ia_data.slice();
	for (let i=0,j=0; i < qs_data.length; i++) {
		let ac = 0;
		for (; j < dt_data.length; j++) {
			if (qs_data[i].no == dt_data[j].no) {
				qs_data[i].type = dt_data[j].type;
				ac = 0;
			} else if (dt_data[j].no) break;
			let letter = String.fromCharCode(65 + ac);
			qs_data[i][letter] = dt_data[j].responses.match(/\d+/)[0];
			if (dt_data[j].correct == $L.correct_value) qs_data[i].correct = letter;
			if (!qs_fields.includes(letter)) {
				qs_fields.push(letter);
				qs_cols.push(letter);
			}
			ac++;
		}
	}
}

function GetStudentOutcomesHeaders(dsp, sheet) {
	let colHeaders = new Array();
	var sout;
	for (var p = 0, soutsl = souts.length; p < soutsl; p++) {
		if (souts[p].scored <= 0) continue;
		sout = souts[p];
		colHeaders.push(sout.cat);
	}
	return colHeaders;
}
function MakeStudentOutcomesT(so) {
	let d=so.grid.rowData, k=so.keys, h=so.headers, descs={};
	let result={keys:['0'], headers:[$L.goal._], model:[], ntypes:[undefined]};
	for (let out of myOutsData) descs[out.Outcomes]=out.desc;
	for (let j=1; j<h.length; ++j) result.model.push({'0':h[j], 'desc':SetDefault(descs[h[j]], '')});
	d.forEach((x, i) => {
		result.keys.push(`${i+1}`);
		result.headers.push(x.Respondent);
		result.ntypes.push('float');
		for(let j=1; j<k.length; ++j) result.model[j-1][`${i+1}`]=x[k[j]];
	});
	if (_.last(result.mode)) _.last(result.model).border = 'bottom';
	result.model.push({hide:true});
	sheetPK.forEach((pk, pki) => {
		let r = {'0':$L.t_student_goals.sheet[pki+1], hide:true};
		for (let i=0; i<d.length; ++i) r[`${i+1}`] = d[i][pk];
		result.model.push(r);
	});
	return result;
}

function makeStudentTest (row) {
	var wch = "list-style-type:lower-alpha;list-style-position:inside;";
	var cr = "list-style-image: url(../Images/green-checkmark.png);list-style-type:lower-alpha;list-style-position:inside;color:green;";
	var wr = "list-style-image: url(../Images/red-images.png); list-style-type:lower-alpha;list-style-position:inside;";
	var mrs = row.rowMcr.split(':::');
	var questions = [];
	
	for (var q = 0; q < scoreQs.length; q++) {
		var cats = [], aQ = scoreQs[q], resp = mrs[q], rs = resp.trim(), kind_id = aQ.kind_id, score = row[1+q];
		if (score == '--') continue;
		var arr = $.grep(souts, function (e, i) {
			if (e.qpk1.indexOf(aQ.pk1) !== -1) {
				cats.push(e.cat);
				return true;
			}
		});
		questions.push({text:aQ.q, outcomes:cats.join('; '), answers:[], id:q+1, kind_id:kind_id});
		
		if (kind_id == 1 || kind_id == 2 || kind_id == 3 || kind_id == 17) {
			let is_index = kind_id == 1 || kind_id == 17;
			
			for (var c = 0; c < aQ.choices.length; c++) {
				let is_correct = is_index ? aQ.choices[c] == aQ.correct : aQ.correct.indexOf(aQ.choices[c]) !== -1;
				let is_resp = is_index ? resp == c : rs.indexOf(aQ.choices[c]) !== -1, answer = {};
				
				if (is_correct) answer = { style:(is_resp ? cr : wch), choice:aQ.choices[c], correct:true, chosen:is_resp };
				else answer = { style:(is_resp ? wr : wch), choice:aQ.choices[c], correct:false, chosen:is_resp };
				
				_.last(questions).answers.push(answer);
			}
		} else if (kind_id == 6) {
			_.last(questions).answers.push({style:'',choice:aQ.correct,correct:true});
			_.last(questions).answers.push({style:(score==1?cr:wr), choice:resp, correct:score==1, chosen:true});
		} else if (kind_id == 7 || kind_id == 10 || kind_id == 16) {
			_.last(questions).answers.push({ style:'', choice:score, correct:false, chosen:false });
		}
	}
	return questions;
}

// Goals Manager
function outBtnT(goals, rows, add, del) {
	mainscope.loading = true;
	let adds = [], dels = [], ali;
	rows.forEach(row=>{ goals.forEach(goal=>{
		ali=row.data.aligns.filter(x=>x.clp_sog_pk1==goal.data.clppk1).map(y=>y.rr_pk1);
		if (ali.length > 0) dels.push({goal:goal.data, row:row.data});
		if (ali.length < rrm.g) {
			rrm.u[row.data.no].filter(x=>!ali.includes(x)).forEach(y=>{
				adds.push({goal:goal.data, row:row.data, qpk1:y});
			});
		}
	}); });
	if (dels.length>0 && del) tDelAlignmentAsync(dels);
	if (adds.length>0 && add) tAddAlignmentAsync(adds);
	// Update local data
	SyncGoals();
	mainscope.outcomesManager.AddModel(data.blueprint);
	mainscope.loading = false;
}
async function tAddAlignmentAsync(adds) {
	console.log(adds);
}
async function tDelAlignmentAsync(dels) {
	console.log(dels);
}

function CHeaderGoals(node, event, index, args, cell) {
	if (!mainscope.goalGraph.chart) return;
	let checked = $(`.${args.tag}.ag-checked`), parent = cell ? node.firstChild.firstChild.firstChild : node.parentNode;
	$('.'+args.tag).removeClass('ag-checked');
	if (checked[0]!=parent) {
		$(parent).toggleClass('ag-checked');
		mainscope.goalGraph.chart.config.data.datasets[2].data = myOutsData.map(x => myGridDataS[index-1][x.Outcomes]*100);
		mainscope.goalGraph.chart.config.data.datasets[2].label = myGridDataS[index-1].Respondent;
		mainscope.LO.setGraph(true);
	} else mainscope.LO.setGraph();
}

// Angular App Definition
var app = angular.module('App', ['ngMaterial', 'ngMessages', 'ngRoute', 'ngSanitize', 'ngAnimate'])
	.controller('Ctrl', function ($scope, $window, $interval, $timeout, $mdDialog){
		mainscope = $scope;
		Object.assign($scope, {loading:true, tab:'main', main:{grids:[]}, nOutcomes:[], popnav:true, autonav:true, saved:true, $L:$L, saveTimeout:null, GGE:GGE, tsettings:tsettings, SOTransposed:false, settings:parentscope.settings});
		$scope.err = {show:false, comment:true, text:"", send:function(){
			errData.comment = $scope.err.text;
			console.log(errData);
			send(errData);
			$scope.err.show = false;
			$scope.err.text = "";
		}};
		$scope.warning = {show:false, msg:$L.msg.error, ok:false, dismiss:false, close:false};
		$scope.Warn = function(msg, dissmissable) {
			$scope.warning.msg = msg;
			$scope.warning.dismiss = dissmissable;
			$scope.warning.show = true;
		}
		
		$scope.loadTab = function(name) {
			if (!n_ready) return;
			if ($scope[$scope.tab].unload != undefined) $scope[$scope.tab].unload();
			$scope.tab = name;
			if ($scope[name].load != undefined) $scope[name].load();
		};
		$scope.Save = function() {
			tsettings={sgt:$scope.SOTransposed,di:$scope.IA.DI,threshold:$scope.LO.OP};
			tsettings.home = $scope.main.grids.map(g => g.id);
			parentscope.settings.tests = rfdc()(tsettings);
			storedObject.set(uid, parentscope.settings);
			clearTimeout($scope.saveTimeout);
			$scope.saved = false;
			$scope.saveTimeout=$timeout(function() {$scope.saved=true;}, 1000);
		}
		$scope.SideNav = function(state) {
			$scope.popnav = state;
			$scope.autonav = false;
		};
		
		// executes when eac is ready
		$scope.OnReady = function() {
			if (!n_ready) {
				$timeout($scope.OnReady, 10);
				return;
			}
			$scope.progress = 0;
			// Header
			$scope.title = n_title;
			for (let i = 0; i < crsData.length; i++) crsData[i].percent = Math.round(100 * (crsData[i].responses / crsData[i].enrollment));
			$scope.coursesIncluded = new GridBox({
				mode:'coursesIncluded',
				title:$L.t_courses_included.title,
				id:0,
				keys:['course','instructors','enrollment','responses','percent'],
				headers:$L.t_courses_included.cols,
				model:crsData,
				props:{domLayout:'autoHeight'},
				auto:['enrollment', 'responses', 'percent'],
				sheet:['course', 'instructors', 'enrollment', 'responses', 'percent', 'crs_batch_uid'],
				sheetNames:$L.t_courses_included.sheet
			});
			let iac = $L.t_item_analysis.cols.slice();
			iac[6] = LangArg(iac[6], currentPercentile);
			$scope.itemAnalysis = new GridBox({
				mode:'itemAnalysis',
				title:$L.t_item_analysis.title,
				id:2,
				keys:['no', 'title', 'question', 'pv', 'pb', 'cd', 'di'],
				headers:iac,
				model:GetItemAnalysisData(),
				auto:['no', 'title', 'pv', 'pb', 'cd', 'di'],
				colProps:[[4], {cellStyle:pbStyle2}, [2], {wrapText:true, autoHeight:true, minWidth:120}],
			});
			dt_data = GetDistractorsData(['no', 'type', 'question', 'correct', 'PtBis', 'responses', 'cnos']);
			$scope.distractorsTable = new GridBox({
				mode:'distractors',
				title:$L.t_distractors.title,
				id:3,
				keys:['no', 'type', 'question', 'correct', 'PtBis', 'responses'],
				headers:$L.t_distractors.cols,
				model:dt_data,
				props:{enableSorting:false, rowClassRules:{'row-question':'data.no != null'}},
				auto:['no', 'type', 'correct', 'PtBis'],
				colProps:[[2], {wrapText:true, autoHeight:true, minWidth:120}, [3], {cellClassRules:{'cell-correct':'x == $L.correct_value'}}, [4], {cellStyle:pbStyle, cellRenderer:(x => (x.value!=0 && typeof x.value=='number'?'&#9679;&nbsp;':'')+x.value)}],
				sheet:['no', 'type', 'question', 'correct', 'PtBis', 'responses', 'n', 'percent'],
				sheetNames:$L.t_distractors.sheet,
				filter:false
			});
			// Student Analysis
			FinishLoading();
			let studentQCols = GetStudentQCols();
			$scope.studentQuestions = new GridBox({
				mode:'studentQuestions',
				title:$L.t_student_questions.title,
				id:4,
				keys:studentQCols.keys,
				headers:studentQCols.headers,
				model:GetStudentQuestions(args_ia.rawScores),
				props:{rowSelection:'single', suppressRowClickSelection:true, onSelectionChanged:$scope.SA.select},
				auto:true,
				colProps:[[0], {checkboxSelection:true}, [0,1,2], {pinned:'left'}, duds.map(x => x+5), {hide:true}],
				sheet:studentQCols.sheet,
				sheetNames:studentQCols.sheetNames,
				unload:function(){mainscope.studentTest.active = false;},
			});
			// Item Analysis
			$scope.summaryStatistics = new GridBox({
				mode:'summaryStatistics',
				title:$L.t_summary_statistics.title,
				id:1,
				keys:['d1','v1','s','d2','v2'],
				headers:$L.t_summary_statistics.cols,
				model:GetSummaryData(),
				props:{domLayout:'autoHeight'},
				auto:false,
				autoIfScroll:true,
				colProps:[[2], {width:52}, [3,4], {cellClassRules:{'highlightbg':'rowIndex == 4'}}],
				sheet:['Description', 'Value'],
				sheetNames:$L.t_summary_statistics.sheet,
				sheetData:summaryDownload,
				pdfdata:summaryPdf,
				filter:false
			});
			$scope.studentTest={active:false, title:'', questions:[], check:false};
			let lcol = $L.t_student_landscape.cols;
			if (showDomains) lcol = AryInsert(lcol, $L.node, 6);
			$scope.studentLandscape = new GridBox({
				mode:'studentLandscape',
				title:$L.t_student_landscape.title,
				id:7,
				keys:Object.keys(new smIvyRow()),
				headers:lcol,
				model:GetStudentLandscape(args_ia.rawScores),
				auto:true,
				colProps:[[0,3,4], {pinned:'left'}]
			});
			// Learning Outcomes
			$scope.outcomesSummary = new GridBox({
				mode:'goalsSummary',
				title:$L.t_goals_summary.title,
				id:5,
				keys:['Outcomes','Scored','Avg','Threshhold','Percent Met','# Qs','% Qs'],
				headers:$L.t_goals_summary.cols,
				model:makeOutcomesData(),
				colProps:[[0], {tooltipField:'desc'}],
				auto:['Scored','Avg','Threshhold','Percent Met','# Qs','% Qs'],
				autoIfNeeded:true,
				pdfwidths:[0],
				pdfbars:'Avg',
				sheet:['Outcomes','Scored','Avg','Threshhold','Percent Met','# Qs','% Qs','desc'],
				sheetNames:$L.t_goals_summary.sheet
			});
			$scope.goalGraph = {
				id:'goalGraph',
				pid:'goalGraphParent',
				init:$scope.LO.loadGraph,
				title:$L.t_goal_averages.title,
				filename:$L.t_goal_averages.title
			};
			let sg = GetStudentOutcomesHeaders();
			$scope.studentOutcomes = new GridBox({
				mode:'studentGoals',
				title:$L.t_student_goals.title,
				id:6,
				keys:['Respondent'].concat(sg),
				headers:$L.t_student_goals.cols.concat(sg),
				model:myGridDataS,
				props:{rowSelection:'single', suppressRowClickSelection:true, onSelectionChanged:$scope.LO.select, suppressFieldDotNotation:true},
				auto:true,
				colProps:[[0], {checkboxSelection:true, pinned:'left'}],
				sheet:['Respondent', ...sg, ...sheetPK],
				sheetNames:[$L.t_student_goals.sheet[0], ...sg].concat($L.t_student_goals.sheet.slice(1)),
				unload:mainscope.LO.setGraph,
			});
			let sot = MakeStudentOutcomesT($scope.studentOutcomes);
			$scope.studentOutcomesT = new GridBox({
				mode:'studentGoalsT',
				title:$L.t_student_goals.title,
				id:'6t',
				keys:sot.keys,
				headers:sot.headers,
				model:sot.model,
				props:{suppressFieldDotNotation:true},
				auto:true,
				props:{tooltipShowDelay:0,rowClassRules:{'row-invisible':'data.hide'}, getRowHeight:(params)=>(params.data.hide?0:46),components:{agColumnHeader:CHeader, customTooltip:CustomTooltip}},
				colProps:[[0], {pinned:'left', tooltipField:'desc'}, sot.keys.slice(1), {headerComponent:CHeader, headerComponentParams:{func:'CHeaderGoals',args:{tag:'sgt-header', no:['0']}},headerClass:'header-check'}],
				unload:mainscope.LO.setGraph,
				ntypes:sot.ntypes,
				getEnabled:$scope.studentOutcomes
			});
			$scope.studentCoaching = new GridBox({
				mode:'studentCoaching',
				title:$L.t_student_coaching.title,
				id:8,
				keys:['Course_id', 'Attempt_Date', 'First_Name', 'Last_Name', 'User_email', 'GM_Title', 'Title', 'Question', 'QPos', 'Correct', 'Answer', 'Correct_Ans'],
				headers:$L.t_student_coaching.cols,
				model:GetCoachingData(),
				sheet:['Course_id', 'Attempt_Date', 'First_Name', 'Last_Name', 'User_email', 'Student_id','GM_Title', 'Title', 'Question', 'QPos', 'Correct', 'Answer', 'Correct_Ans'],
				sheetNames:$L.t_student_coaching.sheet,
				auto:true
			});
			$scope.nOutcomes = new GoalSelector(cats);
			$scope.outcomesManager = new GridBox({
				mode:'blueprint',
				title:$L.t_blueprint.title,
				keys:['No', 'Question', 'Outcome'],
				headers:$L.t_blueprint.cols,
				model:makeOutsMgr(),
				props:{rowSelection:'multiple', suppressRowClickSelection:true, onSelectionChanged:$scope.OM.select, onGridReady:$scope.OM.ready},
				auto:['No', 'Outcome'],
				colProps:[[0], {checkboxSelection:true, headerCheckboxSelection:true}, [1], {autoHeight:true, cellStyle:{'white-space':'normal'}}, [2], {autoHeight:true, cellStyle:{'white-space':'pre'}, cellRenderer:(x => x.value != 'Default' ? x.value : ' ')}],
				sheet:['No', 'Question', 'xOutcome'],
				sheetNames:$L.t_blueprint.cols
			});
			// Exports Tab
			$scope.questionSummary = new GridBox({
				mode:'questionSummary',
				title:$L.t_questions_summary.title,
				keys:qs_fields,
				headers:qs_cols,
				model:qs_data,
				auto:true,
				pdfwidths:[2]
			});
			$scope.testInfo = new GridBox({
				mode:'info',
				title:$L.t_info.title,
				keys:($scope.title[2].length>0 ? ['Test','Date','Node'] : ['Test','Date']),
				headers:$scope.title[2].length>0 ? $L.t_info.cols : $L.t_info.cols.slice(0, 2),
				model:[{Test:$scope.title[0], Date:$scope.title[1], Node:$scope.title[2]}],
			});
			if (differed) $scope.testInfo.footer = $L.msg.test_differed;
			$scope.EX.grids = ['testInfo', 'coursesIncluded','summaryStatistics', 'questionSummary', 'itemAnalysis','distractorsTable','studentQuestions','studentLandscape',...GGE?['outcomesSummary','studentOutcomes']:[], 'studentCoaching', ...OME?['outcomesManager']:[]].map(x => $scope[x]);
			$scope.EX.fullgrids = ['testInfo', 'coursesIncluded','summaryStatistics', 'itemAnalysis','distractorsTable','studentQuestions',...GGE?['outcomesSummary','studentOutcomes']:[], 'studentLandscape', 'studentCoaching',  ...OME?['outcomesManager']:[]].map(x => $scope[x]);
			if (tsettings.sgt) $scope.TransposeSO(true);
			$scope.EX['fileName']=n_title.join('_').replace(' ','-');
			
			$scope.loading=false; // done loading
		};
		$scope.OnReady();
		
		// Item Analysis Tab
			$scope.IA = { DI:tsettings.di,
			change:function(report){
				currentPercentile = $scope.IA.DI;
				$scope.itemAnalysis.grid.columnDefs[6].headerName = LangArg($L.t_item_analysis.cols[6], currentPercentile);
				let cdi = calcDI(md, pos, rawScores, currentPercentile);
				for(let i = 0; i < cdi.length; i++) $scope.itemAnalysis.grid.rowData[i].di = cdi[i];
				$scope.itemAnalysis.AddModel($scope.itemAnalysis.grid.rowData);
				if (!report && $scope.itemAnalysis.grid.api) {
					if (typeof $scope.itemAnalysis.grid.api.setGridOption === 'function') {
						$scope.itemAnalysis.grid.api.setGridOption('columnDefs', $scope.itemAnalysis.grid.columnDefs);
					} else if (typeof $scope.itemAnalysis.grid.api.setColumnDefs === 'function') {
						$scope.itemAnalysis.grid.api.setColumnDefs($scope.itemAnalysis.grid.columnDefs);
					}
				}
				$scope.itemAnalysis.AutoSize();
			}
		};
		// Student Analysis Tab
		$scope.SA = { select:function(event) {
				let nodes = event.api.getSelectedNodes();
				if (nodes.length == 0) $scope.studentTest = { active:false, title:"", questions:[], check:$scope.studentTest.check };
				else $scope.studentTest = { active:true, title:nodes[0].data.Respondent, questions:makeStudentTest(nodes[0].data), check:$scope.studentTest.check };
				if ($scope.$apply) $scope.$apply();
				if (nodes.length > 0) event.api.ensureNodeVisible(nodes[0], 'middle');
			}, unload:function() {
				$scope.studentTest={active:false,title:'',questions:[],check:false};
			}
		};
		// Learning Outcomes Tab
		$scope.LO = { OP:tsettings.threshold,
			loadGraph:function(id, pid) {
				$scope.goalGraph.config = {
					type: 'bar',
					data: MakeGoalGraph(),
					options: {
						elements: {rectangle:{borderWidth:2}},
						scales: {
							x: {position:'top', min:0, max:100, ticks: {callback:(value)=>value+'%'}},
							y: {scaleLabel:{display:true, labelString:$L.t_goal_averages.axis, fontSize:16}, ticks: {callback:x=>Trunc(goalGraphLabels[x])}}
						},
						indexAxis: 'y',
						responsive: true,
						maintainAspectRatio: false,
						interaction: {mode: 'index'},
						plugins: {
							title: {display:true, text:$L.t_goal_averages.title},
							legend: {
								labels: {
									filter: (item, chart) => !chart.datasets[item.datasetIndex].hidden
								}
							},
							datalabels: {
								formatter: (value, context) => $.precision(value, 1e-1)+'%',
								display: showDatalabel
							},
							tooltip: { enabled: false,
								callbacks: {
									title: tooltipItems => tooltipItems[0].label,
									label: tooltipItem => {
										let label = tooltipItem.dataset.label;
										if (label.length == 0) return;
										label += ': ' + $.precision(tooltipItem.raw, 1e-1) + '%';
										return label;
									}
								}
							}
						}
					}
				};
				$scope.goalGraph.chart = new Chart(id, $.extend(true, {}, $scope.goalGraph.config));
				$('#'+pid).height(myOutsData.length*48 + 96);
			}, change:function(report) {
				passPercent = $scope.LO.OP;
				$scope.outcomesSummary.AddModel(makeOutcomesData());
				if (!$scope.goalGraph.chart) return;
				$scope.goalGraph.chart.data.datasets[1].data = $scope.outcomesSummary.grid.rowData.map(x => x["Percent Met"] * 100);
				$scope.goalGraph.chart.update();
			}, select:function(event) {
				let nodes = event.api.getSelectedNodes();
				if (nodes.length > 0) {
					$scope.goalGraph.chart.config.data.datasets[2].data = myOutsData.map(x => nodes[0].data[x.Outcomes] * 100);
					$scope.goalGraph.chart.config.data.datasets[2].label = nodes[0].data.Respondent;
					$scope.LO.setGraph(true);
				}
				else $scope.LO.setGraph();
				if (nodes.length > 0) event.api.ensureNodeVisible(nodes[0], 'middle');
			}, setGraph:function(hidePercent = false) {
				$scope.goalGraph.chart.data.datasets[1].hidden = hidePercent;
				$scope.goalGraph.chart.data.datasets[2].hidden = !hidePercent;
				$scope.goalGraph.chart.update();
			}
		};
		// Outcomes Manager Tab
		$scope.OM = { outcomes:[], questions:[], ok:false, enabled:OME,
			ready:function() {
				mainscope.outcomesManager.grid.api.forEachNode(function(node, index){
					for (let q of mainscope.OM.questions) if (q.id == node.id) node.setSelected(true);
				});
				setIntervalX($scope.outcomesManager.AutoSize, 100, 5, $scope.outcomesManager);
			}, button:function(add, del) {
				outBtn($scope.OM.outcomes, $scope.OM.questions, add, del);
				$scope.outcomesManager.AddModel(makeOutsMgr());
				if ($scope.outcomesManager && $scope.outcomesManager.grid && $scope.outcomesManager.grid.api) {
					$scope.outcomesManager.grid.api.deselectAll();
				}
				$scope.outcomesSummary.AddModel(makeOutcomesData());
				
				// Update studentOutcomes grid - modify existing grid instead of recreating
				let sg = GetStudentOutcomesHeaders();
				let newKeys = ['Respondent'].concat(sg);
				let newHeaders = $L.t_student_goals.cols.concat(sg);
				let newData = makeMyGridDataS();
				
				if ($scope.studentOutcomes && $scope.studentOutcomes.grid && $scope.studentOutcomes.grid.api) {
					// Build new column definitions
					let newColDefs = [];
					// First column (Respondent) - keep existing structure
					let firstCol = $scope.studentOutcomes.grid.columnDefs[0] || {};
					newColDefs.push({
						...firstCol,
						headerName: newHeaders[0],
						field: newKeys[0],
						checkboxSelection: true,
						pinned: 'left'
					});
					// Goal columns - create based on existing structure
					for (let i = 0; i < sg.length; i++) {
						let baseCol = $scope.studentOutcomes.grid.columnDefs[1] || {};
						newColDefs.push({
							...baseCol,
							headerName: newHeaders[i + 1],
							field: newKeys[i + 1]
						});
					}
					
					// Update grid using setGridOption for ag-grid v34
					if (typeof $scope.studentOutcomes.grid.api.setGridOption === 'function') {
						$scope.studentOutcomes.grid.api.setGridOption('columnDefs', newColDefs);
						$scope.studentOutcomes.grid.api.setGridOption('rowData', newData);
					} else if (typeof $scope.studentOutcomes.grid.api.setColumnDefs === 'function') {
						$scope.studentOutcomes.grid.api.setColumnDefs(newColDefs);
						if (typeof $scope.studentOutcomes.grid.api.setRowData === 'function') {
							$scope.studentOutcomes.grid.api.setRowData(newData);
						}
					}
					
					// Update internal references
					$scope.studentOutcomes.grid.columnDefs = newColDefs;
					$scope.studentOutcomes.keys = newKeys;
					$scope.studentOutcomes.headers = newHeaders;
					$scope.studentOutcomes.sheet = ['Respondent', ...sg, ...sheetPK];
					$scope.studentOutcomes.sheetNames = [$L.t_student_goals.sheet[0], ...sg].concat($L.t_student_goals.sheet.slice(1));
					$scope.studentOutcomes.AutoSize();
				} else {
					// Grid not initialized yet, create it normally
					$scope.studentOutcomes = new GridBox({
						mode:'studentGoals',
						title:$L.t_student_goals.title,
						id:6,
						keys:newKeys,
						headers:newHeaders,
						model:newData,
						props:{rowSelection:'single', suppressRowClickSelection:true, onSelectionChanged:$scope.LO.select, suppressFieldDotNotation:true},
						auto:true,
						colProps:[[0], {checkboxSelection:true, pinned:'left'}],
						sheet:['Respondent', ...sg, ...sheetPK],
						sheetNames:[$L.t_student_goals.sheet[0], ...sg].concat($L.t_student_goals.sheet.slice(1)),
						enabled:$scope.studentOutcomes ? $scope.studentOutcomes.enabled : true,
						unload:mainscope.LO.setGraph
					});
				}
				
				// Update studentOutcomesT grid - modify existing grid instead of recreating
				let sot = MakeStudentOutcomesT($scope.studentOutcomes);
				if ($scope.studentOutcomesT && $scope.studentOutcomesT.grid && $scope.studentOutcomesT.grid.api) {
					// Build new column definitions
					let newColDefsT = [];
					// First column (goal) - keep existing structure
					let firstColT = $scope.studentOutcomesT.grid.columnDefs[0] || {};
					newColDefsT.push({
						...firstColT,
						headerName: sot.headers[0],
						field: sot.keys[0],
						pinned: 'left',
						tooltipField: 'desc'
					});
					// Student columns - create based on existing structure
					for (let i = 1; i < sot.keys.length; i++) {
						let baseCol = $scope.studentOutcomesT.grid.columnDefs[1] || {};
						newColDefsT.push({
							...baseCol,
							headerName: sot.headers[i],
							field: sot.keys[i],
							headerComponent: CHeader,
							headerComponentParams: {
								func: 'CHeaderGoals',
								args: {tag: 'sgt-header', no: ['0']}
							},
							headerClass: 'header-check'
						});
					}
					
					// Update grid using setGridOption for ag-grid v34
					if (typeof $scope.studentOutcomesT.grid.api.setGridOption === 'function') {
						$scope.studentOutcomesT.grid.api.setGridOption('columnDefs', newColDefsT);
						$scope.studentOutcomesT.grid.api.setGridOption('rowData', sot.model);
					} else if (typeof $scope.studentOutcomesT.grid.api.setColumnDefs === 'function') {
						$scope.studentOutcomesT.grid.api.setColumnDefs(newColDefsT);
						if (typeof $scope.studentOutcomesT.grid.api.setRowData === 'function') {
							$scope.studentOutcomesT.grid.api.setRowData(sot.model);
						}
					}
					
					// Update internal references
					$scope.studentOutcomesT.grid.columnDefs = newColDefsT;
					$scope.studentOutcomesT.keys = sot.keys;
					$scope.studentOutcomesT.headers = sot.headers;
					$scope.studentOutcomesT.grid.ntypes = sot.ntypes;
					$scope.studentOutcomesT.AutoSize();
				} else {
					// Grid not initialized yet, create it normally
					$scope.studentOutcomesT = new GridBox({
						mode:'studentGoalsT',
						title:$L.t_student_goals.title,
						id:'6t',
						keys:sot.keys,
						headers:sot.headers,
						model:sot.model,
						props:{tooltipShowDelay:0,rowClassRules:{'row-invisible':'data.hide'}, getRowHeight:(params)=>(params.data.hide?0:46),components:{agColumnHeader:CHeader, customTooltip:CustomTooltip}},
						auto:true,
						colProps:[[0],{pinned:'left',tooltipField:'desc'}, sot.keys.slice(1), {headerComponent:CHeader, headerComponentParams:{func:'CHeaderGoals', args:{tag:'sgt-header', no:['0']}}, headerClass:'header-check'}],
						unload:mainscope.LO.setGraph,
						enabled:$scope.studentOutcomes ? $scope.studentOutcomes.enabled : true,
						ntypes:sot.ntypes,
						getEnabled:$scope.studentOutcomes
					});
				}
				
				$scope.LO.change();
				if ($scope.goalGraph.chart) {
					$scope.goalGraph.chart.data = MakeGoalGraph();
					$scope.LO.setGraph();
				}
			}, select:function(event) {
				$scope.OM.questions = event.api.getSelectedNodes();
				$scope.OM.ok = $scope.OM.outcomes.length > 0 && $scope.OM.questions.length > 0;
				if ($scope.OM.outcomes.length > 0 || $scope.OM.questions.length > 0) $scope.$apply();
			}, load:function() {
				setIntervalX($scope.outcomesManager.AutoSize, 100, 5, $scope.outcomesManager);
			}, 			unload:function() {
				Object.assign($scope.OM, {outcomes:[], questions:[], ok:false, switch:true });
				if ($scope.nOutcomes.reset) $scope.nOutcomes.reset();
				if ($scope.outcomesManager && $scope.outcomesManager.grid && $scope.outcomesManager.grid.api) {
					$scope.outcomesManager.grid.api.deselectAll();
				}
			}
		};
		// Export Tab
		$scope.EX = { fullgrids:[], grids:[], ok:false, interval:null, header:true, blueprint:false, qs:false,
			download:function(type) {
				$scope.testInfo.enabled = $scope.EX.header;
				$scope.outcomesManager.enabled = $scope.EX.blueprint;
				$scope.questionSummary.enabled = $scope.EX.qs;
				if (type == '.pdf') {
					let doc = {
						pageOrientation:settings.orientation,
						content:[], styles: {
							header:{fontSize:18, bold:true, alignment:'center'},
							subheader: { fontSize:16, alignment:'center', margin:[0,0,0,10] },
							table: { margin:[0, 10, 0, 10] },
							tableHeader: { bold:true, fontSize:13.5},
							tableTitle:{bold:true, fontSize:15, fillColor:'#80ceff', alignment:'center'}
						},
					};
					if($scope.testInfo.enabled) doc.content.push({text: n_title[0],style:'header'},{text:n_title[1],style:'subheader'});
					if (differed) doc.content.push({text:$L.msg.test_differed});
					for (let g of $scope.EX.grids) if (g.enabled && g.mode!='info') doc.content.push(g.GetPdf());
					pdfMake.createPdf(doc).download($scope.EX.fileName+type);
				} else if (type == '.docx') {
					let doc = StartDoc(true);
					for (let g of $scope.EX.grids) if (g.enabled && g.mode!='info') doc += g.GetDoc();
					doc += '</body>\n</html>';
					saveAs(htmlDocx.asBlob(doc, {orientation:settings.orientation}), $scope.EX.fileName+type);
				} else {
					let wb = XLSX.utils.book_new();
					for(let g of $scope.EX.grids) if(g.enabled) g.GetSheet(wb);
					if (type == '.csv' && wb.SheetNames.length > 1) {
						let zip = new JSZip();
						for (let name of wb.SheetNames) zip.file(name+type, XLSX.utils.sheet_to_csv(wb.Sheets[name]));
						zip.generateAsync({type:"blob"}).then(function(content) {
							saveAs(content, $scope.EX.fileName + '.zip');
						});
					}
					else XLSX.writeFile(wb, $scope.EX.fileName + type);
				}
			}, full:function() {
				let wb = XLSX.utils.book_new();
				for (let g of $scope.EX.fullgrids) g.GetSheet(wb);
				XLSX.writeFile(wb, $scope.EX.fileName + '.xlsx');
			}, doc:function(standard) {
				let fn = $scope.EX.fileName+'-'+(standard?$L.download.standard:$L.download.summary)+'.docx', doc = StartDoc(true);
				doc += $scope.coursesIncluded.GetDoc();
				doc += $scope.summaryStatistics.GetDoc();
				if (!standard) doc += $scope.questionSummary.GetDoc();
				if (standard) {
					doc += $scope.itemAnalysis.GetDoc();
					doc += $scope.distractorsTable.GetDoc();
					if (GGE) doc += $scope.outcomesSummary.GetDoc();
				}
				doc += '</body>\n</html>';
				saveAs(htmlDocx.asBlob(doc,{orientation:settings.orientation}),fn);
			}
		};
		
		$scope.TransposeSO = function(transpose=false) {
			if (!GGE) return;
			$scope.SOTransposed = transpose;
			$scope.EX.grids[9] = transpose ? $scope.studentOutcomesT : $scope.studentOutcomes;
			$scope.EX.fullgrids[7] = transpose ? $scope.studentOutcomesT : $scope.studentOutcomes;
			$scope.LO.setGraph();
		}
	});
EacAppSetup(app);
