page = 'home';
const key = 'EAC';
const query = storedObject.get(key, true);
const license = query.active, permissions = query.perms;

var $L = false;
var appHome = false;
var aTestPk1;
var bburl;
var cancel = false;
var courseList = [];
var dbtype;
var footer = '';
var fs = '';
var goalCats = null;
var goalGraph;
var gs = new GridSelector();
var lang;
//var langId;
var langList = [{id:'en', str:'English'}, {id:'es', str:'Español'}/*, {id:'ar', str:'العربية'}*/];
var nlog = [];
var nReady = false, gReady = false;
var n_title = false;
var outmgrShow = true;
var progs = [{name:'All Nodes', domain_pk1:0}];
var rubricHeaders = {'grid.row1.label':'DefaultRow1', 'grid.row2.label':'DefaultRow2', 'grid.row3.label':'DefaultRow3', 'grid.column1.label':'DefaultColumn1', 'grid.column2.label':'DefaultColumn2', 'grid.column3.label':'DefaultColumn3'};
var selected_qdpk1s = [];
var sessionHash;
var settings;
var dashTabs = [...permissions.tt?['tests']:[],...permissions.rt?['rubrics']:[],...permissions.gt?['goals']:[]];//,...permissions.ot?['outcomes']:[]];
var settings_default = {theme:0,language:'en',mode:'administrator',node:0,tests:{home:[0,1],sgt:false,di:27,threshold:0.6},rubrics:{home:[1,5],srt:false,sgt:false,gsl:false,threshold:0.6},orientation:'landscape',version:'6.2.282'};
var showGoals = false;
var spt;
var token;
var uid = query.uid;
var username;
var goalDetailData = [];
var goalDetailMap = {};
var op = window.opener;
var CHUNK_SIZE = 8, MAX_QUERIES = 15;
var oaUser = false;
var mode_pk1s = '';
var modeData = new ModeData();
var bbassess=false;
var terms = [];
var WO = window;

var errData;
window.onerror = function (message, source, lineno, colno, error) {
	errData={message:message, source:source, lineno:lineno, colno:colno, error:error, username:username, subject:'EAC Error', bburl:bburl, mode:mainscope.mode, filter:mainscope.filter, datemin:Date2MDY(mainscope.minDate), datemax:Date2MDY(mainscope.maxDate), page:location.pathname, tab:mainscope.tab, comment:'', version:window.version};
	if (mainscope.GetProgram) errData.node = mainscope.GetProgram();
	if (mainscope.GetReport) errData.report = mainscope.GetReport();
	console.log(errData);
	send(errData);
	mainscope.err.show = true;
	mainscope.loading = false;
};

// Get Settings
if (!(typeof query.lang === 'undefined')) lang = query.lang;
settings_default.language = GetLang(lang);
let storedSettings = storedObject.get(uid);
if (!storedSettings || storedSettings.version!=settings_default.version) storedSettings = settings_default;
settings = storedSettings;
settings.language = GetLang(settings.language);
let storedLang = storedObject.get('lang', !isDebug());
if (storedLang) $L = storedLang;
else LoadLang(settings.language);
document.documentElement.lang = $L._ID;
progs[0].name = $L.nodes_all;

$(document).ready(function () {
	if (!license) WIN.Destroy($L.msg.expired, $L.msg.contact);
	/*if (op && (op!=window) && op.document && op.document.title && op.document.title.startsWith('EAC') && !op.backed) {
		op.history.go(WIN.IsFrame(op)?-2:-1);
		if (op) op.backed = true;
	}*/
	if (op && _.isFunction(op.close)) op.close();
	bburl = query.BbUrl;
	token = query.token;
	dbtype = query.dbtype;
	username = query.username;
	sessionHash = query.sessionHash;
	
	if (!(typeof query.gridrow1label === 'undefined')) {
		rubricHeaders['grid.row1.label'] = query.gridrow1label;
		rubricHeaders['grid.row2.label'] = query.gridrow2label;
		rubricHeaders['grid.row3.label'] = query.gridrow3label;
		rubricHeaders['grid.column1.label'] = query.gridcolumn1label;
		rubricHeaders['grid.column2.label'] = query.gridcolumn2label;
		rubricHeaders['grid.column3.label'] = query.gridcolumn3label;
	}
	console.log("from storage "+uid +" "+bburl+" "+token+" "+dbtype+" "+username+" "+license+" "+permissions+" "+rubricHeaders['grid.row1.label']+" "+lang);
	isOracle = getIsOracle();
	console.log(lang);
	to_date = new Date();
	dm = 86400000;// ms in a day
	fd = to_date.getTime() - 7 * dm; // changed from 15 to 7 2016_01_17
	from_date = new Date();
	from_date.setTime(fd);
	//getGoalsList();
	spt = $("#spinnerText");
	window.focus();
	var dpLang = lang.substring(0, 2);
	dpLang = (dpLang === 'en') ? '' : dpLang;
	console.log(dpLang);
	url = getPath();
	if (isDebug()) {
		theUrl = getSqlUrl(bburl);
		path = getPath();
		params = getParams(host, bburl);
	} else {
		theUrl = getSqlUrl(bburl);
		path = getPath();
		params = getParams(host, bburl);
	}
	testUrl = url + '/EacTests.html?id=' + aTestPk1;
	var checkHost = location.host.split(":")[0];
	var ua = navigator.userAgent;
	var addRow = false;
	var catsetlink = -2;
	showDomains = getShowDomains(bburl);
	LoadDashAsync(uid, $("#footer"), outmgrShow)
});

popTests = function(t, event) {
	var parts;
	if (t) parts = $(t).attr("href").split("?");
	else parts = gs.selection[0].data.Test.match(/href=\'[^\']+/)[0].substring(6).split("?");
	var queries = parts[1].split("&");
	var id = queries[0].split("=")[1];
	if (selected_qdpk1s.includes(id)) {
		id = selected_qdpk1s.join("_");
	}
	var d = new Date().getTime();
	var p = new Object();
	p["key"] = "t" + d;
	p["id"] = id;
	p["bburl"] = bburl;
	p["token"] = token;
	p["lang"] = lang;
	p["dbtype"] = dbtype;
	p["uid"] = uid;
	p["username"] = username;
	p["sessionHash"] = sessionHash;
	if (!isDebug()) {
		sessionStorage.setItem("t" + d, $.base64.encode(JSON.stringify(p)));
	} else {
		sessionStorage.setItem("t" + d, JSON.stringify(p));
	}
	var path = EAC.ui + "/EacTests.html";
	var url = location.protocol + "//" + location.host + path;
	var key = "t" + d;
	var windowName = key + ':::' + $.base64.encode(JSON.stringify(p));
	if (isDebug()) {
		windowName = key + ':::' + JSON.stringify(p);
	}
	window.open(url, windowName);
	if (event) event.preventDefault();
}
popRubrics = function(t, event, i, OA=false) {
	var x=gs.selection.map(y=>y.data), id=selected_qdpk1s.join('_');
	// If i is a row data object (from cell renderer), use it directly - no lookup needed
	// The row data is already the specific row for the clicked link, captured in the closure
	if (t && i && typeof i === 'object') {
		// i is the row data object passed from the cell renderer - use it directly
		if (!selected_qdpk1s.includes(i.id)) x=[i];
		id = i.id;
	} else if (t && typeof i === 'number') {
		// i is a row index - get the row data from the grid API
		// Use OA parameter directly - outcomes grid passes OA=true, rubrics grid passes OA=false
		// Fallback to mainscope.tab check only if OA was not explicitly set (for backward compatibility)
		var isOutcomesMode = OA === true;
		if (!isOutcomesMode && mainscope && mainscope.tab === 'outcomes') {
			isOutcomesMode = true;
		}
		var grid = mainscope[isOutcomesMode?'outcomes':'rubrics'].grid;
		if (grid && grid.api) {
			var rowNode = grid.api.getDisplayedRowAtIndex(i);
			if (rowNode && rowNode.data) {
				if (!selected_qdpk1s.includes(rowNode.data.id)) x=[rowNode.data];
				id = rowNode.data.id;
			}
		} else if (grid && grid.rowData && grid.rowData[i]) {
			// Fallback to rowData array if API is not available
			if (!selected_qdpk1s.includes(grid.rowData[i].id)) x=[grid.rowData[i]];
			id = grid.rowData[i].id;
		}
	}
	// Ensure we have valid data
	if (!x || x.length === 0 || !x[0] || !x[0].id) {
		console.error('popRubrics: Invalid row data', x, i);
		if (event) event.preventDefault();
		return false;
	}
	// Use OA parameter directly - outcomes grid links pass OA=true, rubrics grid links pass OA=false
	var key='t' + new Date().getTime(), p={key:key, id:id, bburl:bburl, token:token, lang:lang, dbtype:dbtype, org:false, uid:uid, ultrastatus:x[0].ultraStatus || x[0].ultrastatus || '', username:username, sessionHash:sessionHash, crs:x, sys:rubricHeaders, OA:OA, date_from:mainscope.date_from, date_to:mainscope.date_to};
	sessionStorage.setItem(key, isDebug() ? JSON.stringify(p) : Base64Encode(p));
	window.open(EAC.url+'EacRubrics.html', key);
	if (event) event.preventDefault();
	return false;
}

function MakeGoalDetail(event) {
	let rows = event.api.getSelectedRows(), selectedRoadmap = [], selectedPerformance = [];
	if (rows.length == 0) {
		mainscope.outMap.AddModel([]);
		if (mainscope.outMap.grid.api) {
			if (typeof mainscope.outMap.grid.api.setGridOption === 'function') {
				mainscope.outMap.grid.api.setGridOption('rowData', []);
			} else if (typeof mainscope.outMap.grid.api.setRowData === 'function') {
				mainscope.outMap.grid.api.setRowData([]);
			}
		}
		mainscope.outMap.title = $L.h_road_map.title;
		mainscope.studentGoal.AddModel([]);
		if (mainscope.studentGoal.grid.api) {
			if (typeof mainscope.studentGoal.grid.api.setGridOption === 'function') {
				mainscope.studentGoal.grid.api.setGridOption('rowData', []);
			} else if (typeof mainscope.studentGoal.grid.api.setRowData === 'function') {
				mainscope.studentGoal.grid.api.setRowData([]);
			}
		}
		mainscope.studentGoal.title = $L.h_student_goals.title;
		mainscope.goalGraph.map = false;
	} else {
		//let roadMapData = goalDetailData.filter(x=>x.gpk1==rows[0].gpk1);
		selectedRoadmap = SetDefault(roadmapData[rows[0].gpk1], []);
		selectedPerformance = SetDefault(studentData[rows[0].gpk1], []);
		/*for (let x of selectedRoadmap) {
			x.weighted = 0; //rows[0].average;
			x.average = $.precision(x.average, 1e-2);
			if (!x.course_id) x.course_id = '--';
			//if (x.course_id == '--') x.type = 'Outcome Assessment';
			//else x.type = x.rubric_row_pk1 ? $L.h_rubric_list.cols[0] : $L.h_test_list.cols[0];
		}*/
		mainscope.outMap.AddModel(selectedRoadmap);
		if (mainscope.outMap.grid.api) {
			if (typeof mainscope.outMap.grid.api.setGridOption === 'function') {
				mainscope.outMap.grid.api.setGridOption('rowData', selectedRoadmap);
			} else if (typeof mainscope.outMap.grid.api.setRowData === 'function') {
				mainscope.outMap.grid.api.setRowData(selectedRoadmap);
			}
		}
		mainscope.outMap.AutoSize();
		mainscope.outMap.title = `${$L.h_road_map.title} (${rows[0].goal})`;
		mainscope.studentGoal.AddModel(selectedPerformance);
		if (mainscope.studentGoal.grid.api) {
			if (typeof mainscope.studentGoal.grid.api.setGridOption === 'function') {
				mainscope.studentGoal.grid.api.setGridOption('rowData', selectedPerformance);
			} else if (typeof mainscope.studentGoal.grid.api.setRowData === 'function') {
				mainscope.studentGoal.grid.api.setRowData(selectedPerformance);
			}
		}
		mainscope.studentGoal.AutoSize();
		mainscope.studentGoal.title = `${$L.h_student_goals.title} (${rows[0].goal})`;
		if (mainscope.goalGraph.map == true) mainscope.changeGraph(true);
		else mainscope.goalGraph.map = true;
	}
}

class FilterGraph {
	constructor(mode) {
		this.nodes = [new FilterDate(this)];
		this.mode = mode;
	}
	Add() {
		if (this.mode=='outcomes') this.nodes.push(new FilterOutcomes(this));
	}
	Parse() {
		return this.nodes.map(x => x.Parse()).join(' ');
	}
	Pull() {
		this.nodes[0].Pull();
	}
	Push() {
		this.nodes[0].Push();
	}
	Remove() {
		this.nodes = this.nodes.filter(x=>x.active);
	}
}

class FilterNode {
	constructor(parent, type) {
		this.active = true;
		this.parent = parent;
		this.type = type;
	}
	Parse() {
		return '';
	}
	Remove() {
		this.active = false;
		this.parent.Remove();
	}
}

class FilterDate extends FilterNode {
	constructor(parent) {
		super(parent, 'date');
		this.ops = FilterProp(['Any in Range', 'All in Range'], ['0', '1']);
		this.o = this.ops[0].val;
	}
	Pull() {
		this.minDate = mainscope.minDate;
		this.maxDate = mainscope.maxDate;
	}
	Push() {
		mainscope.minDate = this.minDate;
		mainscope.maxDate = this.maxDate;
	}
}

class FilterText extends FilterNode {
	constructor(parent) {
		super(parent, 'text');
		this.ops = FilterProp($L.h_header_filters.text_comparisons, ["LIKE '%@F%'", "NOT LIKE '%@F%'", "= '@F'", "<> '@F'", "LIKE '@F%'", "LIKE '%@F'"]);
		this.o = this.ops[0].val;
		this.text = '';
	}
	Parse() {
		return `and UPPER(${this.c}) ${this.o.replace('@F', this.text.toUpperCase())}`;
	}
}

class FilterOutcomes extends FilterText {
	constructor(parent) {
		super(parent);
		this.cols = FilterProp($L.h_header_filters.outcomes_columns, ['r.title', 'eis.title']);
		this.c = this.cols[0].val;
	}
}

function FilterProp(names, vals) {
	let result = [];
	for (let i=0; i<names.length; ++i) result.push({name:names[i],val:vals[i]});
	return result;
}

let nHeader =`<div class="ag-cell-label-container" role="presentation">
		<span ref="eMenu" class="ag-header-icon ag-header-cell-menu-button"></span>
		<div ref="eLabel" class="ag-header-cell-label" role="presentation">
			<span ref="eText" class="ag-header-cell-text" role="columnheader"></span>
			<div style="margin-left:20px;" onclick="event.stopPropagation()" class="invisible header-ctr">
				<button class="header-btn" onclick="gs.degroup()" title="${$L.icon.deselect}">–</button>
				<button class="header-btn" onclick="gs.reselect()" title="${$L.icon.reselect}">+</button>
			</div>
			<span ref="eFilter" class="ag-header-icon ag-filter-icon"></span>
			<span ref="eSortOrder" class="ag-header-icon ag-sort-order" ></span>
			<span ref="eSortAsc" class="ag-header-icon ag-sort-ascending-icon" ></span>
			<span ref="eSortDesc" class="ag-header-icon ag-sort-descending-icon" ></span>
			<span ref="eSortNone" class="ag-header-icon ag-sort-none-icon" ></span>
		</div>
	</div>`;

window.stopProp = function(event) {
	event.stopPropagation();
};

function SQLConcat(data, key, level, finish, param, queries) {
	return SQLAsync((proms, host, theUrl) => {
		queries.forEach(x=>{proms.push(GetSqlAsync(theUrl, getParams(host, bburl, x, param)).then(ary=>{
			data[key] = data[key].concat(ary);
			parseProgress.resolve();
		})); });
	}, queries.length, level, finish);
}

let overviewData=[], roadmapData = {}, studentData = {}, maxTimestamp = 8640000000000000, metaAvg = 0, perfGoals = {}, perfOk = {}, goalPassPerc = 0.6;
class RoadMapItem {
	constructor(item) {
		this.scored = 0;
		this.average = 0;
		this.problem = 0;
		this.title = item.gm_title;
		this.rname = item.rname;
		this.type = item.type;
		this.date = item.ndate;
		this.course_id = item.course_id;
	}
}

async function getGoalsData(params, selectedGoals) {
	let queries = ['75a4e865-3696-410c-bb5d-722731009465', 'ea6b5190-e947-4b96-9c26-920556a49bb9', 'c428b1b9-1f51-426f-a92c-1de757c7f6b0', '7a27e4c4-8c67-42e1-afde-4a56be850731', '77d495a3-96d0-461e-8d9f-d969ad5af801', '559b3332-4ae5-4f88-9273-5fb935531561'], proms = [], counter = 0, minDate = new Date(maxTimestamp), maxDate = new Date(-maxTimestamp);
	overviewData = [];
	roadmapData = {};
	studentData = {};
	perfGoals = {};
	perfOk = {};
	metaAvg = 0;
	mainscope.metaScored = 0;
	if (mainscope.showOutcomes) queries.push('ab9f4aab-99b4-43d8-b6f9-858e216d2d22');
	for (let goal of selectedGoals) {
		let gpk1 = goal.data.clppk1;
		let param = Object.assign(rfdc()(params), {'@gpk1':gpk1});
		studentData[gpk1] = [];
		perfGoals[gpk1] = goal.label;
		proms.push(SQLConcat(studentData, gpk1, counter++, 0, param, queries));
		while (parseProgress.sent - parseProgress.ret > 10) await Timer(500);
	};
	await Promise.all(proms);
	parseProgress.reset(true);
	for (let goal of selectedGoals) {
		let goalData = SortObjAry(studentData[goal.data.clppk1],'course_id','gm_title','uemail'), num = 0, overallAvg = 0, roadmapGoal = {}, studentScores = {}, upass = 0;
		for (let item of goalData) {
			if (studentScores[item.user_pk1] === undefined) studentScores[item.user_pk1] = [];
			item.goalscore = $.precision(parseFloat(item.goalscore), 1e-2);
			item.ndate = new Date(item.ndate);
			item.type = $L.h_item_type[item.type];
			if (item.ndate > maxDate) maxDate = item.ndate;
			if (item.ndate < minDate) minDate = item.ndate;
			if (!item.course_id) item.course_id = '--';
			let hash = item.cpk1+'_'+item.gmpk1;
			if (roadmapGoal[hash] === undefined) roadmapGoal[hash] = new RoadMapItem(item);
			else if (item.ndate > roadmapGoal[hash].date) roadmapGoal[hash].date = item.ndate;
			if (item.goalscore >= 0 && item.goalscore <= 1) {
				++num;
				overallAvg += item.goalscore;
				++roadmapGoal[hash].scored;
				roadmapGoal[hash].average += item.goalscore;
				studentScores[item.user_pk1].push(item.goalscore);
			} else ++roadmapGoal[hash].problem;
		}
		for (upk1 in studentScores) {
			if ($S.mean(studentScores[upk1]) >= goalPassPerc) ++upass;
		}
		let uscored = Object.keys(studentScores).length;
		upass = uscored > 0 ? $.precision(upass / uscored, 1e-2) : '--';
		metaAvg += overallAvg;
		mainscope.metaScored += num;
		overallAvg = num > 0 ? $.precision(overallAvg / num, 1e-2) : '--';
		perfOk[goal.data.clppk1] = num > 0;
		overviewData.push({goal:goal.label, desc:goal.data.desc, scored:num, average:overallAvg, problem:goalData.length-num, gpk1:goal.data.clppk1, target:goalPassPerc, percentMet:upass});
		roadmapData[goal.data.clppk1] = Object.values(roadmapGoal).map(x => {
			x.weighted = overallAvg;
			if (x.scored > 0) x.average = $.precision(x.average / x.scored, 1e-2);
			else x.average = '--';
			return x;
		});
	}
	if (mainscope.metaScored > 0) metaAvg = $.precision(100 * metaAvg / mainscope.metaScored, 1e-2);
	else {
		metaAvg = null;
		alert($L.h_student_goals._empty);
	}
	mainscope.goalOverview.AddModel(overviewData);
	if (mainscope.goalOverview.grid.api) {
		if (typeof mainscope.goalOverview.grid.api.setGridOption === 'function') {
			mainscope.goalOverview.grid.api.setGridOption('rowData', overviewData);
		} else if (typeof mainscope.goalOverview.grid.api.setRowData === 'function') {
			mainscope.goalOverview.grid.api.setRowData(overviewData);
		}
	}
	mainscope.goalOverview.AutoSize();
	mainscope.goalOverview.title = $L.h_goal_overview.title + ` (${minDate.toLocaleDateString()} - ${maxDate.toLocaleDateString()})`;
	mainscope.changeGraph(false);
	mainscope.loading = false;
}

// Angular App Definition
var app = angular.module('App', ['ngMaterial', 'ngMessages', 'ngRoute', 'ngSanitize', 'ngAnimate'])
	.controller('Ctrl', function ($scope, $window, $interval, $timeout, $mdDialog){
		mainscope = $scope;
		Object.assign($scope, {loading:true, spt:'', title:['EAC Visual Data', 'Measuring Success'], tab:SetDefault(dashTabs[0],''), minDate:new Date(), maxDate:new Date(), modes:[], mode:settings.mode, programs:[], program:settings.node, dateMinInvalid:false, dateMaxInvalid:false, dateFormat:/^\d{1,2}\/\d{1,2}\/\d{4}$/, dateElements:$('md-datepicker > div > input'), dateFocus:0, settings:settings, showSettings:false, showNodes:false, filter:'', languages:langList, $L:$L, prevLang:settings.language, showOutcomes:false, metaScored:0, outSelected:false, filterGraph:new FilterGraph('outcomes'), permissions:permissions, dashTabs:dashTabs, selectedTerms:[], terms:[], searchTerm:'', showTerms:false, termPk1s:'', goThreshold:0.6, goalChart:{index:0}});

		$scope.goThresholdChange = function(value) {
			$scope.goThreshold = value;
			goalPassPerc = value;
			let rowData = $scope.goalOverview.grid.rowData;
			if (rowData.length == 0 || !$scope.goalOverview.grid.api) return;

			$scope.goalOverview.grid.api.forEachNode(node => {
				let goalData = studentData[node.data.gpk1], studentScores = {}, upass = 0;
				for (let item of goalData) {
					if (studentScores[item.user_pk1] === undefined) studentScores[item.user_pk1] = [];
					item.goalscore = $.precision(parseFloat(item.goalscore), 1e-2);
					if (item.goalscore >= 0 && item.goalscore <= 1) studentScores[item.user_pk1].push(item.goalscore);
				}
				for (upk1 in studentScores) {
					if ($S.mean(studentScores[upk1]) >= goalPassPerc) ++upass;
				}
				let uscored = Object.keys(studentScores).length;
				upass = uscored > 0 ? $.precision(upass / uscored, 1e-2) : '--';
				node.setDataValue('target', value);
				node.setDataValue('percentMet', upass);
			});
			if (!$scope.chartRoadmap) {
				$scope.goalGraph.chart.data.datasets[2].data = $scope.goalOverview.grid.rowData.map(x=>isNaN(x.percentMet)?'':$.precision(x.percentMet*100, 1));
				$scope.goalGraph.chart.update();
			}
		};

		$scope.TermsUpdate = function() {
			$scope.termPk1s = $scope.selectedTerms.length ? ` and t.pk1 in (${$scope.selectedTerms.map(x => x.pk1).join()}) ` : '';
			if (isDebug()) console.log($scope.termPk1s);
		};
		$scope.TermsFilter = function() {
			if (!terms || !Array.isArray(terms)) return [];
			const searchTerm = ($scope.searchTerm || '').toLowerCase();
			return terms.filter(x => {
				if (!x || !x.name) return false;
				return x.name.toLowerCase().includes(searchTerm) && (x.crs!='0' || $scope.showTerms);
			});
		};
		$scope.TermsClose = function() {
			$scope.searchTerm = '';
			$scope.TermsUpdate();
		};
		$scope.TermsClear = function() {
			$scope.selectedTerms = [];
			$scope.TermsUpdate();
		};

		$scope.InitDates = function() {
			$scope.minDate.setDate($scope.minDate.getDate()-7);
			$scope.maxDate.setDate($scope.maxDate.getDate()+1);
		};
		$scope.InitDates();
		
		$scope.err = {show:false, comment:true, text:"", send:function(){
			errData.comment = $scope.err.text;
			console.log(errData);
			send(errData);
			$scope.err.show = false;
			$scope.err.text = "";
		}};
		$scope.OpenSettings = function() {
			$scope.prevLang = $scope.settings.language;
			$scope.showSettings=true;
		}
		$scope.CheckTab = function(tabname) {
			return !$scope.showSettings && $scope.tab==tabname ? 'shade':'';
		}
		$scope.CloseSettings = function(close) {
			let today = new Date();
			$scope.showSettings = false;
			storedObject.set(uid, $scope.settings);
			settings = $scope.settings;
			if (close) return;
			if ($scope.prevLang != $scope.settings.language) {
				LoadLang($scope.settings.language);
				storedObject.set('lang', $L, !isDebug());
				location.reload();
			}
		}
		$scope.ResetSettings = function() {
			$scope.settings = settings_default;
			storedObject.set(uid, $scope.settings);
			$scope.InitDates();
		}
		$scope.CheckDate = function() {
			let invalid = [false, false];
			$scope.dateElements[($scope.dateFocus+2)%4].value = $scope.dateElements[$scope.dateFocus].value;
			/*for (let i of [0,1]) {
				let s = $scope.dateElements[i].value
				if ($scope.dateFormat.test(s)) {
					s = s.replace(/0*(\d*)/gi,"$1");
					let dateArray = s.split(/[\.|\/|-]/);
					dateArray[1] = dateArray[1]-1;
					let testDate = new Date(dateArray[2], dateArray[0], dateArray[1]); // MM/DD/YYYY
					invalid.push(testDate.getDate()!=dateArray[1] || testDate.getMonth()!=dateArray[0] || testDate.getFullYear()!=dateArray[2]);
				} else invalid[i] = true;
			}*/
			$scope.dateMinInvalid = invalid[0] || $scope.minDate<0 || $scope.minDate>$scope.maxDate;
			$scope.dateMaxInvalid = invalid[1] || $scope.maxDate<0 || $scope.minDate>$scope.maxDate;
		}
		if (license) $interval($scope.CheckDate, 500);

		$scope.ChangeNode = function() {
			domain_pk1 = $scope.programs[$scope.program].domain_pk1;
			domain_name = $scope.programs[$scope.program].name;
		}
		$scope.GetGS = function() {
			return (gs.group.length == 0) ? LangArg($L.selected_format, 0, 0) : LangArg($L.selected_format, gs.selection.length, gs.group.length);
		};
		$scope.GSgo = function() {
			if (gs.selection.length < 1) return;
			if ($scope.tab == 'tests') popTests();
			else if ($scope.tab == 'rubrics') popRubrics();
			else if ($scope.tab == 'outcomes') popRubrics(false, false, false, true);
		};
		$scope.GSok = function() {
			return gs.selection.length > 0;
		};
		$scope.GetProgram = function() {
			return $scope.programs.length>0?$scope.programs[$scope.program].name:"";
		}
		$scope.GetReport = function() {
			return gs.selection.length>0 ? gs.selection[0].data.Name : "";
		}
		
		$scope.Go = function() {
			$scope.Clear();
			cancel = false;
			$scope.loading = true;
			mainscope.metaScored = 0;
			if ($scope.tab == 'outcomes') $scope.filterGraph.Push();
			if ($scope.programs.length > 0) $scope.ChangeNode();
			$scope.date_from = addTime($scope.minDate, '00:00:00 UTC', 0);
			$scope.date_to = addTime($scope.maxDate, '23:59:59 UTC', 999);
			let cancelled = false;
			modeData = new ModeData($scope.mode, mode_pk1s);
			if (!$scope.filter && modeData.isEnt && ['tests', 'rubrics'].includes($scope.tab)) {
				alert($L.msg.filter);
				$scope.loading = false;
				return;
			}
			if ($scope.tab == 'tests' && permissions.tt) {
				gs = new GridSelector($scope.tests.grid);
				cancelled = getAllTheTests2(uid, modeData.name, modeData.filter, $scope.date_to, $scope.date_from, $scope.filter || "", isOracle, domain_pk1);
			} else if ($scope.tab == 'rubrics' && permissions.rt) {
				gs = new GridSelector($scope.rubrics.grid);
				let rubricNames=$scope.filter||'',fields=rubricNames.split('||'),fc=filterCourse();
				fc.set_expression("r.title");
				fc.set_textbox(fields[0]);
				let gm = fc.getSql(), css = addCourseFilter(fields[1]);
				if (css.length>0) gm = (gm.length>0 ? gm+' ' : '')+css;
				cancelled=GetRubricsAsync(uid,$scope.date_to, $scope.date_from, {cf:modeData.filter, im:modeData.itoken, gm:gm, em:modeData.etoken, am:modeData.atoken}, true);
			} else if ($scope.tab == 'outcomes' && permissions.ot) {
				gs = new GridSelector($scope.outcomes.grid);
				cancelled=GetRubricsAsync(uid, $scope.date_to, $scope.date_from, $scope.filterGraph.Parse());
			} else if ($scope.tab == 'goals' && permissions.gt) {
				window.open(EAC.url+'EacGoals.html');
				$scope.loading = false;
				//cancelled = getGoalsParts(uid, mode, modefilter, $scope.termPk1s, $scope.date_to, $scope.date_from, $scope.filter || "", $scope.nOutcomes.parts(), goalCats);
				//let params = [getSqlDate($scope.date_from), getSqlDate($scope.date_to), $scope.termPk1s, modefilter].reduce((a,x,i)=>{a['$'+i+'$']=x; return a;},{});
				//Object.assign(params, {'@uid':uid, '--@I':mode=='instructor'?' ':' -- ', '--@E':(mode=='enterprise'&&!isDebug())?' ':' -- '});
				//getGoalsData(params, $scope.nOutcomes.selected);
			}
			//if (cancelled) $scope.loading = false;
		};
		$scope.GoDisabled = function() {
			return $scope.dateMinInvalid || $scope.dateMaxInvalid || ($scope.tab == 'goals' && $scope.nOutcomes.selected.length == 0);
		}
		$scope.Finish = function(data) {
			if (cancel) return;
			$scope[$scope.tab].AddModel(data);
			$scope.loading = false;
			parseProgress.reset();
		};
		$scope.Cancel = function() {
			if (!nReady || !gReady) return;
			cancel = true;
			parseProgress.reset();
			$scope.loading = false;
			$scope.Clear();
		};
		
		//Outcomes Tab Functions
		$scope.CheckOut = function() {
			if ($scope.outcomes.grid && $scope.outcomes.grid.api) {
				let outrows = $scope.outcomes.grid.api.getSelectedRows();
				$scope.outSelected = outrows.length>0 ? outrows[0] : false;
			} else $scope.outSelected = false;
			if ($scope.$apply) $scope.$apply();
		};
		$scope.FilterOut = function() {
			if ($scope.outcomes.grid && $scope.outcomes.grid.api) $scope.outcomes.grid.api.deselectAll();
			$scope.outSelected = false;
			if ($scope.$apply) $scope.$apply();
		};
	// Cell renderers: RubricCellRenderer for rubrics (OA=false), OutcomeCellRenderer for outcomes (OA=true)
	$scope.RenderOut = 'outcomeCellRenderer';
	$scope.RenderRubric = 'rubricCellRenderer';
		
		// tests
		$scope.tests = new GridBox({
			mode:'tests',
			title:$L.h_test_list.title,
			keys:['Test', 'CourseName', 'CourseID', 'Date', 'Instructors'],
			headers:$L.h_test_list.cols,
			model:[],
			props:{ rowSelection:'multiple', suppressRowClickSelection:true, onSelectionChanged:gs.select, onFilterChanged:gs.degroup },
			//auto:['Test', 'CourseID', 'Date', 'Instructors'],
			auto:['CourseName', 'CourseID', 'Date', 'Instructors'],
			autoIfNeeded:true,
			colProps:[[0], { cellRenderer:(x => x.value), checkboxSelection:true, cellClassRules:{'highlightbg':gs.inGroup}, headerClass:'header-left', flex:1, suppressSizeToFit:true, minWidth:500, filter:true }, [1], { minWidth:250 }, [2], { minWidth:250 }, [3], { minWidth:100 }, [4], { minWidth:500 }],
			sheet:['Name', 'CourseName', 'CourseID', 'Date', 'Instructors'],
			sheetNames:$L.h_test_list.sheet,
			pdfkeys:{sheet:true}
		});
		// rubrics
		$scope.rubrics = new GridBox({
			mode:'rubrics',
			title:$L.h_rubric_list.title,
			keys:['rtitle', 'Assignment', 'CourseName', 'CourseID', 'Date', 'Instructors'],
			headers:$L.h_rubric_list.cols,
			model:[],
			props:{ rowSelection:'multiple', suppressRowClickSelection:true, onSelectionChanged:gs.select, onFilterChanged:gs.degroup },
			//auto:['rtitle', 'CourseName', 'CourseID', 'Date', 'Instructors'],
			auto:['Assignment', 'CourseName', 'CourseID', 'Date', 'Instructors'],
			autoIfNeeded:true,
			colProps:[[0], { cellRenderer:'rubricCellRenderer', checkboxSelection:true, cellClassRules:{'highlightbg':gs.inGroup}, headerClass:'header-left', wrapText:true, autoHeight:true, flex:1, suppressSizeToFit:true, minWidth:500, filter:true }, [1], { minWidth:250 }, [2], { minWidth:250 }, [3], { minWidth:250 }, [4], { minWidth:100 }, [5], { minWidth:500 }],
			sheet:['Name', 'Assignment', 'CourseName', 'CourseID', 'Date', 'Instructors'],
			sheetNames:$L.h_rubric_list.sheet,
			pdfkeys:{sheet:true}
		});
		$scope.outcomes = new GridBox({
			mode:'outcomes',
			title:$L.h_outcomes_list.title,
			keys:['rname', 'eis_title', 'rdate'],
			headers:$L.h_outcomes_list.cols,
			model:[],
			auto:['rdate'],
			autoIfNeeded:true,
			props:{ rowSelection:'multiple', suppressRowClickSelection:true, onSelectionChanged:gs.select, onFilterChanged:gs.degroup },
			colProps:[[0], { cellRenderer:'outcomeCellRenderer', checkboxSelection:true, cellClassRules:{'highlightbg':gs.inGroup}, headerClass:'header-left', wrapText:true, autoHeight:true, flex:1, suppressSizeToFit:true, minWidth:500, filter:true }, [1], { minWidth:400 }],
			//params=>params.data.rtype!='T'}]
		});
		$scope.outMap = new GridBox({
			mode:'goalMap',
			title:$L.h_road_map.title,
			sheetTitle:$L.h_road_map.title,
			keys:['title', 'rname', 'type','date','course_id','scored','average','weighted'],
			headers:$L.h_road_map.cols,
			model:[],
			auto:['type','date','course_id','scored','average','weighted'],
			autoIfNeeded:true,
			ntypes:[undefined,undefined,undefined,undefined,undefined,'int','float','float']
		});
		$scope.studentGoal = new GridBox({
			mode:'studentGoalPerf',
			title:$L.h_student_goals.title,
			sheetTitle:$L.h_student_goals.worksheet,
			keys:['goal', 'term', 'course_id','course_name','gm_title','rname','item','type','ulastname','ufirstname','uemail','usr_batch_uid','student_id','goalscore','ndate'],
			headers:$L.h_student_goals.cols,
			model:[],
			auto:true,
			autoIfNeeded:true
		});
		$scope.goalOverview = new GridBox({
			mode:'goalOverview',
			title:$L.h_goal_overview.title,
			sheetTitle:$L.h_goal_overview.title,
			keys:['goal', 'desc', 'scored', 'average', 'target', 'percentMet'],
			headers:$L.h_goal_overview.cols,
			props:{rowSelection:'single', suppressRowClickSelection:true, onSelectionChanged:MakeGoalDetail},
			colProps:[[0],{checkboxSelection:true}, [1],{minWidth:150}],
			model:[],
			auto:['goal', 'scored', 'average', 'target', 'percentMet'],
			ntypes:[undefined,undefined,'int','float', 'float', 'float']
		});
		$scope.goalGraph = {
			id:'goalGraph',
			pid:'goalGraphParent',
			init:function(){},
			title:$L.h_goal_graph.title,
			filename:$L.h_goal_graph.title,
			map:false
		};
		$scope.changeGraph = function(map) {
			let dateRange = ` (${$scope.minDate.toLocaleDateString()} - ${$scope.maxDate.toLocaleDateString()})`;
			$scope.chartRoadmap = map;
			if (mainscope.goalGraph.chart) mainscope.goalGraph.chart.destroy();
			if (map) {
				let roadMapLabels = $scope.outMap.grid.rowData.map((x,i)=>`${i+1}. ${Trunc(x.title)} (${x.scored})`);
				$scope.goalChart.index = 1;
				$scope.goalGraph.chart = new Chart($scope.goalGraph.id, {
					type: 'bar',
					data: {
						labels: roadMapLabels,
						datasets: [{
							label: $L.h_goal_graph.data[0],
							data: $scope.outMap.grid.rowData.map((x,i) => { return {x:x.weighted*100, y:roadMapLabels[i]}; }),
							borderColor: 'rgba(225, 112, 9, 1)',
							backgroundColor: 'rgba(225, 112, 9, 0.5)',
							type: 'line',
							datalabels: {display: false}
						}, {
							type: 'bar',
							label: $L.h_goal_graph.data[1],
							borderWidth: 1,
							borderColor: 'rgba(0, 105, 170, 1)',
							backgroundColor: 'rgba(0, 105, 170, 0.5)',
							data: $scope.outMap.grid.rowData.map(x=>isNaN(x.average)?'':x.average*100)
						}]
					},
					options: {
						scales: {
							x: {position:'top', min:0, max:100, ticks: {callback:(value)=>value+'%'}},
							y: {scaleLabel:{display:true, labelString:$L.h_goal_graph.axis2}}
						},
						indexAxis: 'y',
						responsive: true,
						maintainAspectRatio: false,
						interaction: {mode: 'index'},
						plugins: {
							title:{display:true,text:$L.h_road_map.title+dateRange},
							datalabels: {formatter: (value, context) => $scope.outMap.grid.rowData[context.dataIndex].scored>0 ? $.precision(value, 1)+'%' : '', display: showDatalabel},
							tooltip: {
								callbacks: {
									title:items => $scope.outMap.grid.rowData[items[0].dataIndex].title,
									afterTitle:items => $L.h_road_map.cols[2]+': '+$scope.outMap.grid.rowData[items[0].dataIndex].type,
									beforeBody:items => $L.h_road_map.cols[5]+': '+$scope.outMap.grid.rowData[items[0].dataIndex].scored,
									label: item => item.dataset.label + ': ' + (item.raw.x ? item.raw.x : item.raw) + '%',
									beforeFooter:items => $L.h_road_map.cols[4]+': '+$scope.outMap.grid.rowData[items[0].dataIndex].course_id
								}
							}
						}
					}
				});
				$('#'+$scope.goalGraph.pid).height(Math.max($scope.outMap.grid.rowData.length*48 + 96, 225));
				$scope.goalGraph.chart.update();
				$scope.goalGraph.filename = $scope.outMap.title;
			} else if ($scope.goalOverview.grid.rowData.length > 0) {
				let overviewLabels = $scope.goalOverview.grid.rowData.map((x,i)=>`${i+1}. ${Trunc(x.goal)} (${x.scored})`), overviewDatasets = [{
					type: 'bar',
					label: $L.h_goal_graph.data[1],
					borderWidth: 1,
					borderColor: 'rgba(0, 105, 170, 1)',
					backgroundColor: 'rgba(0, 105, 170, 0.5)',
					data: $scope.goalOverview.grid.rowData.map(x=>isNaN(x.average)?'':x.average*100)
				}, {
					type: 'bar',
					label: $L.h_goal_overview.cols[5],
					borderWidth: 1,
					borderColor: 'rgba(254, 188, 56, 1)',
					backgroundColor: 'rgba(254, 188, 56, 0.75)',
					data: $scope.goalOverview.grid.rowData.map(x=>isNaN(x.percentMet)?'':$.precision(x.percentMet*100, 1))
				}];
				if (metaAvg !== null) overviewDatasets.unshift({
					label: $L.h_goal_graph.data[0],
					data: $scope.goalOverview.grid.rowData.map((x,i) => { return {x:metaAvg, y:overviewLabels[i]}; }),
					borderColor: 'rgba(225, 112, 9, 1)',
					backgroundColor: 'rgba(225, 112, 9, 1)',
					type: 'line',
					datalabels: {display: false}
				});
				$scope.goalGraph.chart = new Chart($scope.goalGraph.id, {
					type: 'bar',
					data: {
						labels: overviewLabels,
						datasets: overviewDatasets
					},
					options: {
						scales: {
							x: {position:'top', min:0, max:100, ticks: {callback:(value)=>value+'%'}},
							y: {scaleLabel:{display:true, labelString:$L.h_goal_graph.axis}}
						},
						indexAxis: 'y',
						responsive: true,
						maintainAspectRatio: false,
						interaction: {mode: 'index'},
						plugins: {
							title: {display:true, text:$L.h_goal_overview.title+dateRange},
							datalabels: {formatter: (value, context) => $.precision(value, 1)+'%', display: showDatalabel},
							tooltip: {
								callbacks: {
									title:items => $scope.goalOverview.grid.rowData[items[0].dataIndex].goal,
									beforeBody:items => $L.h_goal_overview.cols[2]+': '+$scope.goalOverview.grid.rowData[items[0].dataIndex].scored,
									label: item => item.dataset.label + ': ' + (item.raw.x ? item.raw.x : item.raw) + '%'
								}
							}
						}
					}
				});
				$scope.chartRoadmap = false;
				$('#'+$scope.goalGraph.pid).height(Math.max($scope.goalOverview.grid.rowData.length*48 + 96, 225));
				$scope.goalGraph.chart.update();
				$scope.goalGraph.filename = $scope.goalOverview.title;
			}
		}
		
		$scope.Clear = function(clearGoals) {
			$scope.tests.AddModel([]);
			$scope.outMap.AddModel([]);
			$scope.studentGoal.AddModel([]);
			$scope.rubrics.AddModel([]);
			$scope.outcomes.AddModel([]);
			$scope.outSelected = false;
			$scope.goalGraph.map = false;
			$scope.goalOverview.AddModel([]);
			if (clearGoals && $scope.nOutcomes) $scope.nOutcomes.reset();
			$scope.outMap.title = $L.h_road_map.title;
			$scope.goalOverview.title = $L.h_goal_overview.title;
			if ($scope.goalGraph.chart) $scope.goalGraph.chart.destroy();
		};

		$scope.ForceGroup = function() {
			return forceGroup;
		}
		
		// Tab loading and initialization
		$scope.loadTab = function(name) {
			if (name != 'goals') $scope.Clear(true);
			if (name == 'outcomes') $scope.filterGraph.Pull();
			else if ($scope.tab == 'outcomes') $scope.filterGraph.Push();
			gs = new GridSelector();
			mainscope.metaScored = 0;
			$scope.tab = name;
			//$scope.AutoGo();
		};
		$scope.AutoGo = function() {
			$scope.loading = true;
			if ($scope[$scope.tab].grid.api != undefined) $scope.Go();
			else $timeout($scope.AutoGo, 50);
		};
		$scope.OnReady = function() {
			if (!nReady || !gReady) return $timeout($scope.OnReady, 50);
			$scope.terms = terms;
			$scope.nOutcomes = new GoalSelector(goalCats, true);
			if (permissions.ot && (oaUser || $scope.modes.includes('enterprise'))) $scope.showOutcomes = true;
			if ($scope.tab=='outcomes'||($scope.showOutcomes&&$scope.tab=='')) $scope.loadTab('outcomes');
			$scope.loading = false;
		};
		$scope.OnReady();
		
		$scope.newGoals = function() {
			window.open('EacGoals.html', '_blank');
		};

		$scope.EX = { canvas:function(filename) {
			goalGraph.canvas.toBlob(function(blob) {
				saveAs(blob, filename);
			});
		}};
		$scope.GoalsDownload = function() {
			let wb = XLSX.utils.book_new();
			$scope.goalOverview.GetSheet(wb, true);
			for (let key in studentData) {
				if (!perfOk[key]) continue;
				let tmp = new GridBox({
					mode:'tmp',
					title:`${$L.h_student_goals.title} (${perfGoals[key]})`,
					sheetTitle:perfGoals[key],
					keys:['goal', 'term', 'course_id','course_name','gm_title','rname','item','type','ulastname','ufirstname','uemail','usr_batch_uid','student_id','goalscore','ndate'],
					headers:$L.h_student_goals.cols,
					model:studentData[key]
				});
				tmp.GetSheet(wb, true);
			}
			XLSX.writeFile(wb, `${$L.h_student_goals.worksheet} - ${new Date().toISOString()}.xlsx`);
		};
	});
EacAppSetup(app);
